/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging.impl;

import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.LogRecord;
import oracle.core.ojdl.logging.impl.LoggingListener;

public class LoggingNotificationHandler {
    private AtomicReference<LoggingListener[]> m_listeners = new AtomicReference();
    private static LoggingNotificationHandler s_instance = new LoggingNotificationHandler();

    public static LoggingNotificationHandler getInstance() {
        return s_instance;
    }

    public void recordLogged(LogRecord rec) {
        LoggingListener[] listeners = this.m_listeners.get();
        if (listeners == null) {
            return;
        }
        for (LoggingListener listener : listeners) {
            listener.recordLogged(rec);
        }
    }

    public synchronized void addListener(LoggingListener newListener) {
        LoggingListener[] listeners = this.m_listeners.get();
        if (listeners == null) {
            listeners = new LoggingListener[]{newListener};
            this.m_listeners.set(listeners);
            return;
        }
        for (LoggingListener listener : listeners) {
            if (listener != newListener) continue;
            return;
        }
        LoggingListener[] newListeners = new LoggingListener[listeners.length + 1];
        for (int i = 0; i < listeners.length; ++i) {
            newListeners[i] = listeners[i];
        }
        newListeners[listeners.length] = newListener;
        this.m_listeners.set(newListeners);
    }

    public synchronized void removeListener(LoggingListener listener) {
        LoggingListener[] listeners = this.m_listeners.get();
        if (listeners == null) {
            return;
        }
        LoggingListener[] newListeners = new LoggingListener[listeners.length - 1];
        int j = 0;
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] == listener) continue;
            if (j == newListeners.length) {
                return;
            }
            newListeners[j++] = listeners[i];
        }
        this.m_listeners.set(newListeners);
    }
}

