/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.cmp.transport.ErrorTCPMsg;
import oracle.security.crypto.cmp.transport.FinalTCPMsg;
import oracle.security.crypto.cmp.transport.PKIRequestTCPMsg;
import oracle.security.crypto.cmp.transport.PKIResponseTCPMsg;
import oracle.security.crypto.cmp.transport.PollRequestTCPMsg;
import oracle.security.crypto.cmp.transport.PollResponseTCPMsg;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public abstract class TCPMessage
implements Streamable {
    private Version version;
    private boolean[] flags;
    private transient byte[] contents;

    protected TCPMessage() {
        this(Version.CMP2000);
    }

    protected TCPMessage(Version version) {
        this.version = version;
        this.flags = new boolean[8 * TCPMessage.getNumFlagBytes(version)];
    }

    private static int getNumFlagBytes(Version version) {
        if (version == Version.CMP1999) {
            return 1;
        }
        if (version == Version.CMP2000) {
            return 1;
        }
        throw new IllegalArgumentException("Flags size unknown for version " + version);
    }

    public Version getVersion() {
        return this.version;
    }

    public abstract Type getType();

    public void setFlag(Flag flag) {
        int i = flag.getValue();
        if (i >= this.flags.length) {
            throw new IllegalArgumentException("Flags bit index " + i + " invalid for version " + this.version);
        }
        this.flags[i] = true;
    }

    public boolean hasFlag(Flag flag) {
        int i = flag.getValue();
        return i < this.flags.length ? this.flags[i] : false;
    }

    public static TCPMessage inputInstance(InputStream is) throws IOException {
        int len = Utils.inputWord((InputStream)is);
        byte[] msgBytes = new byte[4 + len];
        int off = 0;
        System.arraycopy(Utils.wordToBytes((int)len), 0, msgBytes, off, 4);
        off += 4;
        int ver = is.read() & 0xFF;
        Version version = Version.getVersion(ver);
        if (version == null) {
            throw new VersionException("Unsupported PKI TCP transport version: " + ver);
        }
        msgBytes[off++] = (byte)ver;
        int flagLen = TCPMessage.getNumFlagBytes(version);
        Utils.inputByteArray((byte[])msgBytes, (int)off, (int)flagLen, (InputStream)is);
        off += flagLen;
        int type = is.read() & 0xFF;
        msgBytes[off++] = (byte)type;
        Utils.inputByteArray((byte[])msgBytes, (int)off, (int)(len - 1 - flagLen - 1), (InputStream)is);
        UnsyncByteArrayInputStream bis = new UnsyncByteArrayInputStream(msgBytes);
        switch (type) {
            case 0: {
                return new PKIRequestTCPMsg((InputStream)bis);
            }
            case 1: {
                return new PollResponseTCPMsg((InputStream)bis);
            }
            case 2: {
                return new PollRequestTCPMsg((InputStream)bis);
            }
            case 3: {
                return new FinalTCPMsg((InputStream)bis);
            }
            case 5: {
                return new PKIResponseTCPMsg((InputStream)bis);
            }
            case 6: {
                return new ErrorTCPMsg((InputStream)bis);
            }
        }
        throw new InvalidInputException("Unexpected PKI TCP message type: " + type);
    }

    abstract byte[] getValueBytes();

    abstract void setValueBytes(byte[] var1);

    abstract void clearCache();

    public void input(InputStream is) throws IOException {
        int len = Utils.inputWord((InputStream)is);
        int ver = is.read() & 0xFF;
        this.version = Version.getVersion(ver);
        if (this.version == null) {
            throw new VersionException("Unsupported PKI TCP transport version: " + ver);
        }
        byte[] flags = Utils.inputBytes((InputStream)is, (int)TCPMessage.getNumFlagBytes(this.version));
        for (int b = 0; b < flags.length; ++b) {
            for (int i = 0; i < 8; ++i) {
                if ((flags[b] & 1 << i) == 0) continue;
                this.setFlag(Flag.LIST[8 * b + i]);
            }
        }
        int type = is.read() & 0xFF;
        if (this.getType() != Type.LIST[type]) {
            throw new InvalidInputException("Unexpected PKI TCP message type: " + Type.LIST[type]);
        }
        this.setValueBytes(Utils.inputBytes((InputStream)is, (int)(len - 1 - flags.length - 1)));
        this.update();
    }

    public void output(OutputStream os) throws IOException {
        os.write(this.toByteArray());
    }

    public int length() {
        return this.toByteArray().length;
    }

    void update() {
        this.contents = null;
        this.clearCache();
    }

    private byte[] toByteArray() {
        if (this.contents == null) {
            int verByte = this.version.getValue();
            byte[] flagBytes = new byte[TCPMessage.getNumFlagBytes(this.version)];
            int b = 0;
            for (int i = 0; i < this.flags.length; ++i) {
                if (i > 0 && i % 8 == 0) {
                    ++b;
                }
                if (!this.flags[i]) continue;
                int n = b;
                flagBytes[n] = (byte)(flagBytes[n] | 1 << i % 8);
            }
            int typeByte = this.getType().getValue();
            byte[] valueBytes = this.getValueBytes();
            int len = 1 + flagBytes.length + 1 + valueBytes.length;
            byte[] lenBytes = Utils.wordToBytes((int)len);
            try {
                FixedByteArrayOutputStream baos = new FixedByteArrayOutputStream(len + lenBytes.length);
                baos.write(lenBytes);
                baos.write(verByte);
                baos.write(flagBytes);
                baos.write(typeByte);
                baos.write(valueBytes);
                this.contents = baos.toByteArray();
            }
            catch (IOException e) {
                throw new StreamableOutputException("Error generating TCP message bytes");
            }
        }
        return this.contents;
    }

    public static class Version {
        public static final Version CMP1999 = new Version(-1);
        public static final Version CMP2000 = new Version(10);
        private static final Version[] LIST = new Version[]{CMP1999, CMP2000};
        private int value;

        static Version getVersion(int v) {
            switch (v) {
                case -1: {
                    return CMP1999;
                }
                case 10: {
                    return CMP2000;
                }
            }
            return null;
        }

        private Version(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case -1: {
                    return "CMP1999";
                }
                case 10: {
                    return "CMP2000";
                }
            }
            return "CMP TCP v" + this.value;
        }
    }

    public static class Flag {
        public static final Flag CLOSE_CONNECTION = new Flag(0);
        private static final Flag[] LIST = new Flag[]{CLOSE_CONNECTION};
        private int value;

        private Flag(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 0: {
                    return "CLOSE_CONNECTION";
                }
            }
            return "flag" + this.value;
        }
    }

    public static class Type {
        public static final Type PKI_REQ = new Type(0);
        public static final Type POLL_REP = new Type(1);
        public static final Type POLL_REQ = new Type(2);
        public static final Type FIN_REP = new Type(3);
        private static final Type UNUSED = new Type(4);
        public static final Type PKI_REP = new Type(5);
        public static final Type ERROR_MSG_REP = new Type(6);
        private static final Type[] LIST = new Type[]{PKI_REQ, POLL_REP, POLL_REQ, FIN_REP, UNUSED, PKI_REP, ERROR_MSG_REP};
        private int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 0: {
                    return "pkiReq";
                }
                case 1: {
                    return "pollRep";
                }
                case 2: {
                    return "pollReq";
                }
                case 3: {
                    return "finRep";
                }
                case 5: {
                    return "pkiRep";
                }
                case 6: {
                    return "errorMsgRep";
                }
            }
            return "type" + this.value;
        }
    }
}

