/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.attribute.ArchiveRemGenPrivKeyArchOpt;
import oracle.security.crypto.cmp.attribute.EncryptedPrivKeyArchOpt;
import oracle.security.crypto.cmp.attribute.KeyGenParamsArchOpt;
import oracle.security.crypto.cmp.attribute.RegistrationControl;

public abstract class PKIArchiveOptionRegControl
extends RegistrationControl {
    private static final ASN1ObjectID TYPE = CMP.id_regCtrl_pkiArchiveOptions;

    protected PKIArchiveOptionRegControl() {
        super(TYPE, null);
    }

    public static PKIArchiveOptionRegControl inputArchiveOption(InputStream is) throws IOException {
        PKIArchiveOptionRegControl arch;
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        ASN1ObjectID type = new ASN1ObjectID((InputStream)sis);
        int tag = sis.getCurrentTag();
        ASN1Object value = ASN1Utils.inputASN1Object((InputStream)sis);
        sis.terminate();
        if (!type.equals((Object)TYPE)) {
            throw new IOException("Wrong PKI Type: " + type);
        }
        switch (tag) {
            case 0: {
                arch = new EncryptedPrivKeyArchOpt();
                break;
            }
            case 1: {
                arch = new KeyGenParamsArchOpt();
                break;
            }
            case 2: {
                arch = new ArchiveRemGenPrivKeyArchOpt();
                break;
            }
            default: {
                throw new ASN1FormatException("Unexpected pkiArchiveOptions tag: " + tag);
            }
        }
        arch.setValue(value);
        return arch;
    }
}

