/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cmp.EncryptedValue;
import oracle.security.crypto.cmp.attribute.PKIArchiveOptionRegControl;
import oracle.security.crypto.cms.CMSEnvelopedDataContentInfo;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.Utils;

public class EncryptedPrivKeyArchOpt
extends PKIArchiveOptionRegControl {
    private EncryptedValue encryptedKey;
    private CMSEnvelopedDataContentInfo envelopedKey;

    public EncryptedPrivKeyArchOpt() {
    }

    public EncryptedPrivKeyArchOpt(EncryptedValue encryptedKey) {
        this();
        this.encryptedKey = encryptedKey;
    }

    public EncryptedPrivKeyArchOpt(CMSEnvelopedDataContentInfo envelopedKey) {
        this();
        this.envelopedKey = envelopedKey;
    }

    public EncryptedPrivKeyArchOpt(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public EncryptedValue getEncryptedKey() {
        this.decodeValue();
        return this.encryptedKey;
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            if (this.encryptedKey != null) {
                this.setValue((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.encryptedKey, 0));
            } else if (this.envelopedKey != null) {
                this.setValue((ASN1Object)new ASN1GenericConstructed(ASN1Utils.addImplicitTag((ASN1Object)this.envelopedKey, (int)0), 0));
            }
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            try {
                ASN1ConstructedInputStream cis = new ASN1ConstructedInputStream(Utils.toStream((Streamable)this.getValue()), 0);
                if (cis.getCurrentTag() == 0) {
                    cis.setCurrentTag(16);
                    this.envelopedKey = new CMSEnvelopedDataContentInfo((InputStream)cis);
                    this.encryptedKey = null;
                } else {
                    this.encryptedKey = new EncryptedValue((InputStream)cis);
                    this.envelopedKey = null;
                }
                cis.terminate();
            }
            catch (IOException ex) {
                throw new StreamableInputException(ex.toString());
            }
            this.decoded = true;
        }
    }
}

