/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc.wallet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import oracle.dbtools.core.io.InputOutputStreams;

public final class DatabaseToolsProperties {
    private static final DatabaseToolsProperties EMPTY = new DatabaseToolsProperties(Collections.emptyMap());
    private static final String SERVICE_ALIAS_PROPERTY = "oracle.dbtools.service";
    private static final String HTTPS_PROXY_PROPERTY = "oracle.dbtools.https.proxy";
    private final Map<String, String> props;

    public static final Builder builder() {
        return new Builder();
    }

    public static final Builder builder(String serviceAlias) {
        return new Builder().serviceAlias(serviceAlias);
    }

    public static final Builder builder(InputStream content) throws IOException {
        Builder b = new Builder();
        try (Reader reader = InputOutputStreams.instance().reader(content);){
            Properties props = new Properties();
            props.load(reader);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String name = entry.getKey().toString();
                String value = entry.getValue().toString();
                b.set(name, value);
            }
        }
        return b;
    }

    public static final Builder builder(Map<String, String> props) {
        return new Builder(props);
    }

    public static final DatabaseToolsProperties empty() {
        return EMPTY;
    }

    public static final DatabaseToolsProperties read(InputStream content) throws IOException {
        return DatabaseToolsProperties.builder(content).build();
    }

    private DatabaseToolsProperties(Map<String, String> props) {
        this.props = Collections.unmodifiableMap(props != null ? new TreeMap<String, String>(props) : new TreeMap());
    }

    public InputStream asInputStream() throws IOException {
        StringWriter payload = new StringWriter();
        Properties props = new Properties();
        props.putAll(this.props);
        props.store(payload, null);
        return InputOutputStreams.instance().asInputStream(payload.toString());
    }

    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    public Builder modify() {
        return DatabaseToolsProperties.builder(this.props);
    }

    public String serviceAlias() {
        return this.props.get(SERVICE_ALIAS_PROPERTY);
    }

    public URI httpsProxy() {
        String text = this.props.get(HTTPS_PROXY_PROPERTY);
        if (text == null) {
            return null;
        }
        return URI.create(text);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.props);
        return b.toString();
    }

    public void write(OutputStream out) throws IOException {
        Writer w = InputOutputStreams.instance().writer(out);
        Properties props = new Properties();
        props.putAll(this.props);
        props.store(w, null);
    }

    public static final class Builder {
        private final Map<String, String> props;

        private Builder() {
            this(null);
        }

        private Builder(Map<String, String> props) {
            this.props = props != null ? new LinkedHashMap<String, String>(props) : new LinkedHashMap();
        }

        public DatabaseToolsProperties build() {
            return new DatabaseToolsProperties(this.props);
        }

        public Builder serviceAlias(String serviceAlias) {
            this.set(DatabaseToolsProperties.SERVICE_ALIAS_PROPERTY, serviceAlias);
            return this;
        }

        public Builder httpsProxy(URI httpsProxy) {
            if (httpsProxy == null) {
                this.set(DatabaseToolsProperties.HTTPS_PROXY_PROPERTY, null);
            } else {
                this.set(DatabaseToolsProperties.HTTPS_PROXY_PROPERTY, httpsProxy.toASCIIString());
            }
            return this;
        }

        private Builder set(String name, String value) {
            if (value == null) {
                this.props.remove(name);
            } else {
                this.props.put(name, value);
            }
            return this;
        }
    }
}

