/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import oracle.aurora.server.tools.loadjava.ClassifyFiles;
import oracle.aurora.server.tools.loadjava.DatabaseOptions;
import oracle.aurora.server.tools.loadjava.DropJavaOptions;
import oracle.aurora.server.tools.loadjava.LoadJavaConstants;
import oracle.aurora.server.tools.loadjava.LoadJavaLog;
import oracle.aurora.server.tools.loadjava.LoadJavaOptions;
import oracle.aurora.server.tools.loadjava.LoadJavaState;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.OptionFile;
import oracle.aurora.server.tools.loadjava.Options;
import oracle.aurora.server.tools.loadjava.SchemaObject;
import oracle.aurora.server.tools.loadjava.ToolsError;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.aurora.util.IOCopy;
import oracle.aurora.util.msg.Msg;

public class DropJava
implements LoadJavaConstants {
    private Msg mkMsg = MkMsg.mkMsg;
    private IOCopy ioCopy = new IOCopy();
    private int usageErrorCount = 0;
    private ClassifyFiles classifier;
    private LoadJavaState state;
    private SchemaObject currentJar;

    public DropJava() {
        this(new DropJavaOptions());
    }

    public DropJava(DropJavaOptions opts) {
        this(opts, null, null);
    }

    public DropJava(DropJavaOptions opts, DatabaseOptions database, LoadJavaLog log) {
        try {
            this.initialize(opts);
            this.getState().setDatabase(database);
            this.getState().setLog(log);
        }
        catch (ToolsException ignore) {
            // empty catch block
        }
    }

    void initialize(DropJavaOptions opts) throws ToolsException {
        this.usageErrorCount = 0;
        this.classifier = new ClassifyFiles(opts);
        LoadJavaOptions ljOpts = new LoadJavaOptions(opts);
        this.checkUserExists(ljOpts.getLoadSchema());
        this.checkUserExists(ljOpts.getTableSchema());
    }

    void checkUserExists(String schema) throws ToolsException {
        if (schema != null && !this.state.getJdbc().userExists(schema)) {
            String e = this.mkMsg.m("schema {0} does not exist ", schema);
            this.err(e);
            throw new ToolsException(e);
        }
    }

    void reset() {
        if (this.state != null) {
            this.state.resetStmts();
        }
    }

    LoadJavaState getState() {
        if (this.state == null) {
            this.state = new LoadJavaState();
        }
        return this.state;
    }

    ClassifyFiles getClassifier() {
        if (this.classifier == null) {
            this.classifier = new ClassifyFiles(this.getOpts());
        }
        return this.classifier;
    }

    void err(Exception ex, String when) {
        this.getState().err(ex, when);
    }

    void err(String msg) {
        this.getState().err(msg);
    }

    void msg(String what) {
        this.getState().msg(what);
    }

    void warn(String what) {
        this.getState().warn(what);
    }

    public DropJavaOptions getOpts() {
        return (DropJavaOptions)this.getState().getOpts();
    }

    public Options getGenericOpts() {
        return this.getOpts();
    }

    public void set(String option) {
        this.set(option, Boolean.TRUE);
    }

    public void set(String option, Object value) {
        this.getOpts().set(option, value);
    }

    public void setOutput(PrintWriter output) {
        this.getState().getLog().setWriter(output);
    }

    public void setLog(LoadJavaLog log) {
        this.getState().setLog(log);
    }

    public void setConnection(Connection conn) {
        this.getState().setConnection(conn);
    }

    public void setDatabase(DatabaseOptions db) {
        if (db != null) {
            this.getState().setDatabase(db);
        }
    }

    public void dropName(String name, DropJavaOptions opts) {
        if (opts == null) {
            opts = this.getOpts();
        }
        if (this.getClassifier().isURL(name)) {
            InputStream in = null;
            URL u = null;
            Proxy proxy = null;
            URLConnection uc = null;
            try {
                u = new URL(name);
                if (this.getOpts().getBoolean("-proxy")) {
                    String spec = this.getOpts().getString("-proxy");
                    int index = spec.indexOf(58);
                    if (index == -1) {
                        throw new IllegalArgumentException("Proxy address incorrectly  specified " + spec);
                    }
                    String host = spec.substring(0, index);
                    int port = Integer.parseInt(spec.substring(index + 1));
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
                    uc = u.openConnection(proxy);
                } else {
                    uc = u.openConnection();
                }
                uc.setConnectTimeout(3000);
                in = uc.getInputStream();
                if (uc.getContentLength() == 0) {
                    this.warn(name + " is empty");
                } else {
                    this.drop(in, u.getPath(), opts);
                }
            }
            catch (MalformedURLException mue) {
                this.err(mue, "malformed url: " + u.toString());
            }
            catch (UnknownHostException uhe) {
                this.err(uhe, "host not found for url " + u.toString());
            }
            catch (IOException ex) {
                this.err(ex, "opening url " + u.toString());
            }
            return;
        }
        File file = this.getClassifier().mkFile(name);
        boolean exists = false;
        try {
            exists = file.exists();
        }
        catch (SecurityException sex) {
            // empty catch block
        }
        if (exists) {
            this.drop(file, opts);
        } else {
            this.dropAll(this.classifier.transformName(name), opts);
        }
    }

    void dropNames(String[] names, DropJavaOptions opts) {
        for (int xName = 0; xName < names.length; ++xName) {
            this.dropName(names[xName], opts);
        }
    }

    void drop(File file, DropJavaOptions opts) {
        try {
            FileInputStream in = new FileInputStream(file);
            this.drop(in, file.getPath(), opts);
        }
        catch (IOException ex) {
            this.err(ex, this.mkMsg.m("opening file {0}", file.toString()));
            this.dropAll(this.classifier.transformName(file.getPath()), opts);
        }
    }

    void drop(InputStream in, String name, DropJavaOptions opts) {
        int type = this.classifier.typeFromName(name);
        this.drop(type, in, name, opts);
    }

    void drop(int type, InputStream in, String name, DropJavaOptions opts) {
        if (type == 1002 && opts.getBoolean("-jarasresource")) {
            type = 30;
        }
        in = this.ioCopy.toBuffered(in);
        switch (type) {
            case 1002: {
                this.dropJar(in, name, opts);
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                String sName = this.classifier.transformName(name);
                SchemaObject object = SchemaObject.mk(type, this.getState(), new LoadJavaOptions(opts), in, sName);
                this.drop(object);
                break;
            }
            case 1003: {
                this.drop(30, in, name, opts);
            }
        }
    }

    boolean drop(SchemaObject object) {
        boolean ok;
        if (object.getOpts().getBoolean("-install") && object.isSysObj()) {
            return true;
        }
        if (this.currentJar != null) {
            this.currentJar.noteContainedObject(object);
        }
        this.msg(this.mkMsg.m("dropping: {0}", object.toString()));
        if (object.getOpts().getString("-publish") != null) {
            object.addPublish();
        }
        if (!this.getState().MD5TableIsObsolete()) {
            object.deleteMD5();
            this.getState().getJdbc().executeDDL("COMMIT", "commiting MD5 table for " + object);
        }
        if (object.getType() == 29 && object.getOpts().getBoolean("-synonym")) {
            this.msg(this.mkMsg.m("dropping: synonym for {0}", object.toString()));
            object.dropSynonym();
        }
        if (this.currentJar != null) {
            ok = true;
        } else if (object.status() == 3) {
            ok = true;
            this.warn("not found: " + object);
        } else {
            ok = object.drop();
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropJar(InputStream in, String name, DropJavaOptions opts) {
        ZipInputStream jar = new ZipInputStream(in);
        ClassifyFiles oldClassifier = this.classifier;
        SchemaObject oldCurrentJar = this.currentJar;
        if (!this.getOpts().getBoolean("-recursivejars")) {
            LoadJavaOptions jarOpts = new LoadJavaOptions(this.getOpts());
            jarOpts.set("-jarasresource");
            this.classifier = new ClassifyFiles(jarOpts);
        }
        try {
            boolean jarExistsAsServerObject;
            opts = new DropJavaOptions(opts);
            int count = 0;
            String oen = "META-INF/loadjava-options";
            SchemaObject newCurrentJar = SchemaObject.mk(1002, this.getState(), new LoadJavaOptions(opts), in, name);
            newCurrentJar.setPrepend(this.getOpts().getBoolean("-prependjarnames"));
            boolean nested = this.currentJar != null;
            newCurrentJar.setNested(nested);
            boolean bl = jarExistsAsServerObject = !nested && newCurrentJar.status() != 3;
            if (jarExistsAsServerObject) {
                this.drop(newCurrentJar);
            }
            if (nested || jarExistsAsServerObject) {
                this.currentJar = newCurrentJar;
            }
            ZipEntry currentEntry = this.getNextEntry(jar);
            while (currentEntry != null) {
                if (!currentEntry.isDirectory()) {
                    if (currentEntry.getName().equals(oen)) {
                        OptionFile newOptionFile = new OptionFile(this.getState(), jar);
                        opts.setOptionFile(newOptionFile);
                        if (count > 0) {
                            this.warn("Processed " + oen + " in " + name + " after some entries had already been processed." + " Some options may not be effective ");
                        }
                    } else {
                        ++count;
                        if (this.getOpts().getBoolean("-jdkready")) {
                            this.drop(null, currentEntry.getName(), opts);
                        } else {
                            this.drop(jar, currentEntry.getName(), opts);
                        }
                    }
                }
                jar.closeEntry();
                currentEntry = this.getNextEntry(jar);
            }
        }
        catch (IOException ioex) {
            this.err(ioex, this.mkMsg.m("reading {0}", name));
        }
        finally {
            this.classifier = oldClassifier;
            this.currentJar = oldCurrentJar;
        }
    }

    private ZipEntry getNextEntry(ZipInputStream jar) throws IOException, ZipException {
        ZipEntry entry;
        try {
            entry = jar.getNextEntry();
        }
        catch (EOFException eof) {
            entry = null;
        }
        return entry;
    }

    boolean tryDrop(int type, String name, DropJavaOptions opts) {
        SchemaObject object = SchemaObject.mk(type, this.getState(), new LoadJavaOptions(opts), null, name);
        boolean done = false;
        if (object.status() != 3) {
            done = this.drop(object);
        }
        return done;
    }

    boolean dropAll(String name, DropJavaOptions opts) {
        boolean found = false;
        boolean bl = found = this.tryDrop(28, name, opts) || found;
        if (!found) {
            found = this.tryDrop(29, name, opts) || found;
        }
        found = this.tryDrop(30, name, opts) || found;
        boolean bl2 = found = this.tryDrop(1002, name, opts) || found;
        if (found) {
            return true;
        }
        String slashName = name.replace('.', '/');
        if (!name.equals(slashName)) {
            found = this.tryDrop(29, slashName, opts);
            boolean bl3 = found = this.tryDrop(28, slashName, opts) || found;
        }
        if (!found) {
            if (!name.equals(slashName)) {
                SchemaObject.mkError(this.getState(), new LoadJavaOptions(opts), slashName, "looking up").deleteMD5();
            }
            this.drop(SchemaObject.mkError(this.getState(), new LoadJavaOptions(this.getOpts()), name, "looking up"));
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void command(String[] argv) throws ToolsException {
        block16: {
            try {
                Options.Args args = new Options.Args(argv);
                DropJavaOptions djOpts = new DropJavaOptions();
                djOpts.parseArgs(args);
                this.getState().parseArgs(args, (Options)djOpts);
                this.initialize(djOpts);
                String[] files = args.unused();
                for (int xFile = 0; xFile < files.length; ++xFile) {
                    if (files[xFile].length() == 0) {
                        this.usageErr(this.mkMsg.m("an empty argument was supplied"));
                        continue;
                    }
                    if (files[xFile].charAt(0) != '-') continue;
                    this.usageErr(this.mkMsg.m("unrecognized or badly formed option {0}", files[xFile]));
                }
                if (this.getOpts().getBoolean("-help")) {
                    this.err("dropjava: " + DropJavaOptions.helpMessage());
                    break block16;
                }
                if (files.length == 0 && !this.getOpts().getBoolean("-nousage") && !this.getOpts().getBoolean("-listfile")) {
                    this.usageMessage();
                    break block16;
                }
                if (this.usageErrorCount > 0) {
                    this.usageMessage();
                    break block16;
                }
                try {
                    this.getOpts().setOptionFile(this.getState().getOptionFile());
                    if (this.getOpts().getBoolean("-l") || this.getOpts().getBoolean("-listfile")) {
                        if (this.getOpts().getBoolean("-listfile")) {
                            files = this.processList(this.getOpts().getString("-listfile"));
                        }
                        for (int i = 0; i < files.length; ++i) {
                            if (this.getClassifier().isJarFile(files[i])) {
                                this.getState().warn("-list does not support dropping jars");
                                continue;
                            }
                            this.dropAll(this.classifier.transformName(files[i]), this.getOpts());
                        }
                    } else {
                        this.dropNames(files, this.getOpts());
                    }
                    this.getState().getPublish().dropPackages();
                }
                catch (ToolsError ex) {
                    throw new ToolsException(ex.getMessage(), ex);
                }
                catch (SchemaObject.SchemaObjectError ex) {
                    throw new ToolsException(ex.getMessage(), ex);
                }
            }
            finally {
                this.reset();
            }
        }
    }

    void usageErr(String msg) {
        this.err(msg);
        ++this.usageErrorCount;
    }

    void usageMessage() {
        this.err("dropjava: " + DropJavaOptions.usageMessage());
    }

    String[] processList(String name) throws ToolsException {
        Vector<String> lstrings = new Vector<String>();
        try {
            String line;
            BufferedReader lf = new BufferedReader(new InputStreamReader(new FileInputStream(name)));
            while ((line = lf.readLine()) != null) {
                lstrings.addElement(line.trim());
            }
        }
        catch (IOException ioe) {
            this.err(ioe, "while reading listfile " + name);
            throw new ToolsException(ioe);
        }
        Object[] strings = new String[lstrings.size()];
        lstrings.copyInto(strings);
        return strings;
    }
}

