/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.io.PrintWriter;
import java.io.Writer;
import oracle.aurora.compiler.ErrorPosition;
import oracle.aurora.compiler.ErrorReporter;
import oracle.aurora.compiler.TooManyErrorsException;

public class SimpleErrorReporter
implements ErrorReporter {
    PrintWriter out;
    String identification;
    boolean useLocator = true;
    int warningCount = 0;
    int errorCount = 0;

    public SimpleErrorReporter(Writer out) {
        this.out = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
    }

    public SimpleErrorReporter(Writer out, boolean useLocator) {
        this(out);
        this.useLocator = useLocator;
    }

    private String identificationOf(ErrorPosition position) {
        String fileName = null;
        if (position != null && position.getSource() != null) {
            fileName = position.getSource().getPath();
        }
        if (position != null && fileName == null) {
            fileName = position.getIdentification();
        }
        if (fileName == null) {
            fileName = this.identification;
        }
        return fileName;
    }

    void emitCarat(ErrorPosition position) {
        String lineString = position.getLineString();
        int column = position.getColumn();
        if (lineString != null && column > 0) {
            int offset = column - 1;
            this.out.println(lineString);
            if (offset >= lineString.length()) {
                offset = lineString.length();
            }
            StringBuffer marker = new StringBuffer();
            for (int j = 0; j < offset; ++j) {
                char c = lineString.charAt(j);
                marker.append(c == '\t' ? (char)'\t' : ' ');
            }
            marker.append('^');
            this.out.println(marker.toString());
        }
    }

    public void report(ErrorPosition position, int level, String message) throws TooManyErrorsException {
        String fileName = this.identificationOf(position);
        int line = position.getLine() + 1;
        String lineString = position.getLineString();
        int column = position.getColumn();
        boolean haveFile = fileName != null;
        boolean haveLine = line > 0;
        boolean haveColumn = column > 0;
        boolean haveLocator = lineString != null && this.useLocator;
        boolean haveMessage = message != null && message.length() > 0;
        String fileNameString = haveFile ? fileName + ":" : "";
        String lineNumberString = haveLine ? Integer.toString(line) : "";
        String colNumberString = haveColumn && !haveLocator ? "." + column : "";
        String colon = haveLine || haveColumn && !haveLocator ? ":" : "";
        String space = haveMessage && !Character.isWhitespace(message.charAt(0)) ? " " : "";
        String messageString = haveMessage ? message : "";
        this.out.println(fileNameString + lineNumberString + colNumberString + colon + space + messageString);
        if (haveLocator && this.useLocator) {
            this.emitCarat(position);
        }
        if (level == 2) {
            ++this.errorCount;
        } else if (level == 1) {
            ++this.warningCount;
        }
    }

    public void setSource(String s) {
        this.identification = s == null ? "<no source>" : s;
    }

    public void close() {
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }
}

