/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.logging;

import ilog.views.IlvPoint;
import java.util.Map;
import java.util.Set;
import oracle.diagram.logging.EmphasizedMessage;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;

public class DiagramLogPage
extends MessagePage {
    private static final String DIAGRAM_LOG_ID = "DiagramLog";
    private static final String DIAGRAM_LOG_NAME = "Diagram Log";
    private static DiagramLogPage LOG_PAGE;

    protected DiagramLogPage() {
        super(new ViewId(DIAGRAM_LOG_ID, DIAGRAM_LOG_NAME), null, false, true);
    }

    public static DiagramLogPage makeDiagramLogPage() {
        if (LOG_PAGE == null) {
            LOG_PAGE = new DiagramLogPage();
            LogManager.getLogManager().addPage((LogPage)LOG_PAGE);
        }
        return LOG_PAGE;
    }

    public void logThreadStackTrace(Thread thread) {
        this.logMsg((Object)new EmphasizedMessage("Thread: " + thread.getName() + "\n"));
        StackTraceElement[] stackTrace = thread.getStackTrace();
        boolean myTrace = Thread.currentThread().equals(thread);
        for (StackTraceElement e : stackTrace) {
            if (!myTrace) {
                this.logMsg("    " + e.toString() + "\n");
                continue;
            }
            myTrace = false;
        }
        this.logMsg("\n");
    }

    public void logStackTrace() {
        this.logThreadStackTrace(Thread.currentThread());
    }

    public void logAllStackTraces() {
        Map<Thread, StackTraceElement[]> stMap = Thread.getAllStackTraces();
        Set<Thread> threads = stMap.keySet();
        for (Thread t : threads) {
            this.logThreadStackTrace(t);
        }
    }

    public void logPointArray(IlvPoint[] points, String message) {
        DiagramLogPage msgPage = DiagramLogPage.makeDiagramLogPage();
        if (message != null) {
            msgPage.log((Object)new EmphasizedMessage("--- " + message + " ---\n"));
        }
        for (IlvPoint p : points) {
            msgPage.log("[" + p.x + "," + p.y + "]\n");
        }
        if (message != null) {
            msgPage.log((Object)new EmphasizedMessage("--- " + message + " ---\n"));
        }
    }
}

