/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link.connector;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvPolicyAwareLinkImage;
import ilog.views.linkconnector.IlvClippingLinkConnector;
import java.awt.geom.Point2D;
import oracle.diagram.framework.link.LinkUtil;
import oracle.diagram.framework.link.connector.DiagramFrameworkConnector;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.transformer.TransformerUtil;

public class ClipLinkConnector
extends DiagramFrameworkConnector {
    public ClipLinkConnector(IlvGraphic node) {
        super(node);
    }

    public ClipLinkConnector(IlvLinkImage link, boolean origin) {
        super(link, origin);
    }

    public IlvPoint getConnectionPoint(IlvLinkImage link, boolean origin, IlvTransformer trans) {
        IlvPoint interPoint;
        boolean isHorizontalToOtherBox;
        IlvTransformer otherEndTrans;
        if (link.getGraphicBag() == null) {
            return super.getConnectionPoint(link, origin, trans);
        }
        if (!(link instanceof IlvPolicyAwareLinkImage)) {
            return super.getConnectionPoint(link, origin, trans);
        }
        IlvTransformer localTrans = origin ? link.getFromTransformer(TransformerUtil.IDENTITY_TRANSFORMER) : link.getToTransformer(TransformerUtil.IDENTITY_TRANSFORMER);
        IlvPoint attachPoint = this.getUnclippedConnectionPoint(link, origin, localTrans);
        IlvLinkConnector otherEndConnector = IlvLinkConnector.Get((IlvLinkImage)link, (!origin ? 1 : 0) != 0);
        if (otherEndConnector == null) {
            return super.getConnectionPoint(link, origin, trans);
        }
        IlvTransformer ilvTransformer = otherEndTrans = origin ? link.getToTransformer(TransformerUtil.IDENTITY_TRANSFORMER) : link.getFromTransformer(TransformerUtil.IDENTITY_TRANSFORMER);
        IlvPoint controlPoint = otherEndConnector instanceof IlvClippingLinkConnector ? ((IlvClippingLinkConnector)otherEndConnector).getUnclippedConnectionPoint(link, !origin, otherEndTrans) : otherEndConnector.getConnectionPoint(link, !origin, otherEndTrans);
        if (controlPoint == null) {
            controlPoint = attachPoint;
        }
        if (link.getPointsCardinal() != 2) {
            controlPoint = link.getPointAt(origin ? 1 : link.getPointsCardinal() - 2, TransformerUtil.IDENTITY_TRANSFORMER);
        }
        IlvRect fromBox = LinkUtil.getFromBoundingBox(link, TransformerUtil.IDENTITY_TRANSFORMER);
        IlvRect toBox = LinkUtil.getToBoundingBox(link, TransformerUtil.IDENTITY_TRANSFORMER);
        boolean isOtherEndHorizontalToMe = LinkUtil.isHorizontalToRectangle(controlPoint, origin ? fromBox : toBox);
        boolean isHorizontalToBox = LinkUtil.isHorizontalToRectangle(attachPoint, origin ? fromBox : toBox);
        if (isHorizontalToBox != (isHorizontalToOtherBox = LinkUtil.isHorizontalToRectangle(controlPoint, origin ? toBox : fromBox))) {
            if (link.getPointsCardinal() == 2) {
                if (origin) {
                    intermediatePoint = isHorizontalToBox ? new IlvPoint(controlPoint.x, attachPoint.y) : new IlvPoint(attachPoint.x, controlPoint.y);
                    interPoint = fromBox.contains((double)intermediatePoint.x, (double)intermediatePoint.y) ? this.getClippedPoint(this.getNode(), localTrans, link, intermediatePoint, controlPoint, origin) : this.getClippedPoint(this.getNode(), localTrans, link, attachPoint, intermediatePoint, origin);
                } else {
                    intermediatePoint = isHorizontalToOtherBox ? new IlvPoint(attachPoint.x, controlPoint.y) : new IlvPoint(controlPoint.x, attachPoint.y);
                    interPoint = fromBox.contains((double)intermediatePoint.x, (double)intermediatePoint.y) ? this.getClippedPoint(this.getNode(), localTrans, link, attachPoint, intermediatePoint, origin) : this.getClippedPoint(this.getNode(), localTrans, link, intermediatePoint, controlPoint, origin);
                }
            } else {
                interPoint = super.getConnectionPoint(link, origin, localTrans);
            }
        } else if (link.getPointsCardinal() == 2) {
            IlvPoint p2;
            IlvPoint p1;
            if (isHorizontalToBox) {
                float middleX = (attachPoint.x + controlPoint.x) / 2.0f;
                p1 = new IlvPoint(middleX, attachPoint.y);
                p2 = new IlvPoint(middleX, controlPoint.y);
            } else {
                float middleY = (attachPoint.y + controlPoint.y) / 2.0f;
                p1 = new IlvPoint(attachPoint.x, middleY);
                p2 = new IlvPoint(controlPoint.x, middleY);
            }
            interPoint = fromBox.contains((Point2D)p1) ? (fromBox.contains((Point2D)p2) ? (origin ? this.getClippedPoint(this.getNode(), localTrans, link, p2, controlPoint, origin) : this.getClippedPoint(this.getNode(), localTrans, link, attachPoint, p1, origin)) : (origin ? this.getClippedPoint(this.getNode(), localTrans, link, p1, p2, origin) : this.getClippedPoint(this.getNode(), localTrans, link, p2, p1, origin))) : (fromBox.contains((Point2D)p2) ? (origin ? this.getClippedPoint(this.getNode(), localTrans, link, p2, p1, origin) : this.getClippedPoint(this.getNode(), localTrans, link, p1, p2, origin)) : (origin ? this.getClippedPoint(this.getNode(), localTrans, link, attachPoint, p1, origin) : this.getClippedPoint(this.getNode(), localTrans, link, p2, controlPoint, origin)));
        } else if (isOtherEndHorizontalToMe) {
            intermediatePoint = new IlvPoint(attachPoint.x, controlPoint.y);
            interPoint = this.getClippedPoint(this.getNode(), localTrans, link, intermediatePoint, controlPoint, origin);
        } else {
            intermediatePoint = new IlvPoint(controlPoint.x, attachPoint.y);
            interPoint = this.getClippedPoint(this.getNode(), localTrans, link, intermediatePoint, controlPoint, origin);
        }
        IlvManager linkManager = ManagerUtil.getManager((IlvGraphic)link);
        IlvManager nodeManager = ManagerUtil.getManager(this.getNode());
        IlvTransformer finalTransformer = ManagerUtil.getConversionTransformer(linkManager, nodeManager);
        IlvTransformer invTrans = new IlvTransformer();
        finalTransformer.computeInverse(invTrans);
        invTrans.apply(interPoint);
        if (trans != null) {
            trans.apply(interPoint);
        }
        return new IlvPoint(interPoint);
    }
}

