/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.highlight;

import ilog.views.IlvGraphic;
import java.util.HashSet;
import java.util.Set;
import oracle.diagram.framework.highlight.ShapeHighlighter;

public class ShapeHighlighterDecorator {
    private ShapeHighlighter m_highlighter;
    private Set<IlvGraphic> m_highlightedGraphics = new HashSet<IlvGraphic>();

    public ShapeHighlighterDecorator(ShapeHighlighter shapeHighlighter) {
        if (shapeHighlighter == null) {
            throw new IllegalArgumentException("shapeHighlighter is null");
        }
        this.m_highlighter = shapeHighlighter;
    }

    public void highlightGraphic(IlvGraphic graphic, boolean immediateRedraw) {
        this.m_highlighter.highlightGraphic(graphic, immediateRedraw);
        this.m_highlightedGraphics.add(graphic);
    }

    public void unhighlightGraphic(IlvGraphic graphic, boolean immediateRedraw) {
        this.m_highlighter.unhighlightGraphic(graphic, immediateRedraw);
        this.m_highlightedGraphics.remove(graphic);
    }

    public void reset() {
        for (IlvGraphic graphic : this.m_highlightedGraphics) {
            this.m_highlighter.unhighlightGraphic(graphic, false);
        }
        this.m_highlightedGraphics.clear();
    }

    public void showHighlighters(boolean immediateRedraw) {
        this.m_highlighter.showHighlighters(immediateRedraw);
    }

    public void hideHighlighters(boolean immediateRedraw) {
        this.m_highlighter.hideHighlighters(immediateRedraw);
    }
}

