/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvHandlesSelection;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.graphic.composite.layout.IlvStackerLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ContainerGraphic;
import oracle.diagram.framework.graphic.DiagramLabelInterface;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.FontInterface;
import oracle.diagram.framework.graphic.selection.TextSelection;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.shape.SubShape;
import oracle.diagram.framework.transformer.TransformerUtil;
import oracle.ide.thumbnail.ThumbnailConstants;

public class SingleLineText
extends ContainerGraphic
implements ExtendedGraphic,
FontInterface,
SubShape,
DiagramLabelInterface {
    private static final Font DEFAULT_FONT = new Font("SanSerif", 0, 11);
    private static final String ITALIC_EXTRA = "/";
    private IlvText _text;
    boolean m_isUnderlined;
    private Cursor m_cursor;
    private final CopyOnWriteArraySet<TextChangeListener> listeners = new CopyOnWriteArraySet();

    @Override
    public Cursor getCursor() {
        if (this.m_cursor == null) {
            if (this.isEditable()) {
                return Cursor.getPredefinedCursor(2);
            }
            return Cursor.getPredefinedCursor(0);
        }
        return this.m_cursor;
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.m_cursor = cursor;
    }

    public final void addTextChangeListener(TextChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireTextChangeListeners(String oldText, String newText) {
        for (TextChangeListener listener : this.listeners) {
            listener.textChange(oldText, newText);
        }
    }

    public static SingleLineText createUneditableSingleLineText(String text) {
        SingleLineText obj = new SingleLineText(text);
        obj.setEditable(false);
        SubSelectionManager.setSelectable((IlvGraphic)obj, false);
        return obj;
    }

    public static SingleLineText createEditableSingleLineText(String text, boolean selectable) {
        SingleLineText obj = new SingleLineText(text);
        SubSelectionManager.setSelectable((IlvGraphic)obj, selectable);
        return obj;
    }

    public SingleLineText(String text) {
        super((IlvLayoutManager)new IlvStackerLayout(0, 3, 0));
        this.setEditable(true);
        this._text = new IlvText(new IlvPoint(), text);
        this._text.setWrappingMode((short)0);
        this._text.setAnchorPosition(16);
        this.setChildren(0, (IlvGraphic)this._text);
        SubSelectionManager.setSelectable((IlvGraphic)this, true);
        this._text.setFont(DEFAULT_FONT);
        this.setUnderlined(DEFAULT_FONT);
        this._text.setAntialiasing(true);
        this._text.setFractionalMetrics(false);
        SubSelectionManager.setSelectable((IlvGraphic)this._text, false);
    }

    public String getLabel() {
        return this._text.getLabel();
    }

    public void setLabel(String label) {
        String oldText = this.getLabel();
        this._text.setLabel(label);
        this.fireTextChangeListeners(oldText, label);
        this.invalidate(true);
    }

    public boolean supportMultiline() {
        return false;
    }

    public IlvRect getLabelBBox(IlvTransformer t) {
        return this._text.getLabelBBox(t);
    }

    public IlvSelection makeSelection() {
        return new TextSelection((IlvGraphic)this);
    }

    @Override
    public DimensionFloat getMinimumSize(DimensionFloat minimum) {
        float MIN_WIDTH = 10.0f;
        IlvRect rect = this._text.getLabelBBox(null);
        minimum.setSize(10.0f, rect.height);
        return minimum;
    }

    @Override
    public DimensionFloat getPreferedSize(DimensionFloat prefered) {
        IlvRect rect = this._text.getLabelBBox(null);
        prefered.setSize(rect.width, rect.height);
        return prefered;
    }

    public void setFont(Font font) {
        this._text.setFont(font);
        this.setUnderlined(font);
        this.invalidate(true);
    }

    private void setUnderlined(Font font) {
        if (font == null) {
            return;
        }
        Map<TextAttribute, ?> attributes = font.getAttributes();
        Object underlined = attributes.get(TextAttribute.UNDERLINE);
        this.m_isUnderlined = underlined != null && underlined.equals(TextAttribute.UNDERLINE_ON);
    }

    public Font getFont() {
        return this._text.getFont();
    }

    @Override
    public void setFontColor(Color color) {
        this._text.setForeground(color);
    }

    public Paint getBackground() {
        return this._text.getFillPaint();
    }

    public void setBackground(Paint background) {
        this._text.setFillPaint(background);
    }

    @Override
    public Color getFontColor() {
        return this._text.getForeground();
    }

    @Override
    protected Area calculateClipArea(Graphics g, IlvTransformer t) {
        IlvRect clipRect = this._text.boundingBox();
        clipRect.height = (float)((double)clipRect.height + 0.5);
        clipRect.width = (float)((double)clipRect.width + 1.0);
        if (this.isTopLevel()) {
            clipRect.expand(IlvHandlesSelection.defaultHandleSize * 2.0f);
        }
        if (this.getFont().isItalic()) {
            FontRenderContext frc = new FontRenderContext(((Graphics2D)g).getTransform(), this._text.isAntialiasing(), this._text.isFractionalMetrics());
            Rectangle2D textBounds = this.getFont().getStringBounds(ITALIC_EXTRA, frc);
            clipRect.width = (float)((double)clipRect.width + textBounds.getWidth());
        }
        return TransformerUtil.getApplied(t, (Shape)clipRect);
    }

    @Override
    public void draw(Graphics g, IlvTransformer t) {
        if (g instanceof Graphics2D && Boolean.TRUE.equals(((Graphics2D)g).getRenderingHint(ThumbnailConstants.THUMBNAIL_RENDERING_HINT))) {
            return;
        }
        super.draw(g, t);
        if (!this.m_isUnderlined) {
            return;
        }
        Underliner.draw(this._text, g, t);
    }

    public static interface TextChangeListener {
        public void textChange(String var1, String var2);
    }

    public static class Underliner {
        private static IlvPoint s_tmpPt1 = new IlvPoint();
        private static IlvPoint s_tmpPt2 = new IlvPoint();
        private static Line2D s_underline = new Line2D.Float();

        public static void draw(IlvText text, Graphics g, IlvTransformer t) {
            Graphics2D g2d = (Graphics2D)g;
            String label = text.getLabel();
            if (label.length() > 0) {
                IlvRect textBox = text.getLabelBBox(TransformerUtil.IDENTITY_TRANSFORMER);
                Font font = text.getFont();
                FontMetrics fontMetrics = g2d.getFontMetrics(font);
                LineMetrics lineMetrics = fontMetrics.getLineMetrics(label, g2d);
                float underlineOffset = lineMetrics.getUnderlineOffset();
                s_tmpPt1.setLocation(textBox.x, textBox.y + lineMetrics.getAscent() + underlineOffset);
                float width = fontMetrics.stringWidth(label);
                s_tmpPt2.setLocation(Underliner.s_tmpPt1.x + width, Underliner.s_tmpPt1.y);
                t.apply(s_tmpPt1);
                t.apply(s_tmpPt2);
                s_underline.setLine((Point2D)s_tmpPt1, (Point2D)s_tmpPt2);
                g2d.setColor(text.getForeground());
                g2d.draw(s_underline);
            }
        }
    }
}

