/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.db2v8;

import java.sql.Connection;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.offline.Db2OfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.DB2Capturer;
import oracle.dbtools.migration.workbench.plugin.DB2OnlineCapturer;
import oracle.dbtools.migration.workbench.plugin.DB2Plugin;

public class DB2v8Plugin
extends DB2Plugin {
    private static final String GET_VIEW_QUERY = "select VIEWNAME, TEXT, DEFINER OWNER, READONLY, VALID from syscat.views";
    private static final String GET_TRIGGER_QUERY = "select TRIGNAME, DEFINER OWNER, TABSCHEMA, TABNAME, TRIGEVENT, VALID, TEXT,   REMARKS from SYSCAT.TRIGGERS";
    private static final String GET_SCHEMA_QUERY = "select SCHEMANAME SCHEMA_NAME from SYSCAT.SCHEMATA WHERE DEFINER <> 'SYSIBM' AND SCHEMANAME <> 'NULLID' AND SCHEMANAME <> 'SQLJ' AND SCHEMANAME <> 'SYSTOOLS'";

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        if (string.startsWith(this.getPlatformName()) && n == 8) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }

    @Override
    public OfflineCapturer getOfflineCapturer() {
        return new Db2OfflineCapturer(){

            @Override
            protected String[] getFilesToWrite(int n) {
                String string = "/oracle/dbtools/migration/workbench/db2v8/resources/";
                String[] stringArray = n == 2 ? new String[]{string + "startDump.sh", string + "getForeignKeys.sh", string + "getProcedures.sh", string + "db2v8.ocp"} : new String[]{string + "startDump.bat", string + "db2v8.ocp"};
                return stringArray;
            }

            @Override
            public String getModelName() throws CaptureException {
                return "DB2 (8)";
            }
        };
    }

    @Override
    public DB2Capturer getCapturer(MigrationStorer migrationStorer, Connection connection) {
        return new DB2Capturer(migrationStorer, connection){

            @Override
            protected DB2OnlineCapturer getOnlineCapturer(MigrationStorer migrationStorer, Connection connection) {
                return new DB2OnlineCapturer(migrationStorer, connection){

                    @Override
                    protected StringBuffer getViewQuery(CaptureContext captureContext) {
                        String string = captureContext.applyToSQLString("${schema}");
                        StringBuffer stringBuffer = new StringBuffer(DB2v8Plugin.GET_VIEW_QUERY);
                        stringBuffer.append(" WHERE VIEWSCHEMA='").append(string).append("' ");
                        return stringBuffer;
                    }

                    @Override
                    protected StringBuffer getTriggerQuery(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) {
                        String string = captureContext.applyToSQLString("${schema}");
                        String string2 = null;
                        try {
                            string2 = captureContext.applyToSQLString("${table}");
                        }
                        catch (IllegalStateException illegalStateException) {
                            return null;
                        }
                        StringBuffer stringBuffer = new StringBuffer(DB2v8Plugin.GET_TRIGGER_QUERY);
                        stringBuffer.append(" where TRIGSCHEMA='").append(string).append("' ");
                        if (string2 != null) {
                            stringBuffer.append(" and TABNAME='").append(string2).append("' ");
                        }
                        return stringBuffer;
                    }

                    @Override
                    protected String getSchemaQuery() {
                        return DB2v8Plugin.GET_SCHEMA_QUERY;
                    }
                };
            }
        };
    }

    public String getPublishedVersion() {
        return "8";
    }

    public String getVersionNumber() {
        return this.getPublishedVersion();
    }
}

