/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.recognisers;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.migration.applications.recognisers.iFileRecognizer;
import oracle.dbtools.raptor.migration.applications.utils.Utils;

public abstract class FileRecognizer
implements iFileRecognizer {
    protected boolean getFileTypeMarkers(File file) {
        for (int i = 0; i < this.getStrings().length; ++i) {
            Pattern pattern = Pattern.compile(this.getStrings()[i], 2);
            int n = 0;
            try {
                Matcher matcher = pattern.matcher(Utils.fromFile(file));
                while (matcher.find() && !matcher.group().equals("")) {
                    ++n;
                }
                if (n <= 0) continue;
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getTypeString() {
        return this.getType();
    }

    @Override
    public boolean isType(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String string = Utils.getExtension(file);
        if (string.equals("")) {
            return this.getFileTypeMarkers(file);
        }
        if (string == this.getType()) {
            return true;
        }
        return this.getFileTypeMarkers(file);
    }

    @Override
    public abstract String[] getStrings();

    @Override
    public abstract String[] getExtensions();
}

