/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.hook;

import java.util.HashMap;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import oracle.ide.Ide;
import oracle.ide.util.Assert;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.deploy.hook.BaseElementVisitor;

public class NestedHookHandler
extends BaseElementVisitor
implements ElementVisitorFactory {
    static final ElementName EN_HOOK_HANDLER = NestedHookHandler.e("hook-handler");
    private final HashMap<ElementName, ElementVisitor> visitors_ = new HashMap();
    private final ElementVisitor parent_;

    public NestedHookHandler(ElementVisitor parent) {
        this.parent_ = parent;
    }

    public void start(ElementStartContext context) {
        String tagName = context.getAttributeValue("tag-name");
        String namespace = context.getAttributeValue("namespace");
        boolean headless = Boolean.parseBoolean(context.getAttributeValue("headless"));
        boolean createUI = Ide.getIdeArgs().getCreateUI();
        if (headless || createUI) {
            this.addHookHandler(context, tagName, namespace);
        }
    }

    private void addHookHandler(ElementStartContext context, String tagName, String namespace) {
        Assert.println((!ModelUtil.hasLength((String)tagName) ? 1 : 0) != 0, (String)("Missing tag-name in deployment hook-handler: " + context.getExtensionSourceURI()));
        if (ModelUtil.hasLength((String)tagName)) {
            tagName = tagName.trim();
            if (ModelUtil.hasLength((String)namespace)) {
                namespace = namespace.trim();
            }
            String className = context.getAttributeValue("handler-class");
            ElementName en = new ElementName(namespace, tagName);
            if (en != null && ModelUtil.hasLength((String)className)) {
                className = className.trim();
                try {
                    Class<?> hookClass = Class.forName(className);
                    ElementVisitor visitor = (ElementVisitor)hookClass.newInstance();
                    this.visitors_.put(en, visitor);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ElementVisitor getVisitor(ElementName name) {
        return this.visitors_.get(name);
    }
}

