/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta;

import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.meta.pattern.ChainOfR;

public class UpgradableStore<L, N, R> {
    final ChainOfR<L, UpgradableNode<N>, WrappedRequest<N, R>> impl_;

    public UpgradableStore(Handler<N, R> handler) {
        this.impl_ = new ChainOfR(new UpgradedNodeHandler<N, R>(handler));
    }

    public boolean handle(L start, R request) throws Exception {
        return this.impl_.handle(start, new WrappedRequest(request));
    }

    public N getHandlingObject(L start, R request) throws Exception {
        WrappedRequest wrappedRequest = new WrappedRequest(request);
        if (this.impl_.handle(start, wrappedRequest)) {
            return wrappedRequest.nodeHandled_;
        }
        return null;
    }

    public void addNode(L label, L parent, N node) throws ChainOfR.DuplicateIndexException, MetadataException {
        this.impl_.add(label, parent, new UpgradableNode<N>(node));
    }

    public void addNode(L label, N node) throws ChainOfR.DuplicateIndexException, MetadataException {
        this.addNode(label, null, node);
    }

    public void upgradeNode(L label, N node) throws ChainOfR.IndexNotFoundException {
        UpgradableNode<N> nodeToUpgrade = this.impl_.get(label);
        nodeToUpgrade.add(node);
    }

    public void replaceNode(L label, N node) throws MetadataException {
        this.impl_.replace(label, new UpgradableNode<N>(node));
    }

    public void replaceTargetedNode(L label, N oldNode, N newNode) throws ChainOfR.IndexNotFoundException {
        UpgradableNode<N> upgNode = this.impl_.get(label);
        upgNode.replace(oldNode, newNode);
    }

    class UpgradedNodeHandler<N, R>
    implements Handler<UpgradableNode<N>, WrappedRequest<N, R>> {
        final ChainOfR.RequestHandler<N, R> delegate_;

        UpgradedNodeHandler(ChainOfR.RequestHandler<N, R> realHandler) {
            this.delegate_ = realHandler;
        }

        @Override
        public boolean handle(UpgradableNode<N> upgradedNode, WrappedRequest<N, R> request) throws Exception {
            N[] nodes = upgradedNode.getNodes();
            Object unwrappedRequest = request.request_;
            for (int i = nodes.length - 1; i >= 0; --i) {
                if (!this.delegate_.handle(nodes[i], unwrappedRequest)) continue;
                request.nodeHandled_ = nodes[i];
                return true;
            }
            return false;
        }
    }

    class WrappedRequest<N, R> {
        N nodeHandled_ = null;
        R request_ = null;

        WrappedRequest(R r) {
            this.request_ = r;
        }
    }

    class UpgradableNode<N> {
        N[] nodes_;

        UpgradableNode(N node) {
            this.add(node);
        }

        void add(N node) {
            int len = this.nodes_ == null ? 1 : this.nodes_.length + 1;
            N[] temp = this.nodes_;
            this.nodes_ = new Object[len];
            if (len > 1) {
                System.arraycopy(temp, 0, this.nodes_, 0, temp.length);
            }
            this.nodes_[this.nodes_.length - 1] = node;
        }

        N[] getNodes() {
            return this.nodes_;
        }

        public void replace(N oldNode, N newNode) {
            Assert.check((newNode != null ? 1 : 0) != 0, (String)"Cannot replace with a null node");
            if (newNode == null) {
                throw new IllegalArgumentException("Attempt to replace a node with null.");
            }
            for (int i = 0; i < this.nodes_.length; ++i) {
                if (!this.nodes_[i].equals(oldNode)) continue;
                this.nodes_[i] = newNode;
                return;
            }
            throw new IllegalArgumentException("Could not replace node. Missing: " + oldNode);
        }
    }

    public static class Pair<A, B>
    extends oracle.javatools.util.Pair<A, B> {
        public Pair(A a, B b) {
            super(a, b);
        }
    }

    public static interface Handler<N, R>
    extends ChainOfR.RequestHandler<N, R> {
    }
}

