/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta;

import java.util.ArrayList;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.deploy.meta.PlatformVersion;

public class PlatformRegistry {
    private ArrayList<Platform> platforms_ = new ArrayList();
    private static PlatformRegistry platformRegistry_ = null;
    private static Platform defaultPlatform_ = null;
    private static final String PLATFORM_REGISTRY_METADATA_ERROR = "No such platform defined";

    public static void setDefaultPlatform(Platform platform) throws MetadataException {
        defaultPlatform_ = PlatformRegistry.getPlatform(platform.getType(), platform.getVersion());
    }

    public static Platform getDefaultPlatform() {
        return defaultPlatform_;
    }

    private PlatformRegistry() {
    }

    private static synchronized PlatformRegistry getInstance() {
        if (platformRegistry_ == null) {
            platformRegistry_ = new PlatformRegistry();
        }
        return platformRegistry_;
    }

    public static void registerPlatform(Platform platform) {
        PlatformRegistry.getInstance().platforms_.add(platform);
    }

    public static Platform getPlatform(PlatformType type, PlatformVersion version) throws MetadataException {
        return PlatformRegistry.getInstance().getPlatformImpl(type, version);
    }

    private Platform getPlatformImpl(PlatformType type, PlatformVersion version) throws MetadataException {
        Platform platform = this.getPlatformImpl(type, version, VersionMatch.MATCH_ALL);
        if (platform == null) {
            throw new MetadataException(PLATFORM_REGISTRY_METADATA_ERROR);
        }
        return platform;
    }

    public static Platform getPlatform(PlatformType type, String version) throws MetadataException {
        return PlatformRegistry.getInstance().getPlatformImpl(type, version);
    }

    private Platform getPlatformImpl(PlatformType type, String version) throws MetadataException {
        return this.getPlatformImpl(type, new PlatformVersion(version));
    }

    public static Platform getPlatform(PlatformType type, PlatformVersion version, VersionMatch matchType) {
        return PlatformRegistry.getInstance().getPlatformImpl(type, version, matchType);
    }

    private Platform getPlatformImpl(PlatformType type, PlatformVersion version, VersionMatch matchType) {
        int matchedNumbers = 0;
        Platform matchedPlatform = null;
        int matchRequired = 0;
        matchRequired = matchType == VersionMatch.MATCH_EXACT || matchType == VersionMatch.MATCH_ALL ? version.toIntArray().length : matchType.matchRequired();
        for (Platform platform : this.platforms_) {
            int m;
            if (platform.getType() != type || Math.abs(m = platform.getVersion().matchNumbers(version)) < matchRequired) continue;
            boolean store = false;
            boolean exactMatch = false;
            switch (matchType) {
                case MATCH_ALL: {
                    if (Math.abs(m) < matchedNumbers || matchedPlatform != null && platform.getVersion().compareTo((Object)matchedPlatform.getVersion()) <= 0) break;
                    store = true;
                    break;
                }
                case MATCH_EXACT: {
                    if (m != matchRequired) break;
                    store = true;
                    exactMatch = true;
                    break;
                }
                default: {
                    if (Math.abs(m) < matchedNumbers) break;
                    if (matchedPlatform == null) {
                        store = true;
                        break;
                    }
                    if (platform.getVersion().compareTo((Object)matchedPlatform.getVersion()) == 0) {
                        store = true;
                        exactMatch = true;
                        break;
                    }
                    if (platform.getVersion().compareTo((Object)matchedPlatform.getVersion()) <= 0) break;
                    store = true;
                }
            }
            if (store) {
                matchedPlatform = platform;
                matchedNumbers = m;
            }
            if (!exactMatch) continue;
            break;
        }
        return matchedPlatform;
    }

    public static Platform[] getPlatforms() {
        return PlatformRegistry.getInstance().getPlatformsImpl(PlatformType.ANY, true);
    }

    public static Platform[] getPlatforms(PlatformType filterOnType) {
        return PlatformRegistry.getInstance().getPlatformsImpl(filterOnType, false);
    }

    public static Platform[] getPlatforms(PlatformType filterOnType, boolean includeSubTypes) {
        return PlatformRegistry.getInstance().getPlatformsImpl(filterOnType, includeSubTypes);
    }

    private Platform[] getPlatformsImpl(PlatformType filterOnType, boolean includeSubTypes) {
        ArrayList<Platform> platforms = new ArrayList<Platform>();
        for (Platform p : this.platforms_) {
            PlatformType type = p.getType();
            if (type == filterOnType) {
                platforms.add(p);
                continue;
            }
            if (!includeSubTypes || !type.isExtensionOf(filterOnType)) continue;
            platforms.add(p);
        }
        return platforms.toArray(new Platform[platforms.size()]);
    }

    static synchronized void reset() {
        platformRegistry_ = null;
    }

    public static enum VersionMatch {
        MATCH_ALL(-2),
        MATCH_EXACT(-1),
        MATCH_NONE(0),
        MATCH_MAJOR(1),
        MATCH_MINOR(2),
        MATCH_UPDATE(3);

        private int matchRequired;

        private VersionMatch(int matchRequired) {
            this.matchRequired = matchRequired;
        }

        public int matchRequired() {
            return this.matchRequired;
        }
    }
}

