/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.util.HashMap;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployShellFactory;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeployerFactory;
import oracle.jdeveloper.deploy.DeployerListener;
import oracle.jdeveloper.deploy.DeploymentModuleFactory;
import oracle.jdeveloper.deploy.ListenerCondition;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.ProfileListenerCondition;
import oracle.jdeveloper.deploy.Runnable;
import oracle.jdeveloper.deploy.meta.CustomMetaClass;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdevimpl.deploy.fwk.ListenerSupport;

public abstract class DeploymentManager {
    private static oracle.jdevimpl.deploy.fwk.DeploymentManager impl_ = new oracle.jdevimpl.deploy.fwk.DeploymentManager();
    private static Map<String, Integer> deploymentSequences = new HashMap<String, Integer>();
    private static int lastSequenceId = 0;

    protected DeploymentManager() {
    }

    static oracle.jdevimpl.deploy.fwk.DeploymentManager getImpl() {
        return impl_;
    }

    public static void addDeployerListener(ListenerCondition condition, DeployerListener listener, double priority) {
        DeploymentManager.getImpl().addDeployerListener(condition, listener, priority);
    }

    public static void addDeployerListener(int deploymentSequenceId, Class<? extends Profile> profileClass, PlatformType platformType, DeployerListener listener) {
        DeploymentManager.addDeployerListener(deploymentSequenceId, profileClass, platformType, 0.5, listener);
    }

    public static void addDeployerListener(int deploymentSequenceId, Class<? extends Profile> profileClass, PlatformType platformType, double priority, DeployerListener listener) {
        DeploymentManager.getImpl().addDeployerListener(new ProfileListenerCondition(deploymentSequenceId, profileClass, platformType), listener, priority);
    }

    public static void removeDeployerListener(ListenerCondition condition, DeployerListener listener) {
        DeploymentManager.getImpl().removeDeployerListener(condition, listener);
    }

    public static void removeDeployerListener(DeployerListener listener) {
        DeploymentManager.getImpl().removeDeployerListener(listener);
    }

    public static int getDeploymentSequenceId(String deploymentSequence) {
        return DeploymentManager.sequenceId(deploymentSequence);
    }

    public static String getDeploymentSequenceName(int sequenceId) {
        return DeploymentManager.sequenceName(sequenceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int sequenceId(String sequence) {
        Integer number = deploymentSequences.get(sequence);
        if (number == null) {
            Map<String, Integer> map = deploymentSequences;
            synchronized (map) {
                number = ++lastSequenceId;
                deploymentSequences.put(sequence, lastSequenceId);
                DeploymentManager.getImpl();
                Assert.check((boolean)oracle.jdevimpl.deploy.fwk.DeploymentManager.printDebug("deployment.sequence.id", "<id>" + number + "</id><name>" + sequence + "</name>"));
            }
        }
        return number;
    }

    private static String sequenceName(int id) {
        String ret = null;
        for (Map.Entry<String, Integer> entry : deploymentSequences.entrySet()) {
            if (!entry.getValue().equals(id)) continue;
            ret = entry.getKey();
            break;
        }
        Assert.check((ret != null ? 1 : 0) != 0, (String)("Invalid sequence id " + id));
        return ret;
    }

    public static void registerDeployerFactory(MetaClass deployable, MetaClass parent, MetaClass factory) throws MetadataException {
        DeploymentManager.registerDeployerFactory(deployable, parent, factory != null ? new CustomMetaClass(factory) : null);
    }

    public static void registerDeployerFactory(MetaClass deployable, MetaClass parent, CustomMetaClass deployerFactory) throws MetadataException {
        DeploymentManager.getImpl().registerDeployerFactory(deployable, parent, deployerFactory);
    }

    public static void registerDeployerFactory(Class deployable, Class parent, DeployerFactory factory) throws MetadataException {
        MetaClass deployableMetaClass = new MetaClass(deployable.getClassLoader(), deployable.getName());
        MetaClass parentMetaClass = parent != null ? new MetaClass(parent.getClassLoader(), parent.getName()) : null;
        CustomMetaClass factoryMetaClass = factory != null ? new CustomMetaClass(NonDeclDeployerFactory.class, new Class[]{DeployerFactory.class}, new Object[]{factory}) : null;
        DeploymentManager.registerDeployerFactory(deployableMetaClass, parentMetaClass, factoryMetaClass);
    }

    public static void upgradeDeployerFactory(MetaClass deployable, MetaClass deployerFactory) throws MetadataException {
        DeploymentManager.upgradeDeployerFactory(deployable, new CustomMetaClass(deployerFactory));
    }

    public static void upgradeDeployerFactory(MetaClass deployable, CustomMetaClass deployerFactory) throws MetadataException {
        DeploymentManager.getImpl().upgradeDeployerFactory(deployable, (CustomMetaClass<DeployerFactory>)deployerFactory);
    }

    public static void upgradeDeployerFactory(Class clazz, DeployerFactory factory) throws MetadataException {
        DeploymentManager.upgradeDeployerFactory(new MetaClass(clazz.getClassLoader(), clazz.getName()), new CustomMetaClass(NonDeclDeployerFactory.class, new Class[]{DeployerFactory.class}, new Object[]{factory}));
    }

    public static void registerDeploymentModuleFactory(String forClass, DeploymentModuleFactory factory) throws MetadataException {
        DeploymentManager.getImpl().registerDeploymentModuleFactory(forClass, factory);
    }

    public static void upgradeDeploymentModuleFactory(String forClass, DeploymentModuleFactory factory) throws MetadataException {
        DeploymentManager.getImpl().upgradeDeploymentModuleFactory(forClass, factory);
    }

    @Deprecated
    public DeployShell getDefaultDeployShell(int deploySequence, Context context) throws DeployException {
        return DeploymentManager.getImpl().createRootDeployShell(deploySequence, context);
    }

    public static void deploy(int deploymentSequenceId, Context context) throws Exception {
        DeploymentManager.getImpl().deploy(deploymentSequenceId, context);
    }

    public static void deploy(int deploymentSequenceId, DeployShell shell) throws Exception {
        DeploymentManager.getImpl().deploy(deploymentSequenceId, shell);
    }

    public static java.lang.Runnable createRunnable(int deploymentSequenceId, DeployShell shell) {
        return DeploymentManager.getImpl().createRunnable(deploymentSequenceId, shell);
    }

    public static Deployer createDeployer(int deploymentSequenceId, DeployShell shell) throws Exception {
        return DeploymentManager.getImpl().createDeployer(deploymentSequenceId, shell);
    }

    public static Runnable deploy(int deploymentSequenceId, DeployShell shell, Object lock) {
        return DeploymentManager.getImpl().deploy(deploymentSequenceId, shell, lock);
    }

    @Deprecated
    public static void deploy(int deploymentSequenceId, Context context, DeployShellFactory factory) throws Exception {
        DeploymentManager.getImpl().deploy(deploymentSequenceId, context, factory);
    }

    @Deprecated
    public static void deploy(int deploymentSequenceId, Context context, DeployShellFactory factory, Object lock) throws DeployException, MetadataException {
        DeploymentManager.getImpl().deploy(deploymentSequenceId, context, factory, lock);
    }

    public static ListenerSupport getProfileListenerSupport() {
        return DeploymentManager.getImpl().getProfileListenerSupport();
    }

    public static void setDeploymentManager(oracle.jdevimpl.deploy.fwk.DeploymentManager impl) {
        impl_ = impl;
    }

    private static class NonDeclDeployerFactory
    implements DeployerFactory {
        final DeployerFactory delegate;

        NonDeclDeployerFactory(DeployerFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public Deployer newDeployer(int deploymentSequenceId, DeployShell shell) {
            return this.delegate.newDeployer(deploymentSequenceId, shell);
        }
    }
}

