/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.diff;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import oracle.dbtools.extension.project.core.diff.ParseDiff;
import oracle.dbtools.extension.project.core.diff.TableInfo;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.ParsedSql;

public class DdlDiff {
    ParsedSql parsed1 = null;
    ParsedSql parsed2 = null;
    TableInfo ti1 = null;
    TableInfo ti2 = null;
    static final String separator = ",\n";

    public DdlDiff(String input1, String input2) throws Exception {
        this.parsed1 = new ParsedSql(input1);
        this.parsed2 = new ParsedSql(input2);
        this.ti1 = new TableInfo((Parsed)this.parsed1);
        this.ti2 = new TableInfo((Parsed)this.parsed2);
    }

    public String alters() {
        Object ret = "";
        String alter = "alter table " + this.ti1.tableName + "\n";
        ParseDiff inlineConstraintDiffs = new ParseDiff(this.ti1.inlineNamedConstraints, (Parsed)this.parsed1, this.ti2.inlineNamedConstraints, (Parsed)this.parsed2){

            @Override
            public int nameIndex() {
                return 1;
            }
        };
        ParseDiff colDiffs = new ParseDiff(this.ti1.columnDefinitions, (Parsed)this.parsed1, this.ti2.columnDefinitions, (Parsed)this.parsed2){

            @Override
            public int nameIndex() {
                return 0;
            }
        };
        LinkedList<String> included = new LinkedList<String>();
        for (String constr : inlineConstraintDiffs.rename.keySet()) {
            String conDef = inlineConstraintDiffs.rename.get(constr);
            for (String col : colDiffs.modify.keySet()) {
                String colDef = colDiffs.modify.get(col);
                if (!colDef.contains(conDef)) continue;
                included.add(col);
            }
        }
        for (String col : included) {
            colDiffs.modify.remove(col);
        }
        if (colDiffs.delete.size() > 0) {
            ret = (String)ret + alter + " drop " + DdlDiff.parenList(colDiffs.delete) + ";\n";
        }
        if (colDiffs.add.size() > 0) {
            ret = (String)ret + alter + " add " + DdlDiff.parenList(colDiffs.add) + ";\n";
        }
        if (colDiffs.modify.size() > 0) {
            ret = (String)ret + alter + " modify " + DdlDiff.parenList(colDiffs.modify) + ";\n";
        }
        for (String name : colDiffs.rename.keySet()) {
            ret = (String)ret + alter + " rename column " + name + " to " + colDiffs.rename.get(name) + ";\n";
        }
        if (!this.ti2.pkColumns.equals(this.ti1.pkColumns) || !this.ti2.pkState.equals(this.ti1.pkState)) {
            if (this.ti1.pkColumns.size() > 0) {
                ret = (String)ret + alter + " drop primary key cascade;\n";
            }
            if (this.ti2.pkColumns.size() > 0) {
                ret = (String)ret + alter + " add primary key " + DdlDiff.parenList(this.ti2.pkColumns) + this.ti2.pkState + ";\n";
            }
        }
        ParseDiff outOfLineConstraintDiffs = new ParseDiff(this.ti1.outOfLineNamedConstraints, (Parsed)this.parsed1, this.ti2.outOfLineNamedConstraints, (Parsed)this.parsed2){

            @Override
            public int nameIndex() {
                return 1;
            }
        };
        for (String name : outOfLineConstraintDiffs.rename.keySet()) {
            ret = (String)ret + alter + " rename constraint " + name + " to " + outOfLineConstraintDiffs.rename.get(name) + ";\n";
        }
        for (String name : outOfLineConstraintDiffs.delete) {
            ret = (String)ret + alter + " drop constraint " + name + ";\n";
        }
        for (String name : outOfLineConstraintDiffs.modify.keySet()) {
            ret = (String)ret + alter + " drop constraint " + name + ";\n";
        }
        for (String name : outOfLineConstraintDiffs.add.keySet()) {
            ret = (String)ret + alter + " add " + outOfLineConstraintDiffs.add.get(name) + ";\n";
        }
        for (String name : outOfLineConstraintDiffs.modify.keySet()) {
            ret = (String)ret + alter + " add " + outOfLineConstraintDiffs.modify.get(name) + ";\n";
        }
        for (String name : inlineConstraintDiffs.rename.keySet()) {
            ret = (String)ret + alter + " rename constraint " + name + " to " + inlineConstraintDiffs.rename.get(name) + ";\n";
        }
        return ret;
    }

    private static String parenList(Collection<String> list) {
        Object ret = "(";
        for (String col : list) {
            ret = (String)ret + col + separator;
        }
        return ((String)ret).substring(0, ((String)ret).length() - separator.length()) + ")";
    }

    private static String parenList(Map<String, String> definitions) {
        Object ret = "(";
        for (String col : definitions.keySet()) {
            ret = (String)ret + definitions.get(col) + separator;
        }
        return ((String)ret).substring(0, ((String)ret).length() - separator.length()) + ")";
    }
}

