/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.generators;

import oracle.dbtools.extension.project.commands.stage.objectclasses.DbDiffObject;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import org.apache.commons.lang3.StringUtils;

public class DropDdlGenerator {
    public static String getDrop(DbDiffObject entry) {
        StringBuilder sql = new StringBuilder();
        if ("REF_CONSTRAINT".equalsIgnoreCase(entry.getObjectType())) {
            String dropsql = entry.getMasterFileContent();
            dropsql = dropsql.substring(0, dropsql.indexOf("-- sqlcl_snapshot")).trim();
            dropsql = StringUtils.replaceIgnoreCase((String)dropsql, (String)"add", (String)"drop");
            int loc = StringUtils.indexOfIgnoreCase((CharSequence)dropsql, (CharSequence)"FOREIGN KEY");
            sql.append(dropsql, 0, loc - 1);
        } else if ("GRANT".equalsIgnoreCase(entry.getObjectType())) {
            String dropsql = entry.getBranchFileContent();
            dropsql = dropsql.substring(0, dropsql.indexOf("-- sqlcl_snapshot")).trim();
            dropsql = dropsql.replaceAll("GRANT", "REVOKE");
            dropsql = dropsql.replaceAll("TO", "FROM");
            sql.append(dropsql);
        } else {
            sql.append("DROP ");
            sql.append(SchemaGenerator.typeNameTransform.getOrDefault(entry.getObjectType(), entry.getObjectType())).append(" ");
            sql.append("\"").append(entry.getSchema()).append("\".");
            sql.append("\"").append(entry.getObjectName()).append("\"");
            if ("TABLE".equals(entry.getObjectType())) {
                sql.append(" CASCADE CONSTRAINTS");
            }
        }
        return sql.toString();
    }
}

