/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.arbori.util.Service;
import oracle.dbtools.extension.project.commands.export.DbmsMetadata;
import oracle.dbtools.extension.project.commands.export.Export;
import oracle.dbtools.extension.project.commands.export.ExportMessages;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.utils.ConsoleColors;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.util.SpinningWheel;
import oracle.jdbc.OracleDatabaseException;

public class Report {
    Map<String, Integer> typeCounts = new ConcurrentHashMap<String, Integer>();
    Map<String, String> errors = new ConcurrentHashMap<String, String>();
    Map<String, String> failedFormats = new ConcurrentHashMap<String, String>();
    long formatTiming = 0L;
    long startTime = System.currentTimeMillis();
    Export export;

    public Report(Export export) {
        this.export = export;
    }

    void incrTypeCnt(String type) {
        Integer tmp = this.typeCounts.get(type);
        if (tmp == null) {
            tmp = 0;
        }
        this.typeCounts.put(type, tmp + 1);
    }

    void addFailedFormat(String type, String file) {
        this.failedFormats.put(type, file);
    }

    static void rewriteln(ScriptRunnerContext ctx, String msg) {
        if (ProjectConfig.isVerbose()) {
            Report.writeln(ctx, msg);
        } else {
            PrintWriter p = Report.cleanSpinningWheel(ctx);
            p.print("\r" + msg + "                 ");
            p.flush();
        }
    }

    static void writeln(ScriptRunnerContext ctx, String msg) {
        PrintWriter p = Report.cleanSpinningWheel(ctx);
        p.println(msg);
        p.flush();
    }

    static void write(ScriptRunnerContext ctx, String msg) {
        PrintWriter p = Report.cleanSpinningWheel(ctx);
        p.print(msg);
        p.flush();
    }

    static void warning(ScriptRunnerContext ctx, Throwable e) {
        Report.writeln(ctx, ConsoleColors.YELLOW.code + e.getMessage() + ConsoleColors.RESET.code);
        Report.debug(ctx, e);
    }

    static void error(ScriptRunnerContext ctx, String msg) {
        Report.writeln(ctx, ConsoleColors.RED.code + msg + ConsoleColors.RESET.code);
        if (ProjectConfig.isDebug()) {
            Report.writeln(ctx, ConsoleColors.BLUE.code);
            Thread.dumpStack();
            Report.writeln(ctx, ConsoleColors.RESET.code);
        }
    }

    static void error(ScriptRunnerContext ctx, Throwable t, String addendum) {
        Report.writeln(ctx, ConsoleColors.RED.code + t.getMessage() + " " + addendum + ConsoleColors.RESET.code);
        Report.debug(ctx, t);
    }

    static void error(ScriptRunnerContext ctx, String addendum, Throwable t) {
        Report.writeln(ctx, ConsoleColors.RED.code + addendum + " " + t.getMessage() + ConsoleColors.RESET.code);
        Report.debug(ctx, t);
    }

    static void error(ScriptRunnerContext ctx, String otype, String oname, Throwable e) {
        if (otype == null) {
            otype = "null";
        }
        if (oname == null) {
            oname = "null";
        }
        Report.writeln(ctx, ConsoleColors.RED.code + otype + ":" + oname + " " + e.getMessage() + ConsoleColors.RESET.code);
        Report.debug(ctx, e);
    }

    static void verbose(ScriptRunnerContext ctx, String msg) {
        if (ProjectConfig.isVerbose()) {
            Report.writeln(ctx, ConsoleColors.WHITE.code + msg + ConsoleColors.RESET.code);
        }
    }

    static void debug(ScriptRunnerContext ctx, String msg) {
        if (ProjectConfig.isDebug()) {
            Report.writeln(ctx, ConsoleColors.BLUE.code + msg + ConsoleColors.RESET.code);
        }
    }

    static void debug(ScriptRunnerContext ctx, Throwable e) {
        if (ProjectConfig.isDebug()) {
            Report.writeln(ctx, ConsoleColors.BLUE.code);
            e.printStackTrace();
            Report.writeln(ctx, ConsoleColors.RESET.code);
        }
    }

    static void noVerboseDebugSpinningWheel(ScriptRunnerContext ctx) {
        if (ProjectConfig.isDebug()) {
            return;
        }
        if (ProjectConfig.isVerbose()) {
            return;
        }
        SpinningWheel.start((ScriptRunnerContext)ctx);
    }

    private static PrintWriter cleanSpinningWheel(ScriptRunnerContext ctx) {
        WrapListenBufferOutputStream wrapBos = ctx.getOutputStream();
        SpinningWheel.stop();
        return new PrintWriter((OutputStream)wrapBos);
    }

    static void warning(ScriptRunnerContext ctx, String msg) {
        Report.writeln(ctx, ConsoleColors.YELLOW.code + msg + ConsoleColors.RESET.code);
    }

    static void processException(ScriptRunnerContext ctx, Throwable t, String otype, String oname) {
        Throwable cause;
        if (t instanceof SQLException && (cause = t.getCause()) instanceof OracleDatabaseException) {
            OracleDatabaseException ode = (OracleDatabaseException)cause;
            Report.error(ctx, "*** Failed to run " + ode.getSql());
            String msg = ode.getMessage();
            int nlPos = msg.indexOf("\n");
            if (0 < nlPos) {
                msg = msg.substring(0, nlPos);
            }
            Report.error(ctx, "*** " + msg);
            Report.error(ctx, msg);
            return;
        }
        Report.error(ctx, otype, oname, t);
    }

    void summary() {
        int total = 0;
        ScriptRunnerContext ctx = this.export.ctx;
        if (0 < this.failedFormats.size()) {
            Report.writeln(ctx, "Failed to format:");
        }
        for (String type : this.failedFormats.keySet()) {
            Report.warning(ctx, type + " : " + this.failedFormats.get(type));
        }
        if (0 < this.errors.size()) {
            Report.writeln(ctx, "Errors:");
        }
        for (String type : this.errors.keySet()) {
            Report.error(ctx, type + " : " + this.errors.get(type));
        }
        int pad = 30;
        int max = 1;
        for (String type : this.typeCounts.keySet()) {
            int len = this.typeCounts.get(type).toString().length();
            if (max >= len) continue;
            max = len;
        }
        String dashPad = "-".repeat(pad + max);
        Report.writeln(ctx, ConsoleColors.GREEN.code + dashPad);
        for (String type : this.typeCounts.keySet()) {
            Integer cnt = this.typeCounts.get(type);
            int len = cnt.toString().length();
            if ("OBJECT_GRANT".equals(type)) continue;
            total += cnt.intValue();
            Report.writeln(ctx, Service.padln((String)type, (int)(pad + max - len)) + cnt);
        }
        Report.writeln(ctx, dashPad + ConsoleColors.RESET.code);
        if (this.export.listOnly) {
            total = 0;
        }
        Report.writeln(ctx, MessageFormat.format(ExportMessages.getString("EXPORTED_N_OBJECTS"), total));
        Report.writeln(ctx, MessageFormat.format(ExportMessages.getString("EXPORT_ELAPSED"), (System.currentTimeMillis() - this.startTime) / 1000L));
        Report.debug(ctx, "DBMS_METADATA = " + DbmsMetadata.dbmsMetadataTiming / 1000L + "s");
        Report.debug(ctx, "PL/SQL        = " + DbmsMetadata.plsTiming / 1000L + "s");
        Report.debug(ctx, "Format        = " + this.formatTiming / 1000L + "s");
    }
}

