/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.xmlComponent.propertyEditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.XmlGuiFactory;
import oracle.bali.xml.gui.base.explorer.XmlTreeModel;
import oracle.bali.xml.gui.base.inspector.editors.StringEditor;
import oracle.bali.xml.gui.base.xmlComponent.AbstractXmlPropertyEditorDecorator;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentSelectionChanged;
import oracle.bali.xml.gui.jdev.resource.JDevBundle;
import oracle.bali.xml.gui.swing.explorer.SwingExplorerGui;
import oracle.bali.xml.gui.swing.explorer.XmlJTree;
import oracle.bali.xml.gui.swing.explorer.XmlTreeCellRenderer;
import oracle.bali.xml.gui.swing.util.InsertionMenuGenerator;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.XmlViewFactory;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.bali.xml.model.view.FilteredView;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.resource.IdeIcons;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;
import oracle.javatools.ui.ResizeComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;

public class XmlTreePropertyEditor
extends AbstractXmlPropertyEditorDecorator<String>
implements XmlComponentSelectionChanged {
    private int _visibleRowCount = 0;
    private XmlKey _treeNodeXmlKey;
    private XmlKey[] _treeNodeOtherXmlKeys;
    private NodeFilter _nodeFilter;
    private XmlTreePropertyEditorGui _xmlTreeGui;
    private JPanel _treePanel;
    private XmlUsage _xmlUsage;
    private String _treeLabel;
    private Node _prevParentNode;
    private JScrollPane _treeScrollPane;
    private TreeSelectionListener _xmlTreeSelectionListener;
    private AddMenuButton _addButton = new AddMenuButton(this.createAddAction());
    private JButton _deleteButton = new JButton(this.createDeleteAction());
    private boolean _removeSelectionPathCalled = false;
    private static final Short _ACCEPT = 1;
    private static final Short _SKIP = 3;
    private static final Color _HIGHLIGHT_COLOR = new Color(220, 220, 220);

    public XmlTreePropertyEditor() {
        super((PropertyEditor)new StringEditor());
    }

    public XmlTreePropertyEditor setXmlUsage(XmlUsage xmlUsage) {
        this._xmlUsage = xmlUsage;
        return this;
    }

    public Component getXmlComponent() {
        if (this._treePanel != null) {
            if (this.getXmlComponentWrapper().getParent() == null) {
                new ReadOnlyTask<Boolean>(){

                    protected Boolean runImpl(AbstractModel model) {
                        XmlTreePropertyEditor.this.selectFirstRowIfNoCurrentSelection();
                        return true;
                    }
                }.run((AbstractModel)this.getXmlTreeGui().getView());
                return this._treePanel;
            }
            if (this._prevParentNode == null || this._prevParentNode == this.getTreeParentNode()) {
                if (this._prevParentNode == null) {
                    this._prevParentNode = this.getTreeParentNode();
                }
                return this._treePanel;
            }
            this._prevParentNode = this.getTreeParentNode();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XmlTreePropertyEditor.this.updateTreeParent();
                }
            });
            return this._treePanel;
        }
        new ReadOnlyTask<Boolean>(){

            protected Boolean runImpl(AbstractModel model) {
                XmlTreePropertyEditor.this.getXmlComponentWrapper().setAddFocusTracker(false);
                XmlTreePropertyEditor.this._prevParentNode = XmlTreePropertyEditor.this.getTreeParentNode();
                XmlTreePropertyEditor.this._treePanel = XmlTreePropertyEditor.this.createTreePanel(XmlTreePropertyEditor.this.getTreeLabel());
                XmlTreePropertyEditor.this.updateXmlComponentFromPropertyValue();
                XmlTreePropertyEditor.this.updateAddDeleteButtons(null, XmlTreePropertyEditor.this.getXmlTreeGui().getJTree());
                XmlTreePropertyEditor.this.updateChildXmlComponents(true);
                return true;
            }
        }.run((AbstractModel)this.getXmlTreeGui().getView());
        return this._treePanel;
    }

    public Node getTreeParentNode() {
        if (this.getXmlComponentWrapper().getParent() != null) {
            return this.getXmlComponentWrapper().getParent().getXmlComponentModel().getNode();
        }
        return null;
    }

    public void updateTreeParent() {
        new NonDomMutationTransactionTask(){

            protected void performTask(AbstractModel model) {
                Node selectedModelNode;
                XmlTreePropertyEditor.this.getXmlTreeGui().getView().getSelection().setCursorLocation(null);
                XmlTreePropertyEditor.this.getXmlTreeGui().disposeJTree(XmlTreePropertyEditor.this.getXmlTreeGui().getJTree());
                XmlTreePropertyEditor.this.getXmlTreeGui().initTree();
                XmlTreePropertyEditor.this.getXmlTreeGui().setHighlightedNodes(null);
                JTree xmlJTree = XmlTreePropertyEditor.this.getXmlTreeGui().getJTree();
                xmlJTree.addTreeSelectionListener(XmlTreePropertyEditor.this.getXmlTreeSelectionListener());
                XmlTreePropertyEditor.this._treeScrollPane.setViewportView(xmlJTree);
                Node selectedNode = XmlTreePropertyEditor.this.getXmlTreeGui().getView().getSelection().getFirstSelectedNode();
                if (selectedNode == null && (selectedModelNode = XmlTreePropertyEditor.this.getXmlTreeGui().getView().getBaseModel().getSelection().getFirstSelectedNode()) != null && XmlTreePropertyEditor.this.getXmlTreeGui().getView().modelToView(selectedModelNode) != null) {
                    XmlTreePropertyEditor.this.getXmlTreeGui().getView().getSelection().set(selectedModelNode);
                }
                XmlTreePropertyEditor.this.updateAddDeleteButtons(null, xmlJTree);
                XmlTreePropertyEditor.this.updateChildXmlComponents(true);
            }
        }.run((AbstractModel)this.getXmlTreeGui().getView());
    }

    protected final TreeSelectionListener getXmlTreeSelectionListener() {
        if (this._xmlTreeSelectionListener == null) {
            this._xmlTreeSelectionListener = this.createXmlTreeSelectionListener();
        }
        return this._xmlTreeSelectionListener;
    }

    protected TreeSelectionListener createXmlTreeSelectionListener() {
        return new XmlTreeSelectionListener();
    }

    public void dispose() {
        this.getXmlTreeGui().disposeJTree(this.getXmlTreeGui().getJTree());
        this._xmlTreeGui = null;
    }

    public String getTreeLabel() {
        if (this._treeLabel == null) {
            return this.getXmlComponentModel().getShortDisplayName();
        }
        return this._treeLabel;
    }

    public XmlTreePropertyEditor setTreeLabel(String label) {
        this._treeLabel = label;
        return this;
    }

    public XmlTreePropertyEditorGui getXmlTreeGui() {
        if (this._xmlTreeGui != null) {
            return this._xmlTreeGui;
        }
        this._xmlTreeGui = (XmlTreePropertyEditorGui)this.getXmlComponentModel().getXmlGui().getGuiContext().getGui(this._xmlUsage, false);
        if (this._xmlTreeGui == null) {
            this.registerViewFactory(this.getXmlComponentModel().getXmlGui().getGuiContext());
            this.registerGuiFactory(this.getXmlComponentModel().getXmlGui().getGuiContext());
            this._xmlTreeGui = (XmlTreePropertyEditorGui)this.getXmlComponentModel().getXmlGui().getGuiContext().getGui(this._xmlUsage);
        }
        return this._xmlTreeGui;
    }

    public void updateXmlComponentFromPropertyValue() {
    }

    public void updatePropertyValueFromXmlComponent() {
    }

    public void addChildFocusListener(FocusListener focusListener) {
    }

    public void removeChildFocusListener(FocusListener focusListener) {
    }

    public XmlTreePropertyEditor setEnabled(boolean enabled) {
        this.getTreePanel().setEnabled(enabled);
        return this;
    }

    public JPanel getTreePanel() {
        return this._treePanel;
    }

    public JTree getTree() {
        return this.getXmlTreeGui().getComponent();
    }

    public int getVisibleRowCount() {
        return this._visibleRowCount;
    }

    public XmlTreePropertyEditor setVisibleRowCount(int visibleRowCount) {
        this._visibleRowCount = visibleRowCount;
        return this;
    }

    public XmlView createTreeView() {
        XmlTreePropertyEditorView view = null;
        view = this.getTreeNodeOtherXmlKeys() != null ? new XmlTreePropertyEditorView(this.getXmlComponentModel().getXmlKey(), this.getTreeNodeXmlKey(), this.getTreeNodeOtherXmlKeys()) : new XmlTreePropertyEditorView(this.getXmlComponentModel().getXmlKey(), this.getTreeNodeXmlKey(), new XmlKey[0]);
        return view;
    }

    public NodeFilter getNodeFilter() {
        if (this._nodeFilter == null) {
            this._nodeFilter = this.createNodeFilter();
        }
        return this._nodeFilter;
    }

    public XmlTreePropertyEditor setNodeFilter(NodeFilter nodeFilter) {
        this._nodeFilter = nodeFilter;
        return this;
    }

    public NodeFilter createNodeFilter() {
        return new NodeFilter(){

            @Override
            public short acceptNode(Node node) {
                return 1;
            }
        };
    }

    public XmlKey getTreeNodeXmlKey() {
        return this._treeNodeXmlKey;
    }

    public XmlTreePropertyEditor setTreeNodeXmlKey(XmlKey xmlKey) {
        this._treeNodeXmlKey = xmlKey;
        return this;
    }

    public XmlKey[] getTreeNodeOtherXmlKeys() {
        return this._treeNodeOtherXmlKeys;
    }

    public XmlTreePropertyEditor setTreeNodeOtherXmlKeys(XmlKey ... childKeys) {
        this._treeNodeOtherXmlKeys = childKeys;
        return this;
    }

    protected void updateChildXmlComponents(boolean enableChildHeader) {
        if (this.getXmlComponentWrapper().getChildHeaderComponent() != null) {
            this.getXmlComponentWrapper().getChildHeaderComponent().setEnabled(enableChildHeader);
        }
        this.getXmlComponentWrapper().updateChildXmlComponents();
    }

    public void registerGuiFactory(GuiXmlContext jc) {
        jc.registerGuiFactory(new XmlGuiFactory(){

            public XmlGui createGui(XmlView view, XmlUsage usage) {
                if (XmlTreePropertyEditor.this._xmlUsage.equals((Object)usage)) {
                    return new XmlTreePropertyEditorGui(view);
                }
                return null;
            }
        });
    }

    public void registerViewFactory(GuiXmlContext guiXmlContext) {
        guiXmlContext.registerViewFactory(new XmlViewFactory(){

            public XmlView createView(XmlModel xmlModel, XmlUsage xmlUsage) {
                XmlView view = null;
                if (XmlTreePropertyEditor.this._xmlUsage.equals((Object)xmlUsage)) {
                    view = XmlTreePropertyEditor.this.createTreeView();
                }
                return view;
            }
        });
    }

    public ActionMenuToolButton getAddButton() {
        return this._addButton;
    }

    public JButton getDeleteButton() {
        return this._deleteButton;
    }

    public Action createAddAction() {
        AbstractAction addAction = new AbstractAction("", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XmlTreePropertyEditor.this.getXmlTreeGui().getJTree().getModel().getChildCount(XmlTreePropertyEditor.this.getXmlTreeGui().getJTree().getModel().getRoot()) > 0) {
                    XmlTreePropertyEditor.this.getAddButton().getPopup().show((Component)((Object)XmlTreePropertyEditor.this._addButton), 0, XmlTreePropertyEditor.this._addButton.getHeight());
                } else {
                    String msg = XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel().getXmlGui().getTranslatedString("XMLCOMPONENTMODEL_UNDO_INSERT");
                    String undoInsertMsg = FastMessageFormat.formatMessage((String)msg, (String)XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel().getShortDisplayName());
                    new FixedNameTransactionTask(undoInsertMsg){

                        protected void performTask(AbstractModel model) throws XmlCommitException {
                            Node childNode = XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel().getNode();
                            if (childNode == null) {
                                XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel().insertChildNode();
                            }
                            XmlComponentModel parentXmlComponentModel = XmlComponentModel.createXmlComponentModel((XmlKey)XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel().getXmlKey(), (XmlKey)XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel().getRootXmlKey(), (XmlGui)XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel().getXmlGui());
                            parentXmlComponentModel.setParentXmlComponentModel(XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel());
                            XmlComponentModel xmlComponentModel = XmlComponentModel.createXmlComponentModel((XmlKey)XmlTreePropertyEditor.this.getTreeNodeXmlKey(), (XmlKey)XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel().getRootXmlKey(), (XmlGui)XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel().getXmlGui());
                            xmlComponentModel.setParentXmlComponentModel(parentXmlComponentModel);
                            xmlComponentModel.insertChildNode();
                            XmlTreePropertyEditor.this.getXmlTreeGui().initTree();
                        }
                    }.run((AbstractModel)XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel().getView());
                }
            }
        };
        addAction.putValue("ShortDescription", JDevBundle.get("TREE_EDITOR.ADD"));
        return addAction;
    }

    public Action createDeleteAction() {
        AbstractAction deleteAction = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(final ActionEvent e) {
                String msg = XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel().getXmlGui().getTranslatedString("XMLCOMPONENTMODEL_UNDO_DELETE");
                String undoDeleteMsg = FastMessageFormat.formatMessage((String)msg, (String)XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel().getShortDisplayName());
                new FixedNameTransactionTask(undoDeleteMsg){

                    protected void performTask(AbstractModel model) throws XmlCommitException {
                        int currentSelectedIndex = XmlTreePropertyEditor.this.getXmlTreeGui().getJTree().getLeadSelectionRow();
                        XmlTreePropertyEditor.this.getXmlTreeGui().getGuiContext().getAction("cut").actionPerformed(e);
                        if (currentSelectedIndex > 0) {
                            --currentSelectedIndex;
                        }
                        XmlTreePropertyEditor.this.handleTreeUpdate(currentSelectedIndex, false);
                    }
                }.run((AbstractModel)XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel().getView());
            }
        };
        deleteAction.putValue("ShortDescription", JDevBundle.get("TREE_EDITOR.DELETE"));
        return deleteAction;
    }

    public void handleTreeUpdate(int currentSelectedIndex, boolean updateSelection) {
        TreePath currSelectedPath;
        if (this.getXmlTreeGui().getJTree().getModel().getChildCount(this.getXmlTreeGui().getJTree().getModel().getRoot()) == 0) {
            this.getXmlTreeGui().setShowHighlightedNodes(false);
            this.getXmlComponentModel().setNode(null);
            this.getXmlComponentModel().setSelectedIndex(-1);
            this.updateChildXmlComponents(true);
        } else if (currentSelectedIndex > -1 && (currSelectedPath = this.getXmlTreeGui().getJTree().getPathForRow(currentSelectedIndex)) != null) {
            if (DomUtils.getOwnerDocument((Node)((Node)currSelectedPath.getLastPathComponent())) != this.getXmlTreeGui().getView().getDocument()) {
                return;
            }
            if (updateSelection) {
                this.getXmlTreeGui().getJTree().setSelectionPath(currSelectedPath);
            }
            this.getXmlComponentModel().setNode((Node)currSelectedPath.getLastPathComponent());
            this.getXmlComponentModel().setSelectedIndex(currentSelectedIndex);
            this.updateChildXmlComponents(true);
        }
        this.updateAddDeleteButtons(null, this.getXmlTreeGui().getJTree());
    }

    public void updateAddDeleteButtons(Node selectedNode, JTree xmlTree) {
        Object selectedItem;
        int leadSelectionRow;
        Node currNode = selectedNode;
        if (currNode == null && this.getXmlTreeGui().getComponent() != null && xmlTree.getSelectionCount() > 0 && (leadSelectionRow = xmlTree.getLeadSelectionRow()) > -1 && (selectedItem = xmlTree.getPathForRow(leadSelectionRow).getLastPathComponent()) instanceof Node) {
            currNode = (Node)selectedItem;
        }
        if (currNode != null) {
            this.getXmlTreeGui().refreshPopupMenu(this._addButton.getPopup(), currNode);
        } else {
            this._addButton.getPopup().removeAll();
        }
        int rowCnt = xmlTree.getRowCount();
        if (currNode != null || rowCnt == 0) {
            this._addButton.setEnabled(true);
        } else if (currNode == null || xmlTree.getSelectionCount() == 0) {
            this._addButton.setEnabled(false);
        }
        if (this._deleteButton != null) {
            this._deleteButton.setEnabled(xmlTree.getSelectionCount() > 0);
        }
    }

    public void selectFirstRowIfNoCurrentSelection() {
        if (this.getXmlTreeGui().getJTree().getSelectionCount() == 0 && this.getXmlTreeGui().getJTree().getRowCount() > 0) {
            Node selectedModelNode;
            Node selectedNode = this.getXmlTreeGui().getView().getSelection().getFirstSelectedNode();
            if (selectedNode == null && (selectedModelNode = this.getXmlTreeGui().getView().getBaseModel().getSelection().getFirstSelectedNode()) != null && this.getXmlTreeGui().getView().modelToView(selectedModelNode) != null) {
                selectedNode = selectedModelNode;
            }
            if (selectedNode == null && !this.getXmlTreeGui().getHighlightedNodes().isEmpty()) {
                Node highlightedNode = (Node)this.getXmlTreeGui().getHighlightedNodes().iterator().next();
                if (highlightedNode == null || DomUtils.getOwnerDocument((Node)highlightedNode) != this.getXmlTreeGui().getView().getDocument()) {
                    this.getXmlTreeGui().setHighlightedNodes(null);
                } else {
                    selectedNode = highlightedNode;
                }
            }
            if (selectedNode == null) {
                Object firstTreeNode = this.getXmlTreeGui().getJTree().getPathForRow(0).getLastPathComponent();
                if (!(firstTreeNode instanceof Node)) {
                    return;
                }
                if (DomUtils.getOwnerDocument((Node)((Node)firstTreeNode)) != this.getXmlTreeGui().getView().getDocument()) {
                    return;
                }
                selectedNode = (Node)firstTreeNode;
            }
            if (selectedNode != null && selectedNode instanceof Node) {
                this._selectNode(selectedNode);
            }
        }
    }

    public JPanel createTreePanel(String displayName) {
        this.getXmlTreeGui().initTree();
        this.getXmlTreeGui().getComponent().addTreeSelectionListener(this.getXmlTreeSelectionListener());
        this._treeScrollPane = new JScrollPane(this.getXmlTreeGui().getJTree());
        this._treeScrollPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        ResizeComponent resizeComponent = new ResizeComponent((JComponent)this._treeScrollPane);
        HeaderPanel midPanel = this.buildHeaderPanel((Component)resizeComponent, Header.Level.SUBSUB, displayName, true, false, true, null);
        resizeComponent.setBorder(BorderFactory.createEmptyBorder());
        midPanel.getHeader().addActionControl((Component)this.getAddButton());
        midPanel.getHeader().addActionControl((Component)this.getDeleteButton());
        if (this.getXmlComponentWrapper().getParent() == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new ReadOnlyTask<Boolean>(){

                        protected Boolean runImpl(AbstractModel model) {
                            XmlTreePropertyEditor.this.selectFirstRowIfNoCurrentSelection();
                            return true;
                        }
                    }.run((AbstractModel)XmlTreePropertyEditor.this.getXmlTreeGui().getView());
                }
            });
        } else {
            this.updateAddDeleteButtons(null, this.getXmlTreeGui().getJTree());
        }
        return midPanel;
    }

    public HeaderPanel buildHeaderPanel(Component component, Header.Level level, String title, boolean displayBorder, boolean indent, boolean expanded, Icon icon) {
        HeaderPanel headerPanel = new HeaderPanel((JComponent)component);
        headerPanel.setComponentBorderPainted(displayBorder);
        headerPanel.setComponentIndented(indent);
        Header header = headerPanel.getHeader();
        if (title != null) {
            header.setText(title);
        }
        if (icon != null) {
            header.setIcon(icon);
        }
        header.setLevel(level);
        header.setExpanded(expanded);
        header.setExpandable(false);
        return headerPanel;
    }

    static boolean __isDecendentOfRootNode(Set roots, Node node) {
        for (Node root : roots) {
            if (!DomUtils.isDescendant((Node)node, (Node)root)) continue;
            return true;
        }
        return false;
    }

    public static Node findFirstNodeByKey(AbstractModel model, XmlKey key, Node parentNode) {
        if (model == null) {
            throw new IllegalArgumentException("null model");
        }
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        TreeTraversal traversal = model.getTreeTraversal();
        Node walk = parentNode;
        while (walk != null) {
            XmlKey walkKey = model.getNodeXmlKey(walk);
            if (key.equals((Object)walkKey)) {
                return walk;
            }
            if (DomUtils.isDescendant((Node)(walk = traversal.getNextNode(walk)), (Node)parentNode)) continue;
            walk = null;
            break;
        }
        return null;
    }

    public boolean handleSelectionChanged(final Object selectedObject) {
        if (!(selectedObject instanceof Node)) {
            return false;
        }
        return (Boolean)new ReadOnlyTask<Boolean>(){

            protected Boolean runImpl(AbstractModel model) {
                Node componentNode = XmlTreePropertyEditor.this.getXmlComponentModel().getParentNode();
                if (componentNode == null) {
                    return false;
                }
                boolean isNodeOrDescendant = DomUtils.isNodeOrDescendant((TreeTraversal)XmlTreePropertyEditor.this.getXmlComponentModel().getView().getTreeTraversal(), (Node)((Node)selectedObject), (Node)componentNode);
                if (isNodeOrDescendant) {
                    Node selectedNode = (Node)selectedObject;
                    if (XmlTreePropertyEditor.this.getXmlTreeGui().getView().modelToView(selectedNode) != null) {
                        XmlTreePropertyEditor.this._selectNode((Node)selectedObject);
                    } else {
                        Node currNode = (Node)selectedObject;
                        while (currNode != null) {
                            if ((currNode = currNode.getParentNode()) == null || XmlTreePropertyEditor.this.getXmlTreeGui().getView().modelToView(currNode) == null) continue;
                            if (currNode.getNodeType() == 9) {
                                return false;
                            }
                            XmlTreePropertyEditor.this._selectNode(currNode);
                            if (XmlTreePropertyEditor.this.getNodeFilter().acceptNode((Node)selectedObject) == 1) {
                                return true;
                            }
                            return false;
                        }
                    }
                }
                return true;
            }
        }.run((AbstractModel)this.getXmlTreeGui().getView());
    }

    private void _selectNode(Node currNode) {
        if (DomUtils.getOwnerDocument((Node)currNode) != this.getXmlTreeGui().getView().getDocument()) {
            return;
        }
        if (this.getXmlTreeGui().getView().modelToView(currNode) == null) {
            return;
        }
        ArrayList<Node> nodeList = new ArrayList<Node>();
        nodeList.add(currNode);
        this.getXmlTreeGui().setShowHighlightedNodes(true);
        this.getXmlTreeGui().setHighlightedNodes(nodeList);
        this.getXmlComponentModel().setNode(currNode);
        this.getXmlComponentModel().setSelectedIndex(1);
        this.updateAddDeleteButtons(currNode, this.getXmlTreeGui().getJTree());
        this.updateChildXmlComponents(true);
    }

    public class AddMenuButton
    extends ActionMenuToolButton {
        public AddMenuButton(Action action) {
            super(action);
            this.createPopupMenu();
        }
    }

    public class XmlTreePropertyEditorGui
    extends SwingExplorerGui {
        private JPopupMenu _rightClickContextPopup;

        public XmlTreePropertyEditorGui(XmlView xmlView) {
            super(xmlView);
            this._rightClickContextPopup = new JPopupMenu();
        }

        public void initTree() {
            new ReadOnlyTask<Boolean>(){

                protected Boolean runImpl(AbstractModel model) {
                    ((XmlTreePropertyEditorView)model).initializeView();
                    return true;
                }
            }.run((AbstractModel)this.getView());
            this.getComponent().setShowsRootHandles(false);
            this.getComponent().setRootVisible(false);
            if (XmlTreePropertyEditor.this.getVisibleRowCount() > 0) {
                this.getComponent().setVisibleRowCount(XmlTreePropertyEditor.this.getVisibleRowCount());
            }
        }

        protected boolean showErrorsFolder() {
            return false;
        }

        protected boolean shouldUseLargeModel() {
            return false;
        }

        protected boolean paintDropFeedback() {
            return false;
        }

        protected void handleModelChangeEventImpl(XmlModelEvent event) {
            Node highlightedNode;
            super.handleModelChangeEventImpl(event);
            boolean handleModelChange = false;
            if (event.getReadOnlyPropertyChange() != null) {
                handleModelChange = true;
            } else if (event.isDomDocumentChanged()) {
                handleModelChange = true;
            }
            if (!handleModelChange) {
                return;
            }
            if (this.getView().getDocument().getDocumentElement() == null) {
                return;
            }
            if (!this.getHighlightedNodes().isEmpty() && DomUtils.getOwnerDocument((Node)(highlightedNode = (Node)this.getHighlightedNodes().iterator().next())) != XmlTreePropertyEditor.this.getXmlTreeGui().getView().getDocument()) {
                XmlTreePropertyEditor.this.getXmlTreeGui().setHighlightedNodes(null);
            }
            final int currentSelectedIndex = this.getJTree().getLeadSelectionRow();
            this.initTree();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new NonDomMutationTransactionTask(){

                        protected void performTask(AbstractModel model) {
                            ((XmlTreeModel)XmlTreePropertyEditorGui.this.getJTree().getModel()).triggerStructureChangeEvent();
                            XmlTreePropertyEditorGui.this.expandTree();
                            XmlTreePropertyEditor.this.handleTreeUpdate(currentSelectedIndex, true);
                        }
                    }.run((AbstractModel)XmlTreePropertyEditor.this.getXmlTreeGui().getView());
                }
            });
        }

        protected void expandTree() {
            for (int i = 0; i < this.getJTree().getRowCount(); ++i) {
                XmlTreePropertyEditor.this.getTree().expandRow(i);
            }
        }

        protected JTree createJTree() {
            return new XmlJTree(this){

                public void removeSelectionPath(TreePath path) {
                    XmlTreePropertyEditor.this._removeSelectionPathCalled = true;
                    this.getSelectionModel().removeSelectionPath(path);
                    XmlTreePropertyEditor.this._removeSelectionPathCalled = false;
                }
            };
        }

        protected TreeCellRenderer createTreeCellRenderer(JTree tree) {
            TreeCellRenderer baseRenderer = tree.getCellRenderer();
            if (!(baseRenderer instanceof JLabel)) {
                baseRenderer = new DefaultTreeCellRenderer();
            }
            return new XmlTreeCellRenderer(this, baseRenderer){

                protected Color getHighlightedNodeColor() {
                    return _HIGHLIGHT_COLOR;
                }
            };
        }

        protected void showPopupMenu(MouseEvent me, TreePath clickedPath) {
            if (this.getTreeModel().pathToSourceDom(clickedPath) != null) {
                this.refreshPopupMenu(this._rightClickContextPopup, (Node)clickedPath.getLastPathComponent());
                this.refreshPopupMenu(XmlTreePropertyEditor.this._addButton.getPopup(), (Node)clickedPath.getLastPathComponent());
                this._rightClickContextPopup.show((Component)me.getSource(), me.getX() + 3, me.getY() + 3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshPopupMenu(JPopupMenu popupMenu, Node selectedNode) {
            List extraMenus;
            popupMenu.removeAll();
            DomPosition selectedPosition = DomPositionFactory.createInsideOrAfterPosition((Node)selectedNode);
            this.getView().acquireReadLock();
            try {
                extraMenus = UIUtils.asComponentList((List)this.getView().getExtraContextMenus(selectedPosition));
            }
            finally {
                this.getView().releaseReadLock();
            }
            for (Component currComponent : extraMenus) {
                if (!(currComponent instanceof AbstractButton)) continue;
                AbstractButton currButton = (AbstractButton)currComponent;
                currButton.setIcon(IdeIcons.getIcon((int)23));
                popupMenu.add(currButton);
            }
            this.refreshPopupMenuHook(popupMenu);
        }

        public void refreshPopupMenuHook(JPopupMenu popupMenu) {
        }
    }

    public class XmlTreeSelectionListener
    implements TreeSelectionListener {
        @Override
        public void valueChanged(final TreeSelectionEvent event) {
            final boolean removeSelectionPathCalled = XmlTreePropertyEditor.this._removeSelectionPathCalled;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new ReadOnlyTask<Boolean>(){

                        protected Boolean runImpl(AbstractModel model) {
                            if (event.getNewLeadSelectionPath() == null) {
                                if (removeSelectionPathCalled) {
                                    XmlTreePropertyEditor.this.getXmlTreeGui().setShowHighlightedNodes(false);
                                    XmlTreePropertyEditor.this.getXmlComponentModel().setNode(null);
                                    XmlTreePropertyEditor.this.getXmlComponentModel().setSelectedIndex(-1);
                                    XmlTreePropertyEditor.this.updateAddDeleteButtons(null, XmlTreePropertyEditor.this.getXmlTreeGui().getJTree());
                                    XmlTreePropertyEditor.this.updateChildXmlComponents(false);
                                }
                            } else {
                                Node selectedNode = (Node)event.getNewLeadSelectionPath().getLastPathComponent();
                                if (DomUtils.getOwnerDocument((Node)selectedNode) != XmlTreePropertyEditor.this.getXmlTreeGui().getView().getDocument()) {
                                    return false;
                                }
                                if (XmlTreePropertyEditor.this.getXmlTreeGui().getView().modelToView(selectedNode) != null) {
                                    XmlTreePropertyEditor.this._selectNode(selectedNode);
                                }
                            }
                            return true;
                        }
                    }.run((AbstractModel)XmlTreePropertyEditor.this.getXmlTreeGui().getView());
                }
            });
        }
    }

    public class XmlTreePropertyEditorView
    extends XmlTreeKeyRootedMultipleRootFilteredView {
        public XmlTreePropertyEditorView(XmlKey rootKey, XmlKey childKey, XmlKey ... childKeys) {
            super(rootKey, childKey, childKeys);
        }

        @Override
        protected short acceptNodeInSubtree(Node modelNode) {
            if (DomUtils.isDocument((Node)modelNode)) {
                return 1;
            }
            if (XmlTreePropertyEditor.this.getTreeParentNode() != null && !DomUtils.isDescendant((TreeTraversal)this.getBaseModel().getTreeTraversal(), (Node)modelNode, (Node)XmlTreePropertyEditor.this.getTreeParentNode())) {
                return 2;
            }
            if (XmlTreePropertyEditor.this.getNodeFilter() != null) {
                return XmlTreePropertyEditor.this.getNodeFilter().acceptNode(modelNode);
            }
            return 1;
        }

        protected boolean validatesTransactions() {
            return false;
        }

        public boolean requiresValidModel() {
            return false;
        }

        @Override
        protected Node getViewParentNode() {
            return XmlTreePropertyEditor.this.getTreeParentNode();
        }

        public List getExtraContextMenus(DomPosition position) {
            if (this.getChildKeySet().contains(this.getXmlMetadataResolver().getNodeXmlKey(position.getTargetNode()))) {
                ArrayList menuList = new ArrayList();
                List menuList1 = InsertionMenuGenerator.generateInsertionMenus((XmlView)XmlTreePropertyEditor.this.getXmlComponentWrapper().getXmlComponentModel().getView(), (DomPosition)position);
                List menuList2 = InsertionMenuGenerator.generateInsertionMenus((XmlView)this, (DomPosition)position);
                if (menuList1.size() == 3 && menuList2.size() == 1) {
                    menuList.add(menuList1.get(0));
                    menuList.add(menuList2.get(0));
                    menuList.add(menuList1.get(2));
                    return menuList;
                }
                return menuList1;
            }
            return InsertionMenuGenerator.generateInsertionMenus((XmlView)this, (DomPosition)position);
        }

        protected MetadataEvaluator createMetadataEvaluator() {
            return this.getBaseModel().getXmlMetadataResolver().getMetadataEvaluator();
        }

        protected XmlMetadataResolver createXmlMetadataResolver(MetadataEvaluator evaluator) {
            return new XmlMetadataResolver(evaluator, (AbstractModel)this.getBaseModel()){

                protected short acceptNodeForInsertMenu(Node modelNode) {
                    if (XmlTreePropertyEditor.this.getNodeFilter() != null) {
                        return XmlTreePropertyEditor.this.getNodeFilter().acceptNode(modelNode);
                    }
                    return 1;
                }

                protected boolean isValidInsertionImpl(Node containerNode, XmlKey parentKey, Node child, XmlKey childKey, int relativePosition) {
                    boolean isValidInsertion = super.isValidInsertionImpl(containerNode, parentKey, child, childKey, relativePosition);
                    if (isValidInsertion) {
                        if (childKey.getNamespace() == null) {
                            return false;
                        }
                        Element potentialChildNode = XmlTreePropertyEditorView.this.getDocument().createElementNS(childKey.getNamespace(), childKey.getLocalName());
                        if (this.acceptNodeForInsertMenu(potentialChildNode) != 1) {
                            isValidInsertion = false;
                        }
                    }
                    return isValidInsertion;
                }
            };
        }
    }

    public abstract class XmlTreeAbstractMultipleRootFilteredView
    extends FilteredView {
        private Set _roots = null;
        private final Map _cache = new HashMap();

        protected abstract Set updateRootNodes(XmlModelEvent var1, Set var2);

        protected short acceptNodeInSubtree(Node modelNode) {
            return 1;
        }

        protected XmlModelEvent transformModelEventHook(XmlModelEvent modelChangeEvent) {
            if (modelChangeEvent.isDomTreeChanged()) {
                Set oldRoots = this._roots;
                this._roots = this.updateRootNodes(modelChangeEvent, oldRoots);
                if (!this._equal(oldRoots, this._roots) || modelChangeEvent.isDomStructureChanged()) {
                    this._clearCache();
                }
            }
            return super.transformModelEventHook(modelChangeEvent);
        }

        protected final short acceptNode(Node modelNode) {
            if (DomUtils.isDocument((Node)modelNode)) {
                return 1;
            }
            if (this._roots == null) {
                return 2;
            }
            short initialRet = this._acceptNodeUnderSubtree(modelNode);
            if (initialRet != 1 || this._isRootOrDocNode(modelNode)) {
                return initialRet;
            }
            return this.acceptNodeInSubtree(modelNode);
        }

        protected boolean isPossibleNewleyCreatedRoot(Node node) {
            return false;
        }

        protected void baseModelAttached() {
            super.baseModelAttached();
            this._roots = this.updateRootNodes(null, this._roots);
            this._clearCache();
        }

        private boolean _isRootOrDocNode(Node node) {
            return node.getNodeType() == 9 || this._roots != null && this._roots.contains(node);
        }

        private boolean _equal(Set a1, Set a2) {
            if (a1 == a2) {
                return true;
            }
            if (a1 != null && a2 != null) {
                return a1.equals(a2);
            }
            return false;
        }

        private short _acceptNodeUnderSubtree(Node node) {
            short ret;
            Short cached = (Short)this._cache.get(node);
            short s = ret = cached != null ? (short)cached : (short)-1;
            if (ret == -1) {
                ret = this._isRootOrDocNode(node) ? _ACCEPT : (this._isAncestorOfRootNode(node) ? _SKIP : (XmlTreePropertyEditor.__isDecendentOfRootNode(this._roots, node) ? _ACCEPT : (this.isPossibleNewleyCreatedRoot(node) ? _ACCEPT.shortValue() : _SKIP.shortValue())));
                this._cache.put(node, ret);
            }
            return ret;
        }

        private boolean _isAncestorOfRootNode(Node node) {
            for (Node root : this._roots) {
                if (!DomUtils.isDescendant((Node)root, (Node)node)) continue;
                return true;
            }
            return false;
        }

        private void _clearCache() {
            this._cache.clear();
        }

        public void initializeView() {
            this._clearCache();
            this._roots = this.updateRootNodes(null, null);
        }
    }

    public class XmlTreeKeyRootedMultipleRootFilteredView
    extends XmlTreeAbstractMultipleRootFilteredView {
        private final Set<XmlKey> _childKeys;
        private final XmlKey _rootKey;

        public XmlTreeKeyRootedMultipleRootFilteredView(XmlKey rootKey, XmlKey childKey, XmlKey ... childKeys) {
            if (rootKey == null) {
                throw new IllegalArgumentException("null root key");
            }
            if (childKey == null) {
                throw new IllegalArgumentException("must have at least one child key");
            }
            LinkedHashSet<XmlKey> keySet = new LinkedHashSet<XmlKey>();
            keySet.add(childKey);
            for (XmlKey key : childKeys) {
                keySet.add(key);
            }
            this._childKeys = Collections.unmodifiableSet(keySet);
            this._rootKey = rootKey;
        }

        public Set<XmlKey> getChildKeySet() {
            return this._childKeys;
        }

        @Override
        protected Set updateRootNodes(XmlModelEvent event, Set oldRoots) {
            boolean needToFindRoot;
            boolean bl = needToFindRoot = event == null || oldRoots.size() == 0 || event.getDomDocumentPropertyChange() != null || event.getChangeRoot() == null || XmlTreePropertyEditor.__isDecendentOfRootNode(oldRoots, event.getChangeRoot());
            if (needToFindRoot) {
                return this.getRoots((AbstractModel)this.getBaseModel(), this._rootKey, this._childKeys);
            }
            if (event != null && event.getChangeRoot() != null && event.getChangeRoot().getNamespaceURI() != null && event.getChangeRoot().getLocalName() != null && this._rootKey.getNamespace().equals(event.getChangeRoot().getNamespaceURI()) && this._rootKey.getLocalName().equals(event.getChangeRoot().getLocalName())) {
                return this.getRoots((AbstractModel)this.getBaseModel(), this._rootKey, this._childKeys);
            }
            return oldRoots;
        }

        protected Node getViewParentNode() {
            return null;
        }

        protected Set getRoots(AbstractModel model, XmlKey rootKey, Set<XmlKey> childKeys) {
            TreeTraversal traversal = model.getTreeTraversal();
            Node rootNode = null;
            Node viewParentNode = this.getViewParentNode();
            rootNode = viewParentNode != null ? XmlTreePropertyEditor.findFirstNodeByKey(model, rootKey, viewParentNode) : XmlModelUtils.findFirstNodeByKey((AbstractModel)model, (XmlKey)rootKey);
            HashSet<Node> s = new HashSet<Node>();
            if (rootNode == null) {
                return s;
            }
            Node walk = traversal.getFirstChild(rootNode);
            while (walk != null) {
                XmlKey walkKey = model.getNodeXmlKey(walk);
                if (childKeys.contains(walkKey)) {
                    if (s == null) {
                        s = new HashSet();
                    }
                    s.add(walk);
                }
                if (DomUtils.isDescendant((Node)(walk = traversal.getNextSibling(walk)), (Node)rootNode)) continue;
                walk = null;
                break;
            }
            return s;
        }

        @Override
        protected boolean isPossibleNewleyCreatedRoot(Node node) {
            return this._childKeys.contains(this.getXmlMetadataResolver().getNodeXmlKey(node));
        }
    }
}

