/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.undo;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.gui.jdev.undo.MultiEditUndoableEditCommand;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.model.Node;

public class UndoableEditIdeCommand
extends Command {
    private boolean _hasBeenUndone = false;
    private final UndoableEdit _edit;
    private static final int _CMD_ID = Ide.findOrCreateCmdID((String)UndoableEditIdeCommand.class.getName());
    private static final Logger _LOGGER = Logger.getLogger(UndoableEditIdeCommand.class.getName());

    public UndoableEditIdeCommand(UndoableEdit edit) {
        super(_CMD_ID, MultiEditUndoableEditCommand.__getType(edit));
        this._edit = edit;
    }

    public int doit() throws Exception {
        if (this._hasBeenUndone) {
            _LOGGER.log(Level.FINER, "redo: {0}", this._edit);
            try {
                this._edit.redo();
            }
            catch (Exception e) {
                _LOGGER.log(Level.SEVERE, "Exception in redo!", e);
                return 1;
            }
        } else {
            _LOGGER.log(Level.FINER, "Ignored redo: {0}", this._edit);
        }
        this._notify();
        return 0;
    }

    public int undo() throws Exception {
        this._hasBeenUndone = true;
        _LOGGER.log(Level.FINER, "undo: {0}", this._edit);
        try {
            this._edit.undo();
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, "Exception in undo!", e);
            return 1;
        }
        this._notify();
        return 0;
    }

    public String getName() {
        return this._edit.getPresentationName();
    }

    boolean __addEdit(UndoableEdit edit) {
        return this._edit.addEdit(edit);
    }

    private void _notify() {
        Context context = this.getContext();
        if (context != null) {
            Node node = context.getNode();
            MultiEditUndoableEditCommand.__notify(node);
        }
    }
}

