/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.parser.LegacyPlSqlParserImpl;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlParserFactory;
import oracle.javatools.db.plsql.parser.SQLDevPlSqlParserImpl;

public class PlSqlParserFactoryImpl
extends PlSqlParserFactory {
    static final String PARSER = "oracle.javatools.db.plsql.PlSqlParser";
    static final String LEGACY = "legacy";
    static final String SQLDEV = "sqldev";

    public PlSqlParserFactoryImpl(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public PlSqlParser createParser(String string) {
        if (this.useLegacyParser()) {
            return new LegacyPlSqlParserImpl(this.getProvider(), null, string);
        }
        return new SQLDevPlSqlParserImpl(this.getProvider(), null, string);
    }

    public PlSqlParser createParser(PlSqlSourceObject plSqlSourceObject) {
        if (this.useLegacyParser()) {
            return new LegacyPlSqlParserImpl(this.getProvider(), plSqlSourceObject, null);
        }
        return new SQLDevPlSqlParserImpl(this.getProvider(), plSqlSourceObject, null);
    }

    private boolean useLegacyParser() {
        boolean bl = false;
        String string = System.getProperty(PARSER);
        if (LEGACY.equals(string)) {
            bl = true;
        } else if (SQLDEV.equals(string)) {
            bl = false;
        }
        return bl;
    }
}

