/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class XMLTypeColumnPropertiesValidator
extends AbstractChildDBObjectValidator<XMLTypeColumnProperties> {
    public XMLTypeColumnPropertiesValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("storeAs");
        return collection;
    }

    @DBObjectValidator.PropertyValidator(value={"allowAnySchema"}, level=ValidationLevel.FULL)
    public void validateAllowAnySchema(XMLTypeColumnProperties xMLTypeColumnProperties, XMLTypeColumnProperties xMLTypeColumnProperties2) throws ValidationException {
        if (xMLTypeColumnProperties2.getElementID() != null && xMLTypeColumnProperties2.isAllowAnySchema()) {
            throw new ValidationException((DBObject)xMLTypeColumnProperties2, APIBundle.get((String)"XMLTYPE_COLPROPS_XMLSCHEMA_AND_ANY_SCHEMA_ERROR"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"allowNonSchema"}, level=ValidationLevel.FULL)
    public void validateAllowNonSchema(XMLTypeColumnProperties xMLTypeColumnProperties, XMLTypeColumnProperties xMLTypeColumnProperties2) throws ValidationException {
        if (xMLTypeColumnProperties2.getStoreAs() == XMLTypeColumnProperties.StoreAs.BINARY_XML && xMLTypeColumnProperties2.getElementID() == null && !xMLTypeColumnProperties2.isAllowAnySchema() && !xMLTypeColumnProperties2.isAllowNonSchema()) {
            throw new ValidationException((DBObject)xMLTypeColumnProperties2, APIBundle.get((String)"XMLTYPE_COLPROPS_XMLSCHEMA_OR_NON_SCHEMA_ERROR"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"elementID"}, level=ValidationLevel.FULL)
    public void validateElement(XMLTypeColumnProperties xMLTypeColumnProperties, XMLTypeColumnProperties xMLTypeColumnProperties2) throws ValidationException {
        DBObjectID dBObjectID = xMLTypeColumnProperties2.getElementID();
        if (dBObjectID == null) {
            if (xMLTypeColumnProperties2.getStoreAs() == XMLTypeColumnProperties.StoreAs.OBJECT_RELATIONAL) {
                throw new ValidationException((DBObject)xMLTypeColumnProperties2, APIBundle.get((String)"XMLTYPE_COLPROPS_ELEMENT_MISSING_ERROR"));
            }
        } else {
            if (dBObjectID.getParent() == null) {
                throw new ValidationException((DBObject)xMLTypeColumnProperties2, APIBundle.get((String)"XMLTYPE_COLPROPS_ELEMENT_PARENT_ERROR"));
            }
            if (dBObjectID.getParent() instanceof BaseObjectID && !ModelUtil.hasLength((String)((BaseObjectID)dBObjectID.getParent()).getSchemaName())) {
                throw new ValidationException((DBObject)xMLTypeColumnProperties2, APIBundle.get((String)"XMLTYPE_COLPROPS_ELEMENT_PARENT_ERROR"));
            }
        }
    }

    protected boolean canHaveEmptyName() {
        return true;
    }
}

