/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ora.OracleNestedTableProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class NestedTablePropertiesValidator
extends AbstractChildDBObjectValidator<OracleNestedTableProperties> {
    public NestedTablePropertiesValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("returnAs");
        return collection;
    }

    @DBObjectValidator.PropertyValidator(value={"tableName"}, level=ValidationLevel.FULL)
    public void validateTableName(OracleNestedTableProperties oracleNestedTableProperties, OracleNestedTableProperties oracleNestedTableProperties2) throws ValidationException {
        if (oracleNestedTableProperties2 != null) {
            if (oracleNestedTableProperties2.getTableName() == null) {
                throw new ValidationException((DBObject)oracleNestedTableProperties2, "tableName", APIBundle.get((String)"NESTED_TABLE_PROPS_TABLE_NAME_MISSING_ERROR"));
            }
            try {
                this.getProvider().validateName("TABLE", oracleNestedTableProperties2.getTableName());
            }
            catch (InvalidNameException invalidNameException) {
                throw new ValidationException((DBObject)oracleNestedTableProperties2, "tableName", APIBundle.format((String)"NESTED_TABLE_PROPS_TABLE_NAME_INVALID_ERROR", (Object[])new Object[]{invalidNameException.getMessage()}));
            }
        }
    }
}

