/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryCancelledException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.sql.XMLFunctionUsage;

public class BuiltInFunctionBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext expressionContext, ParseNode parseNode) throws SQLQueryException {
        SQLFragment sQLFragment = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        DBObjectProvider dBObjectProvider = expressionContext.getProvider();
        String string = dBObjectProvider.getInternalName(oracleSQLQueryBuilderHelper.getContent(list.get(0)));
        BuiltInFunction builtInFunction = null;
        Iterator iterator = dBObjectProvider.getDescriptor().listBuiltInFunctions(string).iterator();
        if (iterator.hasNext()) {
            BuiltInFunction builtInFunction2;
            builtInFunction = builtInFunction2 = (BuiltInFunction)iterator.next();
        }
        if (builtInFunction != null) {
            if (oracleSQLQueryBuilderHelper.isRule(parseNode, "XML_function", "xmlexists", "xmltable", "xmlagg") && oracleSQLQueryBuilderHelper.isKeyword(list.get(1), "(") && oracleSQLQueryBuilderHelper.isKeyword(list.get(list.size() - 1), ")")) {
                sQLFragment = this.createXMLFunction(expressionContext, list, string, builtInFunction);
            } else if ((oracleSQLQueryBuilderHelper.isRule(parseNode, "function_expression") || oracleSQLQueryBuilderHelper.isRule(parseNode, "JSON_exists_condition") || oracleSQLQueryBuilderHelper.isRule(parseNode, "JSON_textcontains_condition")) && oracleSQLQueryBuilderHelper.isLeaf(list.get(0))) {
                if (builtInFunction == null) {
                    if (oracleSQLQueryBuilderHelper.isKeyword(list.get(0), "MULTISET")) {
                        sQLFragment = this.createMultiset(list.get(2), expressionContext);
                    }
                } else {
                    iterator = null;
                    boolean bl = false;
                    if (oracleSQLQueryBuilderHelper.isRule(parseNode, "cast")) {
                        ParseNode parseNode2;
                        SQLFragment sQLFragment2 = null;
                        if (oracleSQLQueryBuilderHelper.isKeyword(list.get(2), "MULTISET")) {
                            parseNode2 = oracleSQLQueryBuilderHelper.getOrderedChildren(list.get(3));
                            sQLFragment2 = this.createMultiset(parseNode2.get(1), expressionContext);
                        } else {
                            sQLFragment2 = expressionContext.createFragment(list.get(2), expressionContext.getCreating());
                        }
                        parseNode2 = oracleSQLQueryBuilderHelper.getRuleNode(list, "datatype");
                        String string2 = oracleSQLQueryBuilderHelper.getContent(parseNode2);
                        SimpleSQLFragment simpleSQLFragment = new SimpleSQLFragment(string2);
                        SQLFragment[] sQLFragmentArray = new SQLFragment[]{sQLFragment2, simpleSQLFragment};
                        sQLFragment = expressionContext.createFunction(string, builtInFunction, null, false, sQLFragmentArray);
                    } else {
                        int n;
                        SQLFragment[] sQLFragmentArray;
                        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "trim")) {
                            if (oracleSQLQueryBuilderHelper.getKeywordIndex(list, "LEADING") != -1) {
                                string = "LEADING";
                                var11_13 = expressionContext.getProvider().getDescriptor().listBuiltInFunctions("LTRIM").iterator();
                                if (var11_13.hasNext()) {
                                    sQLFragmentArray = (SQLFragment[])var11_13.next();
                                    builtInFunction = sQLFragmentArray;
                                }
                            } else if (oracleSQLQueryBuilderHelper.getKeywordIndex(list, "TRAILING") != -1) {
                                string = "TRAILING";
                                var11_13 = expressionContext.getProvider().getDescriptor().listBuiltInFunctions("RTRIM").iterator();
                                if (var11_13.hasNext()) {
                                    sQLFragmentArray = (SQLFragment[])var11_13.next();
                                    builtInFunction = sQLFragmentArray;
                                }
                            } else if (oracleSQLQueryBuilderHelper.getKeywordIndex(list, "BOTH") != -1) {
                                string = "BOTH";
                            }
                        }
                        if ((n = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "DISTINCT", "ALL")) != -1) {
                            iterator = oracleSQLQueryBuilderHelper.getContent(list.get(n));
                            bl = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "DISTINCT") != -1;
                        }
                        sQLFragmentArray = null;
                        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "translate_using")) {
                            SQLFragment sQLFragment3 = expressionContext.createFragment(list.get(2), expressionContext.getCreating());
                            SimpleSQLFragment simpleSQLFragment = new SimpleSQLFragment(oracleSQLQueryBuilderHelper.getContent(list.get(4)));
                            sQLFragmentArray = new SQLFragment[]{sQLFragment3, simpleSQLFragment};
                        } else {
                            sQLFragmentArray = expressionContext.getArgList(builtInFunction.getName(), parseNode);
                        }
                        sQLFragment = expressionContext.createFunction(string, builtInFunction, (String)((Object)iterator), bl, sQLFragmentArray);
                    }
                }
            }
        }
        return sQLFragment;
    }

    private SQLFragment createMultiset(ParseNode parseNode, ExpressionContext expressionContext) throws SQLQueryException {
        Function function = null;
        SQLFragment sQLFragment = expressionContext.createFragment(parseNode, expressionContext.getCreating(), expressionContext.getQueryContext());
        function = new Function("MULTISET", new SQLFragment[]{sQLFragment});
        expressionContext.getQueryBuilder().setFunctionReturnTypeID(function);
        return function;
    }

    private SQLFragment createXMLFunction(ExpressionContext expressionContext, List<ParseNode> list, String string, BuiltInFunction builtInFunction) throws SQLQueryException {
        List<SQLFragment> list2 = this.createXMLargs(expressionContext, list.subList(2, list.size() - 1));
        SQLFragment[] sQLFragmentArray = list2.toArray(new SQLFragment[list2.size()]);
        XMLFunctionUsage xMLFunctionUsage = new XMLFunctionUsage();
        xMLFunctionUsage.setObjectID(expressionContext.findIdForFunctionString(builtInFunction.getName()));
        xMLFunctionUsage.setArguments(sQLFragmentArray);
        return xMLFunctionUsage;
    }

    private List<SQLFragment> createXMLargs(ExpressionContext expressionContext, List<ParseNode> list) throws SQLQueryException {
        ArrayList<SQLFragment> arrayList = new ArrayList<SQLFragment>();
        ArrayList<Object> arrayList2 = new ArrayList<ParseNode>();
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        for (ParseNode parseNode : list) {
            String string = oracleSQLQueryBuilderHelper.getContent(parseNode);
            if (this.hasExpr(parseNode, expressionContext)) {
                if (arrayList2.size() > 0) {
                    arrayList.add(this.createStringFragment(arrayList2, expressionContext));
                    arrayList2 = new ArrayList();
                }
                if (oracleSQLQueryBuilderHelper.isRule(parseNode, "expr")) {
                    try {
                        arrayList.add(expressionContext.createFragment(parseNode, expressionContext.getCreating()));
                        continue;
                    }
                    catch (SQLQueryCancelledException sQLQueryCancelledException) {
                        throw sQLQueryCancelledException;
                    }
                    catch (SQLQueryException sQLQueryException) {
                        arrayList.add((SQLFragment)new SimpleSQLFragment(oracleSQLQueryBuilderHelper.getContent(parseNode)));
                        continue;
                    }
                }
                List<ParseNode> list2 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
                arrayList.addAll(this.createXMLargs(expressionContext, list2));
                continue;
            }
            arrayList2.add(parseNode);
        }
        if (arrayList2.size() > 0) {
            arrayList.add(this.createStringFragment(arrayList2, expressionContext));
        }
        return arrayList;
    }

    private SQLFragment createStringFragment(List<ParseNode> list, ExpressionContext expressionContext) {
        StringBuilder stringBuilder = new StringBuilder();
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(oracleSQLQueryBuilderHelper.getContent(list.get(i)));
        }
        return new SimpleSQLFragment(stringBuilder.toString());
    }

    private boolean hasExpr(ParseNode parseNode, ExpressionContext expressionContext) {
        boolean bl = false;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "expr")) {
            bl = true;
        } else if (!oracleSQLQueryBuilderHelper.isLeaf(parseNode)) {
            List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
            for (ParseNode parseNode2 : list) {
                if (!this.hasExpr(parseNode2, expressionContext)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

