/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.db2.DB2DatabaseDescriptor;
import oracle.javatools.db.db2.DB2UniversalDatabaseImpl;
import oracle.javatools.db.db2.DB2v10UniversalDatabaseImpl;
import oracle.javatools.db.db2.DB2v9DatabaseDescriptor;
import oracle.javatools.db.db2.DB2v9UniversalDatabaseImpl;
import oracle.javatools.db.execute.StatementWrapper;

public class DB2UniversalDatabaseFactory
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String string, String string2, Connection connection) {
        int n = this.getUniversalConnectionType(connection);
        switch (n) {
            case 81: {
                return new DB2UniversalDatabaseImpl(string, string2, connection);
            }
            case 95: {
                return new DB2v9UniversalDatabaseImpl(string, string2, connection);
            }
            case 101: {
                return new DB2v10UniversalDatabaseImpl(string, string2, connection);
            }
        }
        return null;
    }

    protected int getUniversalConnectionType(Connection connection) {
        block8: {
            if (connection != null) {
                try {
                    boolean bl;
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    String string = databaseMetaData.getDriverName();
                    String string2 = databaseMetaData.getDatabaseProductName();
                    if (!string.contains("DB2") && !string.contains("IBM Data Server") && !string.contains("AS/400") && !string.contains("JDE World")) break block8;
                    int n = databaseMetaData.getDatabaseMajorVersion();
                    boolean bl2 = bl = n < 9 || Boolean.getBoolean("oracle.javatools.db.db2.DB2UniversalDatabaseFactory.useBase");
                    if (!(bl || string2 == null || string2.startsWith("DB2/LINUX") || string2.startsWith("DB2/UNIX") || string2.startsWith("DB2/NT") || string2.startsWith("DB2/WIN"))) {
                        StatementWrapper statementWrapper = new StatementWrapper("TEST", connection, new String[]{"SELECT 1 FROM SYSCAT.SCHEMATA WHERE 1=2"});
                        try {
                            statementWrapper.execute();
                        }
                        catch (DBException dBException) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        return 81;
                    }
                    if (n == 9) {
                        return 95;
                    }
                    return 101;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return -1;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        DB2DatabaseDescriptor dB2DatabaseDescriptor = null;
        if (DB2v9UniversalDatabaseImpl.class.isAssignableFrom(clazz)) {
            dB2DatabaseDescriptor = new DB2v9DatabaseDescriptor(clazz);
        } else if (DB2UniversalDatabaseImpl.class.isAssignableFrom(clazz)) {
            dB2DatabaseDescriptor = new DB2DatabaseDescriptor(clazz);
        }
        return dB2DatabaseDescriptor;
    }
}

