/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.net.URI;
import java.util.logging.Level;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.DefaultHookVisitorFactory;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.MetaClass;

public class HookHandlerHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "hook-handler-hook");
    private final DefaultHookVisitorFactory _factory;
    private final ElementName HOOKHANDLER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "hook-handler");
    private ElementVisitor _hookHandlerVisitor = new HookHandlerVisitor();

    public HookHandlerHook(DefaultHookVisitorFactory hookFactory) {
        if (hookFactory == null) {
            throw new NullPointerException("hookFactory is null");
        }
        this._factory = hookFactory;
    }

    @Override
    public void start(ElementStartContext context) {
        context.registerChildVisitor(this.HOOKHANDLER, this._hookHandlerVisitor);
    }

    private class HookHandlerVisitor
    extends ElementVisitor {
        private HookHandlerVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            ElementName elementName;
            String tagName = context.getAttributeValue("tag-name");
            if (tagName == null || (tagName = tagName.trim()) == "") {
                this.log(context, Level.SEVERE, "Missing required attribute 'tag-name'");
                return;
            }
            String handlerClass = context.getAttributeValue("handler-class");
            if (handlerClass == null || (handlerClass = handlerClass.trim()) == "") {
                this.log(context, Level.SEVERE, "Missing required attribute 'handler-class'");
                return;
            }
            String namespace = context.getAttributeValue("namespace");
            if (namespace == null || (namespace = namespace.trim()) == "") {
                this.log(context, Level.SEVERE, "Missing required attribute 'namespace'");
                return;
            }
            String schemaLocation = context.getAttributeValue("schema-location");
            if (schemaLocation != null && schemaLocation.trim().length() > 0) {
                URI sourceUri = context.getExtensionSourceURI();
                URI schemaUri = URIFactory.newJarURI(sourceUri, "META-INF/" + schemaLocation.replace('\\', '/'));
                if (!VirtualFileSystem.getVirtualFileSystem().exists(schemaUri)) {
                    this.log(context, Level.SEVERE, "Schema not found: " + VirtualFileSystem.getVirtualFileSystem().getPlatformPathName(schemaUri));
                    schemaLocation = null;
                }
            }
            if (HookHandlerHook.this._factory.isNameRegistered(elementName = new ElementName(namespace, tagName))) {
                this.log(context, Level.SEVERE, "A custom hook is already registered for " + elementName.getNamespaceURI() + ":" + elementName.getLocalName());
                return;
            }
            ClassLoader loader = (ClassLoader)context.getScopeData().get("classLoader");
            MetaClass mc = new MetaClass(loader, handlerClass);
            Object hookInstance = null;
            try {
                hookInstance = mc.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                this.log(context, Level.SEVERE, "Custom hook class " + handlerClass + " not found.");
                return;
            }
            catch (InstantiationException ie) {
                this.log(context, Level.SEVERE, "Custom hook class " + handlerClass + " cannot be instantiated.");
                ie.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                this.log(context, Level.SEVERE, "Custom hook class " + handlerClass + " is not public or does not have a public no argument constructor.");
                iae.printStackTrace();
            }
            if (hookInstance != null) {
                try {
                    ExtensionHook hook = hookInstance;
                    HookHandlerHook.this._factory.registerHook(elementName, hook);
                    hook.setSchemaLocation(schemaLocation);
                    hook.setProvider(HookHandlerHook.this.getExtension(context).getID());
                }
                catch (ClassCastException cce) {
                    this.log(context, Level.SEVERE, "Custom hook class " + handlerClass + " is not derived from " + ExtensionHook.class.getName());
                }
            }
        }
    }
}

