/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.resourceaccessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import liquibase.Scope;
import liquibase.resource.AbstractResourceAccessor;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.util.CollectionUtil;
import lombok.Generated;

public class SqlClCompositeResourceAccessor
extends AbstractResourceAccessor {
    private final List<ResourceAccessor> resourceAccessors;

    public SqlClCompositeResourceAccessor(ResourceAccessor ... resourceAccessors) {
        this.resourceAccessors = new ArrayList<ResourceAccessor>();
        this.resourceAccessors.addAll(Arrays.asList(resourceAccessors));
    }

    public SqlClCompositeResourceAccessor(Collection<ResourceAccessor> resourceAccessors) {
        this.resourceAccessors = new ArrayList<ResourceAccessor>(resourceAccessors);
    }

    public void close() throws Exception {
        for (ResourceAccessor accessor : this.resourceAccessors) {
            try {
                accessor.close();
            }
            catch (Exception e) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("Error closing " + accessor.getClass().getName() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public SqlClCompositeResourceAccessor addResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessors.add(resourceAccessor);
        return this;
    }

    public void removeResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessors.remove(resourceAccessor);
    }

    public List<Resource> search(String path, ResourceAccessor.SearchOptions searchOptions) throws IOException {
        LinkedHashSet returnList = new LinkedHashSet();
        for (ResourceAccessor accessor : this.resourceAccessors) {
            returnList.addAll(CollectionUtil.createIfNull((List)accessor.search(path, searchOptions)));
        }
        return new ArrayList<Resource>(returnList);
    }

    public List<Resource> search(String path, boolean recursive) throws IOException {
        LinkedHashSet returnList = new LinkedHashSet();
        for (ResourceAccessor accessor : this.resourceAccessors) {
            returnList.addAll(CollectionUtil.createIfNull((List)accessor.search(path, recursive)));
        }
        return new ArrayList<Resource>(returnList);
    }

    public List<Resource> getAll(String path) throws IOException {
        LinkedHashSet returnList = new LinkedHashSet();
        for (ResourceAccessor accessor : this.resourceAccessors) {
            returnList.addAll(CollectionUtil.createIfNull((List)accessor.getAll(path)));
        }
        return new ArrayList<Resource>(returnList);
    }

    public List<String> describeLocations() {
        LinkedHashSet returnSet = new LinkedHashSet();
        for (ResourceAccessor accessor : this.resourceAccessors) {
            returnSet.addAll(CollectionUtil.createIfNull((List)accessor.describeLocations()));
        }
        return new ArrayList<String>(returnSet);
    }

    @Generated
    public List<ResourceAccessor> getResourceAccessors() {
        return this.resourceAccessors;
    }
}

