/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator.changeSets.core;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Objects;
import liquibase.exception.DatabaseException;
import oracle.dbtools.raptor.liquibase.exception.GenericLbException;
import oracle.dbtools.raptor.liquibase.exception.ObjectNotFoundException;
import oracle.dbtools.raptor.liquibase.generator.changeSets.data.ChangeData;
import oracle.dbtools.raptor.liquibase.generator.changeSets.inerface.ChangeSet;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;

public abstract class AbstractChangeSet
implements ChangeSet {
    ChangeData _data = new ChangeData();

    public AbstractChangeSet() throws ObjectNotFoundException, DatabaseException {
        this.cleanDdlParam();
        if (this.isNull(this._data.getOTYPE()) || this.isNull(this._data.getONAME()) || this.isNull(this._data.getDDL())) {
            LbUtils.report(Messages.format(Messages.get("BAD_CL_DATA"), this._data.getOTYPE(), this._data.getONAME(), this._data.getDDL()));
        }
    }

    private boolean isNull(String value) {
        return null == value || value.isEmpty();
    }

    public ChangeData getData() {
        return this._data;
    }

    protected String getSha1fromString(String data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        digest.update(data.getBytes(StandardCharsets.UTF_8));
        return String.format("%040x", new BigInteger(1, digest.digest()));
    }

    private void cleanDdlParam() throws DatabaseException, ObjectNotFoundException {
        String ddl = this._data.getDDL();
        String oType = this._data.getOTYPE();
        String oName = this._data.getONAME();
        if ((null == ddl || ddl.isEmpty()) && (null == (ddl = DbmsMetaUtils.getObjectFromDb(LbUtils.getLbConnection().getUnderlyingConnection(), Objects.requireNonNull(oType), Objects.requireNonNull(oName))) || ddl.isEmpty())) {
            throw new ObjectNotFoundException(Messages.getString("LB_NO_OBJECT"));
        }
        if ("JOB".equalsIgnoreCase(this._data.getOTYPE())) {
            ddl = ddl.replaceAll("\"", "");
        }
        if ("TRIGGER".equalsIgnoreCase(this._data.getOTYPE())) {
            ddl = ddl.replace("\n\n/", "\n/");
        }
        this._data.setDDL(ddl);
    }

    @Override
    public abstract String getChange() throws NoSuchAlgorithmException, SQLException, GenericLbException;
}

