/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.jcip.annotations.GuardedBy;
import oracle.ide.file.DirectoryFileTable;
import oracle.ide.file.FileSet;
import oracle.ide.file.FileSetFilter;
import oracle.ide.file.FileSetFilters;
import oracle.ide.file.FileTable;
import oracle.ide.file.FileTableKey;
import oracle.ide.file.FileTableVisitor;
import oracle.ide.file.JarFileTable;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.persistence.Storage;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.util.Maps;
import oracle.javatools.util.NullArgumentException;
import oracle.javatools.util.Pair;

public abstract class FileSetTable
extends FileTable {
    @GuardedBy(value="itself")
    private static final Maps.CacheMap<FileTableKey, FileSetTable> INSTANCES = new Maps.CacheMap((Maps.CacheStrategy)new Maps.UnboundedCacheStrategy(100, 0.75f, Maps.CacheMap.Canonicity.CANONICAL, Maps.CacheMap.Strength.SOFT));
    protected final FileSet fileSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSetTable getInstance(@NotNull Storage storage, @NotNull FileSet fileSet) {
        if (storage == null) {
            throw new NullArgumentException("null storage");
        }
        if (fileSet == null) {
            throw new NullArgumentException("null file set");
        }
        Maps.CacheMap<FileTableKey, FileSetTable> cacheMap = INSTANCES;
        synchronized (cacheMap) {
            fileSet = fileSet.intern();
            FileTableKey key = new FileTableKey(storage, fileSet);
            FileSetTable table = (FileSetTable)INSTANCES.get((Object)key);
            if (table == null) {
                table = JarUtil.isJarURL((URL)fileSet.getRoot()) ? new JarFileTable(storage, fileSet) : new DirectoryFileTable(storage, fileSet);
                INSTANCES.put((Object)key, (Object)table);
            }
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void uncache(Storage storage) {
        Maps.CacheMap<FileTableKey, FileSetTable> cacheMap = INSTANCES;
        synchronized (cacheMap) {
            ArrayList<FileTableKey> keysToEvict = new ArrayList<FileTableKey>();
            for (Map.Entry entry : INSTANCES.entrySet()) {
                if (!storage.equals(((FileTableKey)entry.getKey()).getStorage())) continue;
                keysToEvict.add((FileTableKey)entry.getKey());
            }
            for (FileTableKey key : keysToEvict) {
                INSTANCES.evict((Object)key);
            }
        }
    }

    protected FileSetTable(Storage storage, FileSet fileSet) {
        super(storage);
        this.fileSet = fileSet;
    }

    public FileSet getFileSet() {
        return this.fileSet;
    }

    @Override
    public String getRelativePath(URL url) {
        return URLFileSystem.toRelativeSpec((URL)url, (URL)this.fileSet.getRoot(), (boolean)true);
    }

    public abstract String getRelativePath(int var1) throws InterruptedException, IOException;

    public abstract String getParentPath(int var1) throws InterruptedException, IOException;

    public abstract String getFileName(int var1) throws InterruptedException, IOException;

    public abstract Collection<String> getFilePaths() throws IOException, InterruptedException;

    public abstract Collection<String> getDirectoryPaths() throws IOException, InterruptedException;

    public abstract Collection<String> getSubdirectories(String var1) throws IOException, InterruptedException;

    public abstract Collection<String> getFiles(String var1) throws IOException, InterruptedException;

    public abstract Collection<URL> getFileUrls(String var1) throws IOException, InterruptedException;

    public abstract Collection<Pair<URL, Long>> getFileUrlsAndTimestamps(String var1) throws IOException, InterruptedException;

    public abstract void visitFiles(FileTableVisitor var1) throws IOException, InterruptedException;

    @Override
    public boolean contains(URL url) {
        return this.fileSet.contains(url);
    }

    @Override
    public String getStorageKey() {
        this.storage.open();
        try {
            String string = this.getBaseNameSpaceKey();
            return string;
        }
        finally {
            this.storage.close();
        }
    }

    protected String getBaseNameSpaceKey() {
        return this.storage.getRelativePath(this.fileSet.getRoot()) + this.fileSet.getFilter().getUniqueIdentifier();
    }

    protected static void checkInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public String toString() {
        return this.fileSet.toString() + "@" + this.storage.toString();
    }

    protected FileSetFilter getFilter() {
        return FileSetFilters.getIntersectionFilter(this.fileSet.getFilter(), FileSetFilters.getGlobalFilter());
    }
}

