/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.Storage;
import oracle.ide.persistence.Storages;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.MapFactory;
import oracle.javatools.assembly.ObjectArrayFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.StringFactory;

public final class DependencyCache {
    private final Workspace workspace;
    private static Logger logger = Logger.getLogger(DependencyCache.class.getName());
    private boolean dirty = true;
    private boolean loaded = false;
    static final String NAMESPACE_KEY = "$index.DependencyCache$";
    public static final byte STORAGE_CODE = -31;
    public static final byte COLLECTION_CODE = -30;
    public static final byte TIMESTAMP_STORAGE_CODE = -29;
    protected final CollectionFactory COLLECTION_FACTORY = new CollectionFactory((AssemblyFactory)StringFactory.STRING_FACTORY);
    protected final DependencyCacheStorageFactory STORAGE_FACTORY = new DependencyCacheStorageFactory();
    protected final TimestampFactory TIMESTAMP_FACTORY = new TimestampFactory();
    protected final AssemblyFactory MAP_FACTORY = new MapFactory((AssemblyFactory)StringFactory.STRING_FACTORY, (AssemblyFactory)this.COLLECTION_FACTORY);
    protected final AssemblyFactory TIMESTAMP_MAP_FACTORY = new MapFactory((AssemblyFactory)StringFactory.STRING_FACTORY, (AssemblyFactory)this.TIMESTAMP_FACTORY);
    private final AssemblyFactory MAP_ARRAY_FACTORY = new ObjectArrayFactory(this.MAP_FACTORY);
    private final int PERFORMANCE_LOGGER_THRESHOLD = 500;
    private final Storage storage;
    private final String storageKey = "depcache";
    private final String timestampsKey = "deptimestamps";
    private WorkspaceObserver workspaceObserver = new WorkspaceObserver();
    private ProjectObserver projectObserver = new ProjectObserver();
    HashSet<Project> observedProjects = new HashSet();
    private final HashMap<Project, Collection<Project>> up = new HashMap();
    private final HashMap<Project, Collection<Project>> down = new HashMap();
    private static final HashMap<Workspace, DependencyCache> INSTANCES = new HashMap();
    private static final DependencyListener dependencyListener = new DependencyListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DependencyCache getInstance(Context context) {
        HashMap<Workspace, DependencyCache> hashMap = INSTANCES;
        synchronized (hashMap) {
            Workspace workspace = context.getWorkspace();
            DependencyCache instance = INSTANCES.get(workspace);
            if (instance == null) {
                instance = new DependencyCache(workspace);
                INSTANCES.put(workspace, instance);
            }
            return instance;
        }
    }

    private DependencyCache(Workspace workspace) {
        this.workspace = workspace;
        if (workspace != null) {
            workspace.attach((Observer)this.workspaceObserver);
            this.storage = Storages.getApplicationStorage((Workspace)workspace);
        } else {
            this.storage = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void update() throws InterruptedException {
        if (this.loaded && !this.dirty) {
            return;
        }
        if (this.storage != null) {
            this.storage.open();
            try {
                NameSpace namespace = this.storage.getNameSpace(NAMESPACE_KEY, 1);
                if (namespace == null) return;
                try {
                    this.loadDependencyCache(namespace);
                    Collection<Project> allProjects = this.getProjects();
                    if (this.hasMissingProjects(allProjects)) {
                        this.dirty = true;
                    }
                    if (!this.updateCache(allProjects)) return;
                    this.saveCacheToStorage(namespace);
                    return;
                }
                finally {
                    namespace.close();
                }
            }
            finally {
                this.storage.close();
            }
        } else {
            this.updateCache(this.getProjects());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDependencyCache(NameSpace namespace) {
        block26: {
            byte[] data;
            block27: {
                boolean timestampsMatch = true;
                if (namespace == null) break block26;
                PerformanceLogger.get().startTiming("DependencyCache.loadDependencyCache#timestamps");
                data = namespace.getRecord("deptimestamps");
                if (data != null) {
                    HashMap timestamps = null;
                    try {
                        timestamps = (HashMap)this.TIMESTAMP_MAP_FACTORY.assemble(data);
                    }
                    catch (AssemblyException e) {
                        logger.log(Level.INFO, "Unable to load project timestamps for " + URLFileSystem.getPlatformPathName((URL)this.workspace.getURL()), e);
                    }
                    if (timestamps == null || timestamps.isEmpty()) {
                        timestampsMatch = false;
                    } else if (this.storage != null) {
                        this.storage.open();
                        try {
                            for (String path : timestamps.keySet()) {
                                try {
                                    Project project = (Project)NodeFactory.findOrCreate((URL)this.storage.getURL(path));
                                    long storedTimestamp = (Long)timestamps.get(path);
                                    if (storedTimestamp == project.getTimestamp()) continue;
                                    timestampsMatch = false;
                                }
                                catch (IllegalAccessException e) {
                                    logger.log(Level.INFO, "Unable to load timestamp for a project in " + URLFileSystem.getPlatformPathName((URL)this.workspace.getURL()), e);
                                }
                                catch (InstantiationException e) {
                                    logger.log(Level.INFO, "Unable to load timestamp for a project in " + URLFileSystem.getPlatformPathName((URL)this.workspace.getURL()), e);
                                }
                            }
                        }
                        finally {
                            this.storage.close();
                        }
                    } else {
                        logger.log(Level.INFO, "Unable to load project timestamps for " + (this.workspace == null ? "empty context" : URLFileSystem.getPlatformPathName((URL)this.workspace.getURL())) + ". Storage object is null.");
                    }
                }
                PerformanceLogger.get().stopTiming("DependencyCache.loadDependencyCache#timestamps", "Loaded dependency cache for " + URLFileSystem.getPlatformPathName((URL)this.workspace.getURL()), 500);
                if (timestampsMatch) break block27;
                this.dirty = true;
                break block26;
            }
            if (!this.loaded && (data = namespace.getRecord("depcache")) != null) {
                block25: {
                    boolean success = false;
                    PerformanceLogger.get().startTiming("DependencyCache.loadDependencyCache");
                    try {
                        AssemblyFactory factory = this.getStorageFactory();
                        if (this.loadFromStorage(factory.assemble(data))) {
                            success = true;
                        }
                        if (!success) break block25;
                    }
                    catch (AssemblyException e) {
                        logger.log(Level.INFO, "Unable to load dependency cache for " + URLFileSystem.getPlatformPathName((URL)this.workspace.getURL()), e);
                        break block26;
                    }
                    finally {
                        if (success) {
                            for (Project project : this.observedProjects) {
                                project.attach((Observer)this.projectObserver);
                            }
                            this.dirty = false;
                            this.loaded = true;
                            PerformanceLogger.get().stopTiming("DependencyCache.loadDependencyCache", "Loaded dependency cache for " + URLFileSystem.getPlatformPathName((URL)this.workspace.getURL()), 500);
                        } else {
                            PerformanceLogger.get().stopTiming("DependencyCache.loadDependencyCache", null);
                        }
                    }
                    for (Project project : this.observedProjects) {
                        project.attach((Observer)this.projectObserver);
                    }
                    this.dirty = false;
                    this.loaded = true;
                    PerformanceLogger.get().stopTiming("DependencyCache.loadDependencyCache", "Loaded dependency cache for " + URLFileSystem.getPlatformPathName((URL)this.workspace.getURL()), 500);
                    break block26;
                }
                PerformanceLogger.get().stopTiming("DependencyCache.loadDependencyCache", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadFromStorage(Object object) {
        DependencyCacheStorage storageObject = (DependencyCacheStorage)object;
        boolean success = false;
        if (this.storage != null) {
            this.storage.open();
            try {
                this.up.clear();
                this.down.clear();
                this.getProjectDependencyMap((HashMap)storageObject.entries[0], this.up);
                this.getProjectDependencyMap((HashMap)storageObject.entries[1], this.down);
                success = true;
            }
            catch (IllegalAccessException e) {
                logger.log(Level.INFO, "Unable to load dependency cache from storage for " + URLFileSystem.getPlatformPathName((URL)this.workspace.getURL()), e);
            }
            catch (InstantiationException e) {
                logger.log(Level.INFO, "Unable to load dependency cache from storage for " + URLFileSystem.getPlatformPathName((URL)this.workspace.getURL()), e);
            }
            finally {
                this.storage.close();
                if (!success) {
                    this.up.clear();
                    this.down.clear();
                }
            }
        } else {
            logger.log(Level.INFO, "Unable to load dependency cache from storage for " + (this.workspace == null ? "empty context" : URLFileSystem.getPlatformPathName((URL)this.workspace.getURL())) + ". Storage object is null.");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCacheToStorage(NameSpace namespace) {
        if (namespace != null) {
            try {
                PerformanceLogger.get().startTiming("DependencyCache.saveCacheToStorage");
                AssemblyFactory factory = this.getStorageFactory();
                byte[] data = factory.disassemble(this.saveToStorage());
                namespace.putRecord("depcache", data);
                HashMap<String, Long> timestamps = new HashMap<String, Long>();
                for (Project project : this.up.keySet()) {
                    timestamps.put(this.storage.getRelativePath(project.getURL()), project.getTimestamp());
                }
                for (Project project : this.down.keySet()) {
                    timestamps.put(this.storage.getRelativePath(project.getURL()), project.getTimestamp());
                }
                data = this.TIMESTAMP_MAP_FACTORY.disassemble(timestamps);
                namespace.putRecord("deptimestamps", data);
                namespace.flush();
            }
            catch (AssemblyException e) {
                logger.log(Level.INFO, "Unable to save dependency cache for " + URLFileSystem.getPlatformPathName((URL)this.workspace.getURL()), e);
            }
            finally {
                PerformanceLogger.get().stopTiming("DependencyCache.saveCacheToStorage", "Saved dependency cache for " + URLFileSystem.getPlatformPathName((URL)this.workspace.getURL()), 500);
            }
        }
    }

    private void getProjectDependencyMap(HashMap<String, Collection<String>> source, HashMap<Project, Collection<Project>> outputMap) throws IllegalAccessException, InstantiationException {
        for (String path : source.keySet()) {
            Project project = (Project)NodeFactory.findOrCreate((URL)this.storage.getURL(path));
            Collection<String> dependencies = source.get(path);
            ArrayList<Project> projectDependencies = new ArrayList<Project>();
            for (String dependencyPath : dependencies) {
                Project dependencyProject = (Project)NodeFactory.findOrCreate((URL)this.storage.getURL(dependencyPath));
                projectDependencies.add(dependencyProject);
            }
            outputMap.put(project, projectDependencies);
            this.observedProjects.add(project);
        }
    }

    private HashMap<String, Collection<String>> getStringDependencyMap(HashMap<Project, Collection<Project>> source) {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        for (Project project : source.keySet()) {
            ArrayList<String> dependencies = new ArrayList<String>();
            for (Project dependency : source.get(project)) {
                dependencies.add(this.storage.getRelativePath(dependency.getURL()));
            }
            map.put(this.storage.getRelativePath(project.getURL()), dependencies);
        }
        return map;
    }

    protected Object saveToStorage() {
        HashMap<Object, Object> up = null;
        HashMap<Object, Object> down = null;
        if (this.storage != null) {
            this.storage.open();
            try {
                up = this.getStringDependencyMap(this.up);
                down = this.getStringDependencyMap(this.down);
            }
            finally {
                this.storage.close();
            }
        }
        if (up == null) {
            up = new HashMap();
        }
        if (down == null) {
            down = new HashMap();
        }
        Object[] storageMap = new HashMap[]{up, down};
        return new DependencyCacheStorage(storageMap);
    }

    protected AssemblyFactory getStorageFactory() {
        return this.STORAGE_FACTORY;
    }

    public synchronized Collection<Project> getUpstreamProjects(Project project) throws InterruptedException {
        this.update();
        Collection<Project> upList = this.up.get(project);
        return upList == null || upList.isEmpty() ? null : Collections.unmodifiableCollection(upList);
    }

    public synchronized Collection<Project> getDownstreamProjects(Project project) throws InterruptedException {
        this.update();
        Collection<Project> downList = this.down.get(project);
        return downList == null || downList.isEmpty() ? null : Collections.unmodifiableCollection(downList);
    }

    private void dispose() {
        if (this.workspace != null) {
            this.workspace.detach((Observer)this.workspaceObserver);
        }
        for (Project project : this.observedProjects) {
            project.detach((Observer)this.projectObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean updateCache(Collection<Project> allProjects) throws InterruptedException {
        block11: {
            block10: {
                if (!this.dirty) break block10;
                PerformanceLogger.get().startTiming("DependencyCache.update");
                try {
                    for (Project project : this.observedProjects) {
                        project.detach((Observer)this.projectObserver);
                    }
                    this.observedProjects.clear();
                    this.up.clear();
                    this.down.clear();
                    this.observedProjects.addAll(allProjects);
                    LinkedList<Project> queue = new LinkedList<Project>(allProjects);
                    while (!queue.isEmpty()) {
                        Project project;
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        project = queue.removeFirst();
                        project.attach((Observer)this.projectObserver);
                        Collection<Project> upList = this.up.get(project);
                        for (Project dependency : this.getDependencies(project)) {
                            if (upList == null) {
                                upList = new ArrayList<Project>();
                                this.up.put(project, upList);
                            }
                            upList.add(dependency);
                            Collection<Project> downList = this.down.get(dependency);
                            if (downList == null) {
                                downList = new ArrayList<Project>();
                                this.down.put(dependency, downList);
                            }
                            downList.add(project);
                            if (this.observedProjects.contains(dependency)) continue;
                            this.observedProjects.add(dependency);
                            queue.add(dependency);
                        }
                    }
                    for (Project project : allProjects) {
                        if (!this.up.containsKey(project)) {
                            this.up.put(project, new ArrayList());
                        }
                        if (this.down.containsKey(project)) continue;
                        this.down.put(project, new ArrayList());
                    }
                    this.loaded = true;
                    this.dirty = false;
                }
                catch (Throwable throwable) {
                    PerformanceLogger.get().stopTiming("DependencyCache.update", "Built dependency cache for " + (this.workspace == null ? "empty context" : this.workspace.getShortLabel()));
                    throw throwable;
                }
                break block11;
            }
            return false;
        }
        PerformanceLogger.get().stopTiming("DependencyCache.update", "Built dependency cache for " + (this.workspace == null ? "empty context" : this.workspace.getShortLabel()));
        return true;
    }

    private boolean hasMissingProjects(Collection<Project> allProjects) {
        for (Project project : allProjects) {
            if (this.up.containsKey(project) || this.down.containsKey(project)) continue;
            return true;
        }
        return false;
    }

    private Collection<Project> getProjects() {
        if (this.workspace == null) {
            return Collections.emptySet();
        }
        ArrayList<Project> projects = new ArrayList<Project>();
        Iterator iterator = this.workspace.getChildren();
        while (iterator.hasNext()) {
            Object child = iterator.next();
            if (!(child instanceof Project)) continue;
            projects.add((Project)child);
        }
        return projects;
    }

    private Collection<Project> getDependencies(Project project) {
        ArrayList<Project> dependencies = new ArrayList<Project>();
        DependencyConfiguration dc = DependencyConfiguration.getInstance((Project)project);
        Iterator iterator = dc.getDependencies();
        while (iterator.hasNext()) {
            Dependable dependable = (Dependable)iterator.next();
            Element source = dependable.getSource();
            if (!(source instanceof Project)) continue;
            dependencies.add((Project)source);
        }
        return dependencies;
    }

    static {
        Node.addNodeListenerForType(Workspace.class, (NodeListener)new WorkspaceListener());
        Project.addProjectChangeListener((String)(DependencyConfiguration.DATA_KEY + "/dependencyList"), (ProjectChangeListener)dependencyListener);
    }

    private final class CollectionFactory
    extends ObjectFactory {
        private AssemblyFactory _arrayFactory;

        public CollectionFactory(AssemblyFactory objectFactory) {
            this._arrayFactory = new ObjectArrayFactory(objectFactory);
        }

        public byte getObjectCode() {
            return -30;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            Object[] object = (Object[])this._arrayFactory.assemble(input);
            return new ArrayList<Object>(Arrays.asList(object));
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            Collection collection = (Collection)object;
            Object[] array = collection.toArray();
            this._arrayFactory.disassemble((Object)array, output);
        }
    }

    protected class DependencyCacheStorageFactory
    extends ObjectFactory {
        protected DependencyCacheStorageFactory() {
        }

        public byte getObjectCode() {
            return -31;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            Object[] entries = (Object[])DependencyCache.this.MAP_ARRAY_FACTORY.assemble(input);
            return new DependencyCacheStorage(entries);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            DependencyCacheStorage storage = (DependencyCacheStorage)object;
            DependencyCache.this.MAP_ARRAY_FACTORY.disassemble((Object)storage.entries, output);
        }
    }

    protected static class TimestampFactory
    extends ObjectFactory {
        protected TimestampFactory() {
        }

        public byte getObjectCode() {
            return -29;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            return input.readLong();
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            long timestamp = (Long)object;
            output.writeLong(timestamp);
        }
    }

    private class WorkspaceObserver
    implements Observer {
        private WorkspaceObserver() {
        }

        public void update(Object observed, UpdateMessage change) {
            block2: {
                int id;
                block4: {
                    block3: {
                        id = change.getMessageID();
                        if (id != UpdateMessage.OBJECT_RELOADED) break block3;
                        DependencyCache.this.dirty = true;
                        break block2;
                    }
                    if (id != UpdateMessage.CHILD_ADDED) break block4;
                    for (Object object : change.getAddObjects()) {
                        if (!(object instanceof Project)) continue;
                        DependencyCache.this.dirty = true;
                        break block2;
                    }
                    break block2;
                }
                if (id != UpdateMessage.CHILD_REMOVED) break block2;
                for (Object object : change.getRemoveObjects()) {
                    if (!(object instanceof Project)) continue;
                    DependencyCache.this.dirty = true;
                    break;
                }
            }
        }
    }

    private class ProjectObserver
    implements Observer {
        private ProjectObserver() {
        }

        public void update(Object observed, UpdateMessage change) {
            int id = change.getMessageID();
            if (id == UpdateMessage.OBJECT_RELOADED) {
                DependencyCache.this.dirty = true;
            }
        }
    }

    protected static class DependencyCacheStorage {
        protected Object[] entries;

        public DependencyCacheStorage(Object[] entries) {
            this.entries = entries;
        }
    }

    private static class DependencyListener
    extends ProjectChangeListener {
        private DependencyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void projectPropertiesChanged(ProjectChangeEvent e) {
            Project project = e.getProject();
            HashMap<Workspace, DependencyCache> hashMap = INSTANCES;
            synchronized (hashMap) {
                for (Map.Entry<Workspace, DependencyCache> entry : INSTANCES.entrySet()) {
                    DependencyCache instance = entry.getValue();
                    if (!instance.observedProjects.contains(project)) continue;
                    instance.dirty = true;
                }
            }
        }
    }

    private static class WorkspaceListener
    extends NodeListener {
        private WorkspaceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeClosed(NodeEvent e) {
            Workspace workspace = (Workspace)e.getNode();
            HashMap<Workspace, DependencyCache> hashMap = INSTANCES;
            synchronized (hashMap) {
                DependencyCache instance = INSTANCES.remove(workspace);
                if (instance != null) {
                    instance.dispose();
                }
            }
        }
    }
}

