/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.NullableJTextField;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.xml.TwoColumnPanel;
import oracle.jdevimpl.xml.WholeNumberTextField;

public abstract class DetailPanel
extends TwoColumnPanel {
    static final String DETAIL_DATA_KEY = "DetailPanel.detail-data";
    private JEWTDialog _hostingDialog;
    private final boolean _isForDialog;
    private final ArrayList _requiredFields = new ArrayList();
    private final L _l;

    protected DetailPanel(boolean isForDialog, String addDialogHelpID) {
        super(0, true);
        this._isForDialog = isForDialog;
        if (isForDialog) {
            this._l = new L();
            this.setHelpID(addDialogHelpID);
        } else {
            this._l = null;
        }
    }

    public final void onEntry(TraversableContext tc) {
        boolean nonNullData;
        Object data = DetailPanel.findDetailData(tc);
        boolean bl = nonNullData = data != null;
        if (!this._isForDialog) {
            this.enableComponents(nonNullData);
        }
        if (this._isForDialog || nonNullData) {
            this.onEntryImpl(tc, data);
        }
    }

    protected abstract void onEntryImpl(TraversableContext var1, Object var2);

    public final void onExit(TraversableContext tc) throws TraversalException {
        Object data = DetailPanel.findDetailData(tc);
        if (data != null) {
            this.onExitImpl(tc, data);
        }
    }

    protected abstract void onExitImpl(TraversableContext var1, Object var2) throws TraversalException;

    public TDialogLauncher getTDialogLauncher(Component parent, Namespace data) {
        JEWTDialog dialog;
        TDialogLauncher launcher = new TDialogLauncher(parent, this.getDialogTitle(), (Traversable)this, data);
        this.setSizeFor(launcher);
        this._hostingDialog = dialog = launcher.initDialog();
        Component initialComponent = this.getInitialFocus();
        if (initialComponent != null) {
            dialog.setInitialFocus(initialComponent);
        }
        this.updateOKButton();
        return launcher;
    }

    protected void setSizeFor(TDialogLauncher launcher) {
        launcher.setPackDialog(true);
    }

    protected abstract String getDialogTitle();

    protected boolean shouldEnableOK() {
        for (JTextComponent textComp : this._requiredFields) {
            if (ModelUtil.hasLength((String)textComp.getText())) continue;
            return false;
        }
        return true;
    }

    protected Component getInitialFocus() {
        return null;
    }

    protected final JTextField addWatchedTextField(String labelText) {
        return this.addWatchedTextField((JPanel)((Object)this), labelText);
    }

    protected final JTextField addWatchedTextField(JPanel panel, String labelText) {
        NullableJTextField field = this.addLabeledNullableTextField(panel, labelText);
        this.watchField((JTextComponent)field);
        return field;
    }

    protected final WholeNumberTextField addWatchedWholeNumberTextField(String labelText) {
        WholeNumberTextField field = this.addLabeledWholeNumberTextField(labelText);
        this.watchField((JTextComponent)((Object)field));
        return field;
    }

    protected final JTextField addLabeledTextFieldButton(String labelText, boolean watchField, JButton button) {
        JTextField field = super.addLabeledTextFieldButton(labelText, button);
        if (watchField) {
            this.watchField(field);
        }
        return field;
    }

    protected final JTextField addRadioedTextField(JRadioButton radio, String labelText) {
        ResourceUtils.resButton((AbstractButton)radio, (String)labelText);
        JTextField field = new JTextField();
        AccessibleContext ac = field.getAccessibleContext();
        ac.setAccessibleName(radio.getText());
        ac.setAccessibleDescription(radio.getToolTipText());
        this.addRowImpl((Component)radio, 17, (Component)field);
        this.watchRadio(radio);
        this.watchField(field);
        return field;
    }

    protected final JTextField getWatchedTextField() {
        JTextField field = new JTextField();
        this.watchField(field);
        return field;
    }

    protected final JCheckBox getWatchedCheckBox(String labelText) {
        JCheckBox ch = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)ch, (String)labelText);
        this.watchCheckBox(ch);
        return ch;
    }

    protected final void updateOKButton() {
        if (this._hostingDialog != null) {
            this._hostingDialog.setOKButtonEnabled(this.shouldEnableOK());
        }
    }

    protected final void watchField(JTextComponent requiredField) {
        if (this._l != null) {
            requiredField.getDocument().addDocumentListener(this._l);
        }
        if (!this._requiredFields.contains(requiredField)) {
            this._requiredFields.add(requiredField);
        }
    }

    protected final void watchRadio(JRadioButton requiredRadio) {
        if (this._l != null) {
            requiredRadio.addActionListener(this._l);
        }
    }

    protected final void watchCheckBox(JCheckBox requiredCheckBox) {
        if (this._l != null) {
            requiredCheckBox.addActionListener(this._l);
        }
    }

    protected final void watchComboBox(JComboBox requiredComboBox) {
        if (this._l != null) {
            requiredComboBox.addActionListener(this._l);
        }
    }

    private static Object findDetailData(TraversableContext tc) {
        String detailDataKey = (String)tc.getDesignTimeObject(DETAIL_DATA_KEY);
        return detailDataKey != null ? tc.find(detailDataKey) : null;
    }

    private class L
    implements DocumentListener,
    ActionListener {
        private L() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DetailPanel.this.updateOKButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DetailPanel.this.updateOKButton();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DetailPanel.this.updateOKButton();
        }
    }
}

