/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.SwingClosure;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class DomIO {
    public Document create() throws IOException {
        return new XMLDocument();
    }

    public abstract Document load() throws IOException;

    public abstract void save(Document var1) throws IOException;

    protected CharArrayWriter getCharArrayWriter(Document document) throws IOException {
        CharArrayWriter writer = new CharArrayWriter(16384);
        PrintWriter printWriter = new PrintWriter(writer);
        XMLUtil.writeXML((XMLDocument)((XMLDocument)document), (PrintWriter)printWriter, (int)this.getIndentSize(), (boolean)this.getIndentReplaceWithTabs(), (int)this.getTabSize());
        return writer;
    }

    protected int getTabWidth() {
        return 2;
    }

    protected int getIndentSize() {
        return this.getTabWidth();
    }

    protected boolean getIndentReplaceWithTabs() {
        return false;
    }

    protected int getTabSize() {
        return 8;
    }

    protected static Document loadImpl(InputStream in, Reader reader, URL documentURL) throws IOException {
        XMLDocument document = null;
        try {
            DOMParser domParser = DomIO.newDOMParser();
            if (in != null) {
                domParser.parse(in);
            } else {
                domParser.parse(reader);
            }
            document = domParser.getDocument();
        }
        catch (SAXException e) {
            IOException ioe = documentURL != null ? new IOException(URLFileSystem.getPlatformPathName((URL)documentURL)) : new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return document;
    }

    protected static void runSwingClosure(SwingClosure closure) throws IOException {
        try {
            closure.run();
        }
        catch (ClosureException e) {
            IOException ioe = new IOException();
            ioe.initCause(e.getCause());
            throw ioe;
        }
    }

    private static DOMParser newDOMParser() {
        DOMParser domParser = new DOMParser();
        domParser.setPreserveWhitespace(true);
        domParser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
        domParser.setDebugMode(true);
        return domParser;
    }
}

