/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Window;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.AddContentCommand;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.OpenCommandData;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.layout.URL2String;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.navigator.ProjectNavigatorWindow;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.controller.MenuAwareLabelUpdater;
import oracle.jdeveloper.resource.ModelArb;

class JProjectStructureController
implements Addin,
Controller {
    public static final int ADD_TO_PROJECT_CMD_ID = AddContentCommand.ADD_TO_PROJECT_CMD_ID;
    private static int NEW_APPLICATION_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.cmd.NewApplicationCommand");
    private static int OPEN_APPLICATION_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.model.JProjectStructureController.OPEN_APPLICATION_CMD");
    private final Map _recentApplicationsCache = new HashMap();

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 35) {
            Project project = context.getProject();
            if (project != null) {
                Context projectContext = JProjectStructureController.newProjectContext(context);
                ProjectPropertiesDialog.showDialog((Context)projectContext, (Project)project);
            }
            return true;
        }
        if (cmdId == 56) {
            if (context.getNode() instanceof Project) {
                ProjectPropertiesDialog.showDialog((Context)context, (Project)((Project)context.getNode()));
                return true;
            }
        } else {
            if (cmdId == 37) {
                Project project = Ide.getDefaultProject();
                if (project != null) {
                    ProjectPropertiesDialog.showDialog((Context)context, (Project)project);
                }
                return true;
            }
            if (cmdId == OPEN_APPLICATION_CMD_ID) {
                Workspaces workspaces = Ide.getWorkspaces();
                if (workspaces != null) {
                    this.performOpenWorkspaceAction(context);
                    return true;
                }
            } else if (cmdId == ADD_TO_PROJECT_CMD_ID) {
                return false;
            }
        }
        return false;
    }

    private static Context newProjectContext(Context baseContext) {
        Context context = new Context(baseContext);
        Project project = baseContext.getProject();
        context.setNode((Node)project);
        context.setElement((Element)project);
        return context;
    }

    private void performOpenWorkspaceAction(Context context) {
        OpenCommandData data = new OpenCommandData(true);
        data.dialogTitle = ModelArb.getString((int)146);
        DefaultURLFilter urlFilter = new DefaultURLFilter(ModelArb.getString((int)142));
        urlFilter.addExtension(".jws");
        data.urlFilter = urlFilter;
        this.performOpenAction(context, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performOpenAction(Context context, OpenCommandData data) {
        IdeAction openAction = IdeAction.find((int)9);
        openAction.putValue("UserData", (Object)data);
        try {
            openAction.performAction(context);
        }
        catch (Exception ex) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ex);
        }
        finally {
            openAction.putValue("UserData", null);
        }
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 35) {
            boolean enabled = context.getProject() != null;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length > 1 && selection[0] instanceof Project) {
                enabled = false;
            }
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == 56) {
            Element[] selection = context.getSelection();
            if (context.getProject() != null && context.getNode() instanceof Project && selection != null && selection.length == 1 && selection[0] instanceof Project) {
                action.setEnabled(true);
                return true;
            }
        } else {
            if (cmdId == OPEN_APPLICATION_CMD_ID) {
                boolean enabled = Ide.getWorkspaces() != null;
                action.setEnabled(enabled);
                return true;
            }
            if (cmdId == ADD_TO_PROJECT_CMD_ID) {
                Element[] selection = context.getSelection();
                String label = null;
                boolean enableAction = false;
                if (selection == null || selection.length == 0 || selection.length > 1 || selection[0] == null) {
                    label = ModelArb.getString((int)42);
                    enableAction = false;
                } else if (selection[0] instanceof Project || context.getProject() != null) {
                    label = ModelArb.getString((int)42);
                    enableAction = true;
                }
                action.setEnabled(enableAction);
                action.putValue("Name", (Object)StringUtils.stripMnemonic((String)label));
                return true;
            }
            if (cmdId == 21) {
                View view;
                String target = null;
                View view2 = view = context != null ? context.getView() : null;
                if (view instanceof ProjectNavigatorWindow) {
                    Element[] selection = context.getSelection();
                    if (selection != null && selection.length > 0) {
                        if (selection[0] instanceof Project) {
                            target = context.getWorkspace().getShortLabel();
                            action.setEnabled(true);
                        } else if (selection[0] instanceof Workspace) {
                            target = Ide.getWorkspaces().getShortLabel();
                            action.setEnabled(true);
                        } else if (selection[0] == Ide.getWorkspaces() || selection[0].getData() == Ide.getWorkspaces()) {
                            action.setEnabled(false);
                        } else {
                            Project project = context.getProject();
                            if (project != null) {
                                target = project.getShortLabel();
                                action.setEnabled(false);
                            }
                        }
                    } else {
                        action.setEnabled(false);
                    }
                    String label = null;
                    label = target == null ? IdeArb.getString((int)222) : IdeArb.format((int)223, target);
                    action.putValue("Name", (Object)StringUtils.stripMnemonic((String)label));
                    action.putValue("MnemonicKey", (Object)StringUtils.getMnemonicKeyCode((String)label));
                    return true;
                }
            }
        }
        return false;
    }

    public void initialize() {
        IdeActions.getToolsProjectPropertiesAction().addController((Controller)this);
        IdeActions.getEditPropertiesAction().addController((Controller)this);
        IdeActions.getToolsDefaultProjectPropertiesAction().addController((Controller)this);
        AppActionLabelUpdater labelUpdater = new AppActionLabelUpdater();
        IdeAction openApplicationAction = IdeAction.find((int)OPEN_APPLICATION_CMD_ID);
        openApplicationAction.addController((Controller)this);
        openApplicationAction.setLabelUpdater((LabelUpdater)labelUpdater);
        IdeAction newApp = IdeAction.find((int)NEW_APPLICATION_CMD_ID);
        newApp.setLabelUpdater((LabelUpdater)labelUpdater);
        IdeActions.getFileRemoveFromIDEAction().addController((Controller)this);
        String label = ModelArb.format((int)43, (Object)"");
        IdeAction addToProjectAction = IdeAction.get((int)ADD_TO_PROJECT_CMD_ID, (String)AddinManager.getAddinManager().getCommand(ADD_TO_PROJECT_CMD_ID, null), (String)label);
        addToProjectAction.putValue("MnemonicKey", (Object)StringUtils.getMnemonicKeyCode((String)label));
        addToProjectAction.addController((Controller)this);
        this.setupOpenRecentMenu();
    }

    private void setupOpenRecentMenu() {
        String openRecentKey = "APPLICATION_REOPEN_MENU";
        JMenu menu = MenuManager.getJMenu((String)"APPLICATION_REOPEN_MENU");
        if (menu == null) {
            menu = new JMenu();
            MenuManager.putJMenu((String)"APPLICATION_REOPEN_MENU", (JMenu)menu);
        }
        final JMenu appReopenMenu = menu;
        appReopenMenu.add(this.getEmptyItem());
        appReopenMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                this.callPoppingUp();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            private void callPoppingUp() {
                FileOpenHistory fileOpenHistory = FileOpenHistory.getInstance();
                String[] workspaces = fileOpenHistory.getWorkspaceHistory();
                appReopenMenu.removeAll();
                if (workspaces.length == 0) {
                    appReopenMenu.add(JProjectStructureController.this.getEmptyItem());
                    return;
                }
                for (String ws : workspaces) {
                    JMenuItem menuItem = JProjectStructureController.this.getMenuItem(fileOpenHistory, ws);
                    if (menuItem == null) continue;
                    appReopenMenu.add(menuItem);
                }
            }
        });
    }

    private JMenuItem getEmptyItem() {
        JMenuItem emptyItem = new JMenuItem(ModelArb.getString((int)151));
        emptyItem.setEnabled(false);
        return emptyItem;
    }

    private JMenuItem getMenuItem(FileOpenHistory fileOpenHistory, String urlString) {
        JMenuItem menuItem = (JMenuItem)this._recentApplicationsCache.get(urlString);
        if (menuItem != null) {
            try {
                URL url = URL2String.toURL((String)urlString);
                if (!URLFileSystem.exists((URL)url)) {
                    this._recentApplicationsCache.remove(urlString);
                    return null;
                }
            }
            catch (Exception url) {
                // empty catch block
            }
            return menuItem;
        }
        try {
            URL url = URL2String.toURL((String)urlString);
            if (url == null || !URLFileSystem.exists((URL)url)) {
                return null;
            }
            IdeAction action = FileOpenHistory.getNewReopenAction((URL)url);
            menuItem = Ide.getMenubar().createMenuItem((ToggleAction)action);
            this._recentApplicationsCache.put(urlString, menuItem);
            return menuItem;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return null;
        }
    }

    private static class AppActionLabelUpdater
    extends MenuAwareLabelUpdater {
        AppActionLabelUpdater() {
            super("APPLICATION_MENU");
        }

        @Override
        protected String disabledMenuSpecificLabel(IdeAction action, String originalLabel) {
            return this.enabledMenuSpecificLabel(action, originalLabel);
        }

        @Override
        protected String enabledMenuSpecificLabel(IdeAction action, String originalLabel) {
            if (action.getCommandId() == OPEN_APPLICATION_CMD_ID) {
                return ModelArb.getString((int)147);
            }
            if (action.getCommandId() == NEW_APPLICATION_CMD_ID) {
                return ModelArb.getString((int)150);
            }
            return originalLabel;
        }
    }
}

