/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import java.sql.Connection;
import oracle.express.idl.util.ClobStream;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.OlapiStreamable;
import oracle.express.idl.util.OlapiTracer;
import oracle.express.idl.util.WstringHelper;
import oracle.express.idl.util.XMLWriter;
import oracle.sql.CLOB;

public class ClobStreamHelper {
    private ClobStreamHelper() {
    }

    public static String SQL2Java(InterfaceStub interfaceStub, CLOB cLOB) {
        OlapiTracer.enter("ClobStreamHelper.SQL2Java");
        ClobStream clobStream = new ClobStream(cLOB);
        String string = clobStream.readAll();
        clobStream.close();
        OlapiTracer.leave("ClobStreamHelper.SQL2Java");
        return string;
    }

    public static CLOB Java2SQL(InterfaceStub interfaceStub, String string) {
        OlapiTracer.enter("ClobStreamHelper.Java2SQL");
        ClobStream clobStream = new ClobStream((Connection)interfaceStub.getOlapiConnection());
        clobStream.writeAll(string);
        CLOB cLOB = clobStream.getCLOB();
        OlapiTracer.leave("ClobStreamHelper.Java2SQL");
        return cLOB;
    }

    public static CLOB Java2SQL(InterfaceStub interfaceStub, XMLWriter xMLWriter) {
        CLOB cLOB;
        OlapiTracer.enter("ClobStreamHelper.Java2SQL");
        ClobStream clobStream = new ClobStream((Connection)interfaceStub.getOlapiConnection());
        for (XMLWriter xMLWriter2 = xMLWriter; null != xMLWriter2; xMLWriter2 = xMLWriter2.getNextXMLWriter()) {
            cLOB = xMLWriter2.getSegmentedStrings();
            for (int i = 0; i < ((CLOB)cLOB).length; ++i) {
                clobStream.write(cLOB[i].toString());
            }
        }
        clobStream.flush();
        cLOB = clobStream.getCLOB();
        OlapiTracer.leave("ClobStreamHelper.Java2SQL");
        return cLOB;
    }

    public static String SQL2Java(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable) {
        return WstringHelper.SQL2Java(interfaceStub, olapiStreamable);
    }

    public static void Java2SQL(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable, XMLWriter xMLWriter) {
        WstringHelper.Java2SQL(interfaceStub, olapiStreamable, xMLWriter);
    }
}

