/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.util;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import oracle.json.util.ByteArray;
import oracle.json.util.ComponentTime;

public class ScalarValue
implements Comparable {
    private static final ScalarValue NULL_VALUE = new ScalarValue();
    private static final ScalarValue FALSE_VALUE = new ScalarValue(false);
    private static final ScalarValue TRUE_VALUE = new ScalarValue(true);
    protected final Object val;
    protected final int subType;
    public static final int NULL = 0;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int LONG = 3;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 5;
    public static final int DECIMAL = 6;
    public static final int DATE = 7;
    public static final int TIMESTAMP = 8;
    public static final int STRING = 9;
    public static final int BINARY = 10;
    public static final int NUMBER = 11;
    public static final int DATETIME = 12;

    protected ScalarValue(ScalarValue scalarValue) {
        this.val = scalarValue.val;
        this.subType = scalarValue.subType;
    }

    protected ScalarValue() {
        this.val = null;
        this.subType = 0;
    }

    public ScalarValue(Boolean bl) {
        this((boolean)bl);
    }

    public ScalarValue(boolean bl) {
        this.val = bl ? Boolean.TRUE : Boolean.FALSE;
        this.subType = 1;
    }

    public ScalarValue(Integer n) {
        this.val = n;
        this.subType = 2;
    }

    public ScalarValue(int n) {
        this(new Integer(n));
    }

    public ScalarValue(Long l) {
        this.val = l;
        this.subType = 3;
    }

    public ScalarValue(long l) {
        this(new Long(l));
    }

    public ScalarValue(Float f) {
        this.val = f;
        this.subType = 4;
    }

    public ScalarValue(float f) {
        this(new Float(f));
    }

    public ScalarValue(Double d) {
        this.val = d;
        this.subType = 5;
    }

    public ScalarValue(double d) {
        this(new Double(d));
    }

    public ScalarValue(String string) {
        this.val = string;
        this.subType = 9;
    }

    private ScalarValue(BigDecimal bigDecimal, int n) {
        this.val = bigDecimal;
        this.subType = n;
    }

    public ScalarValue(BigDecimal bigDecimal) {
        this(bigDecimal, 6);
    }

    private ScalarValue(Instant instant, int n) {
        this.val = instant;
        this.subType = n;
    }

    public ScalarValue(Date date) {
        this(ComponentTime.stringToInstant(ComponentTime.dateToString(date)), 7);
    }

    public ScalarValue(Instant instant) {
        this(instant, 8);
    }

    public ScalarValue(OffsetDateTime offsetDateTime) {
        this(offsetDateTime.toInstant());
    }

    public ScalarValue(byte[] byArray) {
        this.val = byArray;
        this.subType = 10;
    }

    public boolean isNull() {
        return this.val == null;
    }

    public boolean isBoolean() {
        if (this.val == null) {
            return false;
        }
        return this.val instanceof Boolean;
    }

    public boolean isString() {
        if (this.val == null) {
            return false;
        }
        return this.val instanceof String;
    }

    public boolean isNumber() {
        if (this.val == null) {
            return false;
        }
        if (this.val instanceof BigDecimal) {
            return true;
        }
        if (this.val instanceof Double) {
            return true;
        }
        if (this.val instanceof Float) {
            return true;
        }
        if (this.val instanceof Integer) {
            return true;
        }
        return this.val instanceof Long;
    }

    public boolean isDateTime() {
        if (this.val == null) {
            return false;
        }
        return this.val instanceof Instant;
    }

    public boolean isBinary() {
        if (this.val == null) {
            return false;
        }
        return this.val instanceof byte[];
    }

    public Boolean booleanValue() {
        if (!this.isBoolean()) {
            return null;
        }
        return (Boolean)this.val;
    }

    public String stringValue() {
        if (!this.isString()) {
            return null;
        }
        return (String)this.val;
    }

    public BigDecimal numberValue() {
        if (!this.isNumber()) {
            return null;
        }
        if (this.val instanceof Double) {
            return BigDecimal.valueOf((Double)this.val);
        }
        if (this.val instanceof Float) {
            return BigDecimal.valueOf(((Float)this.val).floatValue());
        }
        if (this.val instanceof Integer) {
            return BigDecimal.valueOf(((Integer)this.val).intValue());
        }
        if (this.val instanceof Long) {
            return BigDecimal.valueOf((Long)this.val);
        }
        return (BigDecimal)this.val;
    }

    public LocalDateTime dateTimeValue() {
        if (!this.isDateTime()) {
            return null;
        }
        return ((Instant)this.val).atOffset(ZoneOffset.UTC).toLocalDateTime();
    }

    protected Instant timestampValue() {
        if (!this.isDateTime()) {
            return null;
        }
        return (Instant)this.val;
    }

    public byte[] binaryValue() {
        if (!this.isBinary()) {
            return null;
        }
        return (byte[])this.val;
    }

    public boolean isDecimalNumber() {
        return this.subType == 6;
    }

    public boolean isDouble() {
        return this.subType == 5;
    }

    public boolean isFloat() {
        return this.subType == 4;
    }

    public boolean isInteger() {
        return this.subType == 2;
    }

    public boolean isLong() {
        return this.subType == 3;
    }

    public boolean isDate() {
        return this.subType == 7;
    }

    public String toString() {
        if (this.val == null) {
            return "null";
        }
        if (this.val instanceof String) {
            return (String)this.val;
        }
        if (this.val instanceof BigDecimal) {
            return ((BigDecimal)this.val).toString();
        }
        if (this.val instanceof Instant) {
            return ComponentTime.instantToString((Instant)this.val, false, this.subType == 7);
        }
        if (this.val instanceof byte[]) {
            return ByteArray.rawToHex((byte[])this.val);
        }
        if (this.val instanceof Boolean) {
            return (Boolean)this.val != false ? "true" : "false";
        }
        return null;
    }

    public int hashCode() {
        if (this.val == null) {
            return 0;
        }
        return this.val.hashCode();
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        ScalarValue scalarValue;
        if (object instanceof ScalarValue) {
            scalarValue = (ScalarValue)object;
        } else {
            scalarValue = ScalarValue.from(object);
            if (scalarValue == null) {
                return 1;
            }
        }
        if (this.val == scalarValue.val) {
            return 0;
        }
        if (this.val == null) {
            return -1;
        }
        if (scalarValue.val == null) {
            return 1;
        }
        if (this.val == Boolean.FALSE) {
            return -1;
        }
        if (scalarValue.val == Boolean.FALSE) {
            return 1;
        }
        if (this.val == Boolean.TRUE) {
            return -1;
        }
        if (scalarValue.val == Boolean.TRUE) {
            return 1;
        }
        if (this.val instanceof BigDecimal) {
            if (!(scalarValue.val instanceof BigDecimal)) {
                return -1;
            }
            return ((BigDecimal)this.val).compareTo((BigDecimal)scalarValue.val);
        }
        if (scalarValue.val instanceof BigDecimal) {
            return 1;
        }
        if (this.val instanceof Instant) {
            if (!(scalarValue.val instanceof Instant)) {
                return -1;
            }
            return ((Instant)this.val).compareTo((Instant)scalarValue.val);
        }
        if (scalarValue.val instanceof Instant) {
            return 1;
        }
        if (this.val instanceof String) {
            if (!(scalarValue.val instanceof String)) {
                return -1;
            }
            return ((String)this.val).compareTo((String)scalarValue.val);
        }
        if (scalarValue.val instanceof String) {
            return 1;
        }
        return ByteArray.compareBytes((byte[])this.val, (byte[])scalarValue.val);
    }

    public static ScalarValue dateFrom(long l) {
        return ScalarValue.dateFrom(ComponentTime.millisToString(l));
    }

    public static ScalarValue dateFrom(String string) {
        return new ScalarValue(ComponentTime.stringToInstant(string), 7);
    }

    public static ScalarValue dateFrom(ScalarValue scalarValue) {
        if (scalarValue == null) {
            return scalarValue;
        }
        if (scalarValue.isDate()) {
            return scalarValue;
        }
        if (scalarValue.isDateTime()) {
            return new ScalarValue(scalarValue.timestampValue(), 7);
        }
        if (scalarValue.isString()) {
            return ScalarValue.dateFrom(scalarValue.stringValue());
        }
        if (scalarValue.isNumber()) {
            return ScalarValue.dateFrom(scalarValue.numberValue().longValue());
        }
        return null;
    }

    public static ScalarValue timestampFrom(long l) {
        return ScalarValue.timestampFrom(ComponentTime.millisToString(l));
    }

    public static ScalarValue timestampFrom(String string) {
        return new ScalarValue(ComponentTime.stringToInstant(string));
    }

    public static ScalarValue timestampFrom(ScalarValue scalarValue) {
        if (scalarValue == null) {
            return scalarValue;
        }
        if (scalarValue.isDate()) {
            return new ScalarValue(scalarValue.timestampValue(), 8);
        }
        if (scalarValue.isDateTime()) {
            return scalarValue;
        }
        if (scalarValue.isString()) {
            return ScalarValue.timestampFrom(scalarValue.stringValue());
        }
        if (scalarValue.isNumber()) {
            return ScalarValue.timestampFrom(scalarValue.numberValue().longValue());
        }
        return null;
    }

    public static ScalarValue stringFrom(BigDecimal bigDecimal) {
        return new ScalarValue(bigDecimal.toString());
    }

    public static ScalarValue stringFrom(ScalarValue scalarValue) {
        if (scalarValue == null) {
            return scalarValue;
        }
        if (scalarValue.isString()) {
            return scalarValue;
        }
        return new ScalarValue(scalarValue.toString());
    }

    public static ScalarValue numberFrom(BigDecimal bigDecimal) {
        return new ScalarValue(bigDecimal, 11);
    }

    public static ScalarValue decimalFrom(BigDecimal bigDecimal) {
        return new ScalarValue(bigDecimal);
    }

    public static ScalarValue numberFrom(String string) {
        return ScalarValue.numberFrom(new BigDecimal(string));
    }

    public static ScalarValue decimalFrom(String string) {
        return ScalarValue.decimalFrom(new BigDecimal(string));
    }

    public static ScalarValue doubleFrom(String string) {
        return ScalarValue.doubleFrom(new BigDecimal(string));
    }

    public static ScalarValue doubleFrom(BigDecimal bigDecimal) {
        return new ScalarValue(bigDecimal, 5);
    }

    public static ScalarValue doubleFrom(ScalarValue scalarValue) {
        if (scalarValue == null) {
            return scalarValue;
        }
        if (scalarValue.isDouble()) {
            return scalarValue;
        }
        if (scalarValue.isNumber()) {
            return ScalarValue.doubleFrom(scalarValue.numberValue());
        }
        if (scalarValue.isString()) {
            return ScalarValue.doubleFrom(scalarValue.stringValue());
        }
        return null;
    }

    public static ScalarValue decimalFrom(ScalarValue scalarValue) {
        BigDecimal bigDecimal = null;
        if (scalarValue == null) {
            return scalarValue;
        }
        if (scalarValue.isDecimalNumber()) {
            return scalarValue;
        }
        if (scalarValue.isNumber()) {
            bigDecimal = scalarValue.numberValue();
        } else if (scalarValue.isString()) {
            bigDecimal = new BigDecimal(scalarValue.stringValue());
        } else if (scalarValue.isDateTime()) {
            bigDecimal = new BigDecimal(((Instant)scalarValue.val).toEpochMilli());
        }
        if (bigDecimal != null) {
            return new ScalarValue(bigDecimal);
        }
        return null;
    }

    public static ScalarValue numberFrom(ScalarValue scalarValue) {
        BigDecimal bigDecimal = null;
        if (scalarValue == null) {
            return scalarValue;
        }
        if (scalarValue.subType == 11) {
            return scalarValue;
        }
        if (scalarValue.isNumber()) {
            bigDecimal = scalarValue.numberValue();
        } else if (scalarValue.isString()) {
            bigDecimal = new BigDecimal(scalarValue.stringValue());
        } else if (scalarValue.isDateTime()) {
            bigDecimal = new BigDecimal(((Instant)scalarValue.val).toEpochMilli());
        }
        if (bigDecimal != null) {
            return new ScalarValue(bigDecimal, 11);
        }
        return null;
    }

    public static ScalarValue binaryFrom(ScalarValue scalarValue) {
        if (scalarValue == null) {
            return scalarValue;
        }
        if (scalarValue.isString()) {
            return new ScalarValue(ByteArray.hexToRaw(scalarValue.stringValue()));
        }
        return null;
    }

    public static ScalarValue simplify(ScalarValue scalarValue) {
        if (scalarValue == null) {
            return scalarValue;
        }
        if (scalarValue.isNumber() || scalarValue.isString() || scalarValue.isBoolean()) {
            return scalarValue;
        }
        return ScalarValue.stringFrom(scalarValue);
    }

    public static ScalarValue from(Object object) {
        if (object == null) {
            return NULL_VALUE;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? TRUE_VALUE : FALSE_VALUE;
        }
        if (object instanceof String) {
            return new ScalarValue((String)object);
        }
        if (object instanceof BigDecimal) {
            return new ScalarValue((BigDecimal)object);
        }
        if (object instanceof Instant) {
            return new ScalarValue((Instant)object);
        }
        if (object instanceof Date) {
            return new ScalarValue((Date)object);
        }
        if (object instanceof Integer) {
            return new ScalarValue((Integer)object);
        }
        if (object instanceof Long) {
            return new ScalarValue((Long)object);
        }
        if (object instanceof Float) {
            return new ScalarValue((Float)object);
        }
        if (object instanceof Double) {
            return new ScalarValue((Double)object);
        }
        if (object instanceof byte[]) {
            return new ScalarValue((byte[])object);
        }
        return null;
    }
}

