/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

public class FastMessageFormat {
    private final char[] _formatText;

    public static String formatMessage(String formatString, Object[] source) {
        return FastMessageFormat.formatMessage(formatString.toCharArray(), source);
    }

    public static String formatMessage(char[] formatChars, Object[] source) {
        String[] sourceStrings;
        if (source instanceof String[]) {
            sourceStrings = (String[])source;
        } else {
            int sourceCount = source.length;
            sourceStrings = new String[sourceCount];
            for (int i = 0; i < sourceCount; ++i) {
                Object currSource = source[i];
                sourceStrings[i] = currSource != null ? currSource.toString() : null;
            }
        }
        return FastMessageFormat.formatMessage(formatChars, sourceStrings);
    }

    public static String formatMessage(String formatString, String source) {
        return FastMessageFormat.formatMessage(formatString.toCharArray(), new String[]{source});
    }

    public static String formatMessage(String formatString, String source1, String source2) {
        return FastMessageFormat.formatMessage(formatString.toCharArray(), new String[]{source1, source2});
    }

    public static String formatMessage(String formatString, String source1, String source2, String source3) {
        return FastMessageFormat.formatMessage(formatString.toCharArray(), new String[]{source1, source2, source3});
    }

    public static String formatMessage(char[] formatChars, String[] source) {
        int formatLength = formatChars.length;
        int length = 0;
        int sourceCount = source.length;
        for (int i = 0; i < sourceCount; ++i) {
            String sourceString = source[i];
            if (sourceString == null) continue;
            length += sourceString.length();
        }
        StringBuffer buffer = new StringBuffer(length + formatLength);
        int lastStart = 0;
        boolean inQuote = false;
        for (int i = 0; i < formatLength; ++i) {
            String sourceString;
            char patternChar;
            int j;
            char ch = formatChars[i];
            if (inQuote) {
                if (ch != '\'') continue;
                buffer.append(formatChars, lastStart, i - lastStart);
                lastStart = ++i;
                inQuote = false;
                continue;
            }
            if (ch == '\'') {
                buffer.append(formatChars, lastStart, i - lastStart);
                lastStart = ++i;
                if (i < formatLength && formatChars[i] == '\'') continue;
                inQuote = true;
                continue;
            }
            if (ch != '{') continue;
            buffer.append(formatChars, lastStart, i - lastStart);
            int sourceIndex = 0;
            for (j = i + 1; j < formatLength && (patternChar = formatChars[j]) != '}'; ++j) {
                if (patternChar < '0' || patternChar > '9') {
                    throw new IllegalArgumentException("FastMessageFormat only supports numeric arguments");
                }
                sourceIndex = sourceIndex * 10 + (patternChar - 48);
            }
            if (j == formatLength) {
                throw new IllegalArgumentException("End of pattern not found");
            }
            if (j == i + 1) {
                throw new IllegalArgumentException("FastMessageFormat: empty argument - {} - found");
            }
            if (sourceIndex < sourceCount && (sourceString = source[sourceIndex]) != null) {
                buffer.append((Object)sourceString);
            }
            i = j;
            lastStart = i + 1;
        }
        buffer.append(formatChars, lastStart, formatLength - lastStart);
        return new String(buffer);
    }

    public FastMessageFormat(String formatString) {
        if (formatString == null) {
            throw new NullPointerException();
        }
        this._formatText = formatString.toCharArray();
    }

    public final String format(Object[] source) {
        return FastMessageFormat.formatMessage(this._formatText, source);
    }

    public final String format(Object source) {
        return this.format(new Object[]{source});
    }

    public final String format(Object source1, Object source2) {
        return this.format(new Object[]{source1, source2});
    }
}

