/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.convert;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.grammar.util.SimpleTypeConverter;
import oracle.bali.xml.metadata.XmlMetadataConstants;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.convert.ConvertPlugin;
import oracle.bali.xml.model.convert.IllegalConvertPluginException;

public class ConvertPluginFactory {
    private static final Logger _LOGGER = Logger.getLogger("oracle.bali.xml.model.convert");

    public static ConvertPlugin createConvertPlugin(XmlContext context, StructuredMetadataBean plugin) throws IllegalConvertPluginException {
        if (plugin == null || !XmlMetadataConstants.CONVERT_PLUGIN.equals((Object)plugin.getName())) {
            throw new IllegalConvertPluginException("Unexpected StructuredMetadataBean passed to createConvertPlugin: " + plugin);
        }
        String classAttr = plugin.getProperty(XmlMetadataConstants.CLASS_ATTR);
        if (classAttr == null) {
            classAttr = "oracle.bali.xml.gui.swing.action.ConvertMapPlugin";
        }
        try {
            SimpleTypeConverter converter = JavaTypeManager.getInstance().getSimpleTypeConverter(XmlMetadataConstants.TYPE_JAVACLASSINSTANCE);
            ConvertPlugin convertPlugin = (ConvertPlugin)converter.convertToJavaType(classAttr, null);
            convertPlugin.init(context, plugin);
            return convertPlugin;
        }
        catch (Exception e) {
            throw new IllegalConvertPluginException("Unexpected class name passed to createConvertPlugins: " + classAttr);
        }
    }

    public static List<ConvertPlugin> createConvertPlugins(XmlContext context, List<StructuredMetadataBean> convertPlugins) {
        ArrayList<ConvertPlugin> resultList = new ArrayList<ConvertPlugin>();
        for (StructuredMetadataBean plugins : convertPlugins) {
            if (convertPlugins == null || !XmlMetadataConstants.CONVERT_PLUGINS.equals((Object)plugins.getName())) continue;
            List pluginList = plugins.getChildren();
            for (StructuredMetadataBean plugin : pluginList) {
                try {
                    ConvertPlugin result = ConvertPluginFactory.createConvertPlugin(context, plugin);
                    resultList.add(result);
                }
                catch (IllegalConvertPluginException e) {
                    _LOGGER.log(Level.WARNING, "Invalid convert plugin encountered (and ignored)", e);
                }
                catch (RuntimeException rE) {
                    _LOGGER.log(Level.SEVERE, "Unexpected exception encountered while processing convert plugins", rE);
                }
            }
        }
        return resultList;
    }

    private ConvertPluginFactory() {
    }
}

