/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.Map;
import java.util.Observer;
import java.util.Set;
import java.util.WeakHashMap;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.PropertyModelUpdateEvent;
import oracle.bali.inspector.multi.MultiObjectModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.bali.xml.gui.base.inspector.PropertyModelUtils;
import oracle.bali.xml.gui.base.inspector.XmlPropertyModel;
import oracle.bali.xml.gui.base.inspector.XmlPropertyModelEvent;
import oracle.bali.xml.gui.base.inspector.XmlPropertyModelListener;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.javatools.util.Pair;

public abstract class XmlMultiObjectModel
extends MultiObjectModel
implements XmlPropertyModelListener {
    private final PropertyModel _primaryPropertyModel;
    private final Map<Observer, Observer> _observers = new WeakHashMap<Observer, Observer>(2);

    public XmlMultiObjectModel(PropertyModel primaryPropertyModel) {
        if (primaryPropertyModel == null) {
            throw new IllegalStateException("Primary PropertyModel cannot be null");
        }
        this._primaryPropertyModel = primaryPropertyModel;
    }

    public void dispose() {
        this.updateListenerState(this.getSelectionModel(), false);
        super.dispose();
        this._observers.clear();
    }

    public void setSelectionModel(SelectionModel newSelectionModel) {
        super.setSelectionModel(newSelectionModel);
        this.updateListenerState(newSelectionModel, true);
    }

    @Override
    public void propertyModelChanged(XmlPropertyModelEvent event) {
        this.firePropertyModelUpdate(new PropertyModelUpdateEvent(new Object[]{event.getCause()}));
    }

    public void addObserver(Observer o) {
        this._observers.put(o, o);
    }

    public void removeObserver(Observer o) {
        this._observers.remove(o);
    }

    protected void setData(Object columnID, int rowIndex, Object newValue) throws Throwable {
        Pair<PropertyModel, Integer> p = this._getTargetInfo(rowIndex);
        if (p != null) {
            PropertyModel tm = (PropertyModel)p.getFirst();
            rowIndex = (Integer)p.getSecond();
            int columnIndex = this.findColumnIndex(tm, columnID);
            if (columnIndex != -1) {
                if (this._primaryPropertyModel == tm) {
                    this._primaryPropertyModel.setValueAt(newValue, rowIndex, columnIndex);
                } else {
                    this.setSecondaryModelValue(tm, newValue, rowIndex, columnIndex);
                }
            }
        }
        this.notifyObservers();
    }

    public final void notifyObservers() {
        Set<Observer> observers = this._observers.keySet();
        for (Observer k : observers) {
            Observer o = this._observers.get(k);
            if (o == null) continue;
            o.update(null, this);
        }
    }

    private void updateListenerState(SelectionModel selectionModel, boolean add) {
        if (selectionModel != null) {
            for (int i = 0; i < selectionModel.getSelectedItemCount(); ++i) {
                PropertyModel pm = (PropertyModel)selectionModel.getSelectedItem(i);
                if (!(pm instanceof XmlPropertyModel)) continue;
                XmlPropertyModel tpm = (XmlPropertyModel)pm;
                if (add) {
                    tpm.addXmlPropertyChangeListener(this);
                    continue;
                }
                tpm.removeXmlPropertyChangeListener(this);
            }
        }
    }

    private int findColumnIndex(PropertyModel tm, Object columnID) {
        Object[] columnMap = tm.getColumnMapping();
        int currNumColumns = columnMap.length;
        for (int k = 0; k < currNumColumns; ++k) {
            if (!columnID.equals(columnMap[k])) continue;
            return k;
        }
        return -1;
    }

    public String getTargetDisplayName() {
        return this.getPrimaryPropertyModel().getTargetDisplayName();
    }

    public PropertyModel getPrimaryPropertyModel() {
        return this._primaryPropertyModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useUnion() {
        if (this._primaryPropertyModel.getRowCount() == 0) {
            return super.useUnion();
        }
        XmlContext context = PropertyModelUtils.getXmlContext(this._primaryPropertyModel, 0);
        if (context != null) {
            XmlModel model = context.getModel();
            model.acquireReadLock();
            try {
                if (model.getSelection().getSelectedNodesArray().length > 1) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                model.releaseReadLock();
            }
        }
        return true;
    }

    public abstract void setSecondaryModelValue(PropertyModel var1, Object var2, int var3, int var4);

    private Pair<PropertyModel, Integer> _getTargetInfo(int rowIndex) {
        Pair p = new Pair();
        Object id = this.getValueAt(rowIndex, this.getColumnIndex(PropertyModel.COLUMN_ID));
        if (id != null) {
            SelectionModel sm = this.getSelectionModel();
            for (int i = 0; i < sm.getSelectedItemCount(); ++i) {
                PropertyModel pm = (PropertyModel)sm.getSelectedItem(i);
                int index = pm.getPropertyIndex(id);
                if (index < 0 || index >= pm.getRowCount()) continue;
                p.setFirst((Object)pm);
                p.setSecond((Object)index);
                return p;
            }
        }
        return null;
    }
}

