/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.binding;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.util.ELSupportingDatabindingHandler;
import oracle.bali.xml.util.XmlModelUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ELDatabindingHandler
implements ELSupportingDatabindingHandler {
    private static final char _CHAR = '$';

    @Override
    public void setDatabound(XmlContext context, XmlKey key, Node node, Node owner, boolean dataBound) {
        Object value;
        if (owner.getNodeType() != 1) {
            throw new IllegalArgumentException("owner needs to be an element");
        }
        boolean isAttribute = key.getNodeType() == 2;
        boolean isElement = key.getNodeType() == 1;
        Element ownerElement = (Element)owner;
        XmlMetadataResolver resolver = context.getModel().getXmlMetadataResolver();
        char hash = this.getExpressionChar();
        Object object = value = node != null ? this._getValue(node) : null;
        if (dataBound) {
            SimpleType type;
            SimpleType beforeType = resolver.getModifiedSimpleType(node, key, value);
            boolean isString = false;
            try {
                Class c = JavaTypeManager.getInstance().getJavaClass(beforeType);
                isString = c == null ? false : String.class.isAssignableFrom(c);
            }
            catch (GrammarException c) {
                // empty catch block
            }
            if (value == null || "".equals(value)) {
                value = this._getDefaultValue(context, key);
                if (isString && value == null) {
                    value = "";
                }
            }
            if ((type = resolver.getModifiedSimpleType(node, key, value = isString || value != null ? hash + "{'" + (String)value + "'}" : hash + "{null}")) != null) {
                try {
                    type.validateValue((String)value);
                }
                catch (Exception e) {
                    String text = "Could not databind node {0} to value {1}.";
                    MessageFormat format = new MessageFormat(text);
                    Object[] args = new Object[]{key.getLocalName(), value};
                    throw new IllegalArgumentException(format.format(args));
                }
            }
            if (isAttribute) {
                DomUtils.setAttribute((Element)ownerElement, (String)key.getNamespace(), (String)key.getLocalName(), (String)value);
            } else if (isElement) {
                if (node != null) {
                    DomUtils.setTextNodeValue((Node)node, (String)value);
                } else {
                    Element e = ownerElement.getOwnerDocument().createElementNS(key.getTargetNamespace(), key.getLocalName());
                    DomUtils.setTextNodeValue((Node)e, (String)value);
                    DomPosition p = DomPositionFactory.inside((Node)ownerElement);
                    if (!DomUtils.isInDocumentHierarchy((Node)ownerElement)) {
                        TreeTraversal ownerTraversal = XmlModelUtils.getPropertyEditorOwnerTraversal(owner);
                        XmlKey derivedXmlKey = XmlModelUtils.getOwnerTraversalDerivedXmlKey(ownerTraversal, ownerElement, context.getActiveView());
                        DomPosition pos = context.getModel().findValidInsertionPosition(key, e, DomPositionFactory.inside((Node)owner), derivedXmlKey);
                        DomUtils.insertNodeAtPosition((DomPosition)pos, (Node)e);
                    } else {
                        try {
                            context.getModel().insertNode(e, p, false);
                        }
                        catch (XmlCommitException xce) {
                            context.getLogger().log(Level.SEVERE, "couldn't insert simple type element", xce);
                        }
                    }
                }
            }
        } else {
            value = ELDatabindingHandler._removeSubstring((String)value, hash + "{");
            value = ELDatabindingHandler._removeSubstring((String)value, "}");
            if (((String)(value = ((String)value).trim())).indexOf(39) == 0 && ((String)value).lastIndexOf(39) == ((String)value).length() - 1) {
                value = ((String)value).substring(1, ((String)value).length() - 1);
                ((String)value).trim();
            } else {
                value = "";
            }
            if ("".equals(value) || "'null'".equals(value)) {
                if (isAttribute) {
                    ownerElement.removeAttributeNS(key.getNamespace(), key.getLocalName());
                } else if (isElement) {
                    ownerElement.removeChild(node);
                }
            } else {
                SimpleType type = resolver.getModifiedSimpleType(node, key, value);
                try {
                    type.validateValue((String)value);
                }
                catch (Exception e) {
                    String text = "Could not remove databinding on node {0} to value {1}.";
                    MessageFormat format = new MessageFormat(text);
                    Object[] args = new Object[]{key.getLocalName(), value};
                    throw new IllegalArgumentException(format.format(args));
                }
                if (isAttribute) {
                    DomUtils.setAttribute((Element)ownerElement, (String)key.getNamespace(), (String)key.getLocalName(), (String)value);
                } else if (isElement) {
                    if (node != null) {
                        DomUtils.setTextNodeValue((Node)node, (String)value);
                    } else {
                        Element e = ownerElement.getOwnerDocument().createElementNS(key.getTargetNamespace(), key.getLocalName());
                        DomUtils.setTextNodeValue((Node)e, (String)value);
                        DomPosition p = DomPositionFactory.inside((Node)ownerElement);
                        try {
                            context.getModel().insertNode(e, p, false);
                        }
                        catch (XmlCommitException xce) {
                            context.getLogger().log(Level.SEVERE, "couldn't insert simple type element", xce);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean isDatabound(XmlContext context, XmlKey key, Node node, Node owner, Object value) {
        XmlMetadataResolver resolver = context.getModel().getXmlMetadataResolver();
        if (!(value instanceof String)) {
            return false;
        }
        String identifier = this.getExpressionChar() + "{";
        return value.toString().indexOf(identifier) != -1;
    }

    @Override
    public String getDataboundExpression(XmlContext context, XmlKey key, Node node, Node owner, List list) {
        String identifier = this.getExpressionChar() + "{";
        StringBuffer expression = new StringBuffer();
        expression.append(identifier);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            expression.append(i.next());
            expression.append('.');
        }
        expression.setCharAt(expression.length() - 1, '}');
        return expression.toString();
    }

    @Override
    public List parseExpression(XmlContext context, XmlKey key, Node node, Node owner, Object value) {
        int c;
        String v = value.toString();
        if (v.indexOf(c = this.getExpressionChar()) == 0) {
            v = v.substring(1);
        }
        if (v.indexOf(c = 123) == 0) {
            v = v.substring(1);
        }
        if (v.indexOf(c = 125) == v.length() - 1) {
            v = v.substring(0, v.length() - 1);
        }
        String[] split = v.split("\\.");
        return Arrays.asList(split);
    }

    @Override
    public boolean supportDynamicEL(XmlContext context, XmlKey key, Node node) {
        return true;
    }

    @Override
    public boolean supportDeferredEL(XmlContext context, XmlKey key, Node node) {
        return false;
    }

    @Override
    public boolean isEditingBodyOfExpression(XmlContext context, XmlKey key, Node node) {
        return false;
    }

    protected char getExpressionChar() {
        return '$';
    }

    private String _getValue(Node node) {
        if (node.getNodeType() == 2) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            return DomUtils.getTextNodeValue((Node)node);
        }
        return null;
    }

    private static String _removeSubstring(String source, String toRemove) {
        int index = source.indexOf(toRemove);
        int length = toRemove.length();
        if (index != -1) {
            if (index == 0) {
                source = source.substring(length);
            } else {
                Object temp = source.substring(0, index);
                if (index != source.length() - length) {
                    temp = (String)temp + source.substring(index + length);
                }
                source = temp;
            }
        }
        return source;
    }

    private String _getDefaultValue(XmlContext context, XmlKey attrKey) {
        return context.getModel().getXmlMetadataResolver().getDefaultValue(attrKey);
    }
}

