/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.DocumentTypeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.EntityRefLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.DocumentHandler;
import oracle.bali.xml.dom.buffer.parser.DocumentScannerScope;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;

public abstract class DocumentScanner {
    private ReadTextBuffer _buffer = null;
    private DocumentHandler _handler = null;
    private LocatorManager _manager = null;
    private Lexer _documentLexer = null;
    private Lexer _elementLexer = null;
    private ElementDeclaration _currentElementDecl = null;
    private boolean _reuseAttributeDecls = true;
    private int _caretPosition = -1;
    private boolean _stopRequested = false;
    private static final HashMap _predefinedEntities = new HashMap(13);
    private static final char[] _defaultEntityStartCharacters;

    public DocumentScanner(Lexer documentLexer, Lexer elementLexer) {
        if (documentLexer == null || elementLexer == null) {
            throw new IllegalArgumentException("DocumentScanner() parametersmust not be null");
        }
        this._documentLexer = documentLexer;
        this._elementLexer = elementLexer;
    }

    public final void scanDocument(ReadTextBuffer buffer, DocumentHandler handler, LocatorManager manager) {
        this.scanDocument(buffer, handler, manager, null);
    }

    public final void scanDocument(ReadTextBuffer buffer, DocumentHandler handler, LocatorManager manager, NamespaceDeclarations namespaceDecls) {
        this.scanDocument(buffer, handler, manager, namespaceDecls, -1);
    }

    public final void scanDocument(ReadTextBuffer buffer, DocumentHandler handler, LocatorManager manager, NamespaceDeclarations namespaceDecls, int caretPosition) {
        if (buffer == null || handler == null || manager == null) {
            throw new IllegalArgumentException("first three scanDocument() parameters must not be null");
        }
        boolean checkPosition = false;
        this._caretPosition = caretPosition;
        if (this._caretPosition > -1) {
            checkPosition = true;
        }
        this._stopRequested = false;
        this._handler = handler;
        this._buffer = buffer;
        this._manager = manager;
        this.initializeScannerState();
        this._documentLexer.setTextBuffer(this._buffer);
        this._documentLexer.setPosition(0);
        this._elementLexer.setTextBuffer(this._buffer);
        this._elementLexer.setPosition(0);
        this._currentElementDecl = new ElementDeclaration();
        if (namespaceDecls == null) {
            namespaceDecls = new NamespaceDeclarations();
        }
        this.addBuiltInNamespaceDeclarations(namespaceDecls);
        ArrayList<DocumentScannerScope> scopeStack = new ArrayList<DocumentScannerScope>();
        scopeStack.add(new DocumentScannerScope(-1));
        LexerToken documentToken = this._documentLexer.createLexerToken();
        this._documentLexer.lex(documentToken);
        boolean stopScanning = false;
        while (documentToken.getToken() != 0) {
            if (this._stopRequested || checkPosition && documentToken.getStartOffset() > this._caretPosition) {
                stopScanning = true;
                break;
            }
            this.parseDocumentToken(documentToken, namespaceDecls, scopeStack);
            this._documentLexer.lex(documentToken);
        }
        if (!stopScanning) {
            this.simulateEndElements(namespaceDecls, scopeStack, 0, documentToken.getStartOffset());
        }
        this.cleanupScannerState();
    }

    public void setReuseAttributeDeclarations(boolean reuseAttributeDecls) {
        this._reuseAttributeDecls = reuseAttributeDecls;
    }

    public void stopScanning() {
        this._stopRequested = true;
    }

    protected abstract boolean parseDocumentToken(LexerToken var1, NamespaceDeclarations var2, List var3);

    protected abstract boolean parseElementToken(LexerToken var1, ElementDeclaration var2, NamespaceDeclarations var3, DocumentScannerScope var4, int var5, int var6);

    protected abstract void addBuiltInNamespaceDeclarations(NamespaceDeclarations var1);

    protected void initializeScannerState() {
    }

    protected void cleanupScannerState() {
    }

    protected void preProcessElement(LexerToken documentToken, NamespaceDeclarations namespaceDecls, List scopeStack, boolean complete) {
    }

    protected void postProcessElement(ResolvedName elementName, ElementDeclaration elementDecl, NamespaceDeclarations namespaceDecls) {
    }

    protected void postProcessAttribute(ResolvedName attributeName, String attributeValue, NamespaceDeclarations namespaceDecls, DocumentScannerScope scannerScope) {
    }

    protected void updateAttributeNames(ResolvedName elementName, ElementDeclaration elementDecl, NamespaceDeclarations namespaceDecls, DocumentScannerScope proposedScope) {
    }

    protected ResolvedName createResolvedName(String rawName, NamespaceDeclarations namespaceDecls, boolean attributeName) {
        return new ResolvedName(rawName, namespaceDecls, attributeName);
    }

    protected void parseElement(LexerToken documentToken, NamespaceDeclarations namespaceDecls, List scopeStack, boolean complete) {
        this.preProcessElement(documentToken, namespaceDecls, scopeStack, complete);
        this._currentElementDecl.clear(this._reuseAttributeDecls);
        int elementStartOffset = documentToken.getStartOffset();
        int elementEndOffset = documentToken.getEndOffset();
        SimpleLocator tagLocator = this._manager.createSimpleLocator(elementStartOffset, elementEndOffset);
        ElementLocator elementLocator = this._manager.createElementLocator(tagLocator);
        elementLocator.setStartTagComplete(complete);
        this._currentElementDecl.setElementLocator(elementLocator);
        DocumentScannerScope currentScope = (DocumentScannerScope)scopeStack.get(scopeStack.size() - 1);
        DocumentScannerScope proposedScope = new DocumentScannerScope(currentScope.getNamespaceScope() + 1);
        int startOffset = 0;
        int endOffset = 0;
        int tokenValue = 0;
        LexerToken elementToken = this._elementLexer.createLexerToken();
        this._elementLexer.setPosition(elementStartOffset);
        this._elementLexer.lex(elementToken);
        while (elementToken.getEndOffset() <= elementEndOffset && elementToken.getToken() != 0) {
            tokenValue = elementToken.getToken();
            startOffset = elementToken.getStartOffset();
            endOffset = elementToken.getEndOffset();
            this.parseElementToken(elementToken, this._currentElementDecl, namespaceDecls, proposedScope, startOffset, endOffset);
            this._elementLexer.lex(elementToken);
        }
        if (this._currentElementDecl.getCurrentAttributeName() != null) {
            this.commitCurrentAttribute(this._currentElementDecl, namespaceDecls, proposedScope);
        }
        ResolvedName elementName = this.createResolvedName(this._currentElementDecl.getRawElementName(), namespaceDecls, false);
        proposedScope.setElementName(elementName);
        this.updateAttributeNames(elementName, this._currentElementDecl, namespaceDecls, proposedScope);
        this.postProcessElement(elementName, this._currentElementDecl, namespaceDecls);
        if (this._currentElementDecl.isStartTag()) {
            if (this._currentElementDecl.isEndTag()) {
                this._handler.handleEmptyElement(elementName, this._currentElementDecl.getAttributeDeclarations(), this._currentElementDecl.getElementLocator());
                namespaceDecls.removeNamespaceDeclarations(proposedScope.getNamespaceScope());
            } else {
                this._handler.handleStartElement(elementName, this._currentElementDecl.getAttributeDeclarations(), this._currentElementDecl.getElementLocator());
                scopeStack.add(proposedScope);
            }
        } else if (this._currentElementDecl.isEndTag()) {
            if (this.caretInsideLocator(tagLocator, this._caretPosition, complete)) {
                this._handler.handleEndElement(elementName, tagLocator, complete);
            } else {
                int iter;
                DocumentScannerScope iterScope = null;
                ResolvedName iterElementName = null;
                for (iter = scopeStack.size() - 1; !(iter <= 0 || (iterElementName = (iterScope = (DocumentScannerScope)scopeStack.get(iter)).getElementName()) != null && iterElementName.matches(elementName)); --iter) {
                }
                if (iter > 0) {
                    this.simulateEndElements(namespaceDecls, scopeStack, iter, tagLocator.getStartOffset());
                    this._handler.handleEndElement(elementName, tagLocator, true);
                    namespaceDecls.removeNamespaceDeclarations(iterScope.getNamespaceScope());
                    scopeStack.remove(iter);
                }
            }
        }
    }

    protected void parseElementName(LexerToken elementToken, ElementDeclaration elementDecl, NamespaceDeclarations namespaceDecls, DocumentScannerScope proposedScope, int startOffset, int endOffset) {
        elementDecl.setRawElementName(this.getStringValue(startOffset, endOffset));
        SimpleLocator nameLocator = this._manager.createSimpleLocator(startOffset, endOffset);
        elementDecl.getElementLocator().setNameLocator(nameLocator);
    }

    protected void parseAttributeName(LexerToken elementToken, ElementDeclaration elementDecl, NamespaceDeclarations namespaceDecls, DocumentScannerScope proposedScope, int startOffset, int endOffset) {
        if (elementDecl.getCurrentAttributeName() != null) {
            this.commitCurrentAttribute(elementDecl, namespaceDecls, proposedScope);
        }
        elementDecl.setCurrentAttributeName(this.getStringValue(startOffset, endOffset));
        elementDecl.setCurrentAttributeValue(null);
        SimpleLocator attrNameLocator = this._manager.createSimpleLocator(startOffset, endOffset);
        AttributeLocator locator = this._manager.createAttributeLocator(attrNameLocator);
        elementDecl.setCurrentAttributeLocator(locator);
    }

    protected void parseAttributeValue(LexerToken elementToken, ElementDeclaration elementDecl, NamespaceDeclarations namespaceDecls, DocumentScannerScope proposedScope, int startOffset, int endOffset) {
        AttributeLocator attributeLocator = elementDecl.getCurrentAttributeLocator();
        String attributeValue = this.parseAttributeValue(attributeLocator, startOffset, endOffset);
        elementDecl.setCurrentAttributeValue(attributeValue);
    }

    protected String parseAttributeValue(AttributeLocator attributeLocator, int startOffset, int endOffset) {
        int valueStartOffset = startOffset;
        int valueEndOffset = endOffset;
        short quoteStyle = 2;
        short quoteUsage = 3;
        if (valueEndOffset - valueStartOffset >= 1) {
            char firstChar = this._buffer.getChar(valueStartOffset);
            if (firstChar == '\"') {
                quoteStyle = 1;
            } else if (firstChar == '\'') {
                quoteStyle = 0;
            }
            if (quoteStyle != 2) {
                quoteUsage = 2;
                ++valueStartOffset;
            }
        }
        if (valueEndOffset - valueStartOffset >= 1) {
            char lastChar = this._buffer.getChar(valueEndOffset - 1);
            if (lastChar == '\"') {
                if (quoteStyle == 1) {
                    quoteUsage = 0;
                } else if (quoteStyle == 2) {
                    quoteStyle = 1;
                    quoteUsage = 1;
                }
            } else if (lastChar == '\'') {
                if (quoteStyle == 0) {
                    quoteUsage = 0;
                } else if (quoteStyle == 2) {
                    quoteStyle = 0;
                    quoteUsage = 1;
                }
            }
            if (quoteUsage == 0 || quoteUsage == 1) {
                --valueEndOffset;
            }
        }
        StringAndLocator attributeValue = this.parseContentString(valueStartOffset, valueEndOffset, true);
        attributeValue.loc.attach(this._manager, false);
        ArrayList<SimpleLocator> c = new ArrayList<SimpleLocator>(attributeValue.loc.getContentLocators());
        if (startOffset != valueStartOffset) {
            SimpleLocator first = (SimpleLocator)c.get(0);
            boolean firstIsEntity = first instanceof EntityRefLocator;
            if (first.getStartOffset() == valueStartOffset && !firstIsEntity) {
                first.setStartOffset(startOffset);
            } else {
                c.add(0, this._manager.createSimpleLocator(startOffset, valueStartOffset));
            }
        }
        if (endOffset != valueEndOffset) {
            SimpleLocator last = (SimpleLocator)c.get(c.size() - 1);
            boolean lastIsEntity = last instanceof EntityRefLocator;
            if (last.getEndOffset() == valueEndOffset && !lastIsEntity) {
                last.setEndOffset(endOffset);
            } else {
                c.add(this._manager.createSimpleLocator(valueEndOffset, endOffset));
            }
        }
        TextLocator tl = this._manager.createTextLocator(c, attributeValue.loc.getWhitespaceLocators());
        tl.attach(this._manager, true);
        if (attributeLocator != null) {
            attributeLocator.setValueLocator(tl);
            attributeLocator.setQuoteStyle(quoteStyle);
            attributeLocator.setQuoteUsage(quoteUsage);
        }
        return attributeValue.str;
    }

    protected void parseSymbol(LexerToken elementToken, ElementDeclaration elementDecl, NamespaceDeclarations namespaceDecls, DocumentScannerScope proposedScope, int startOffset, int endOffset) {
        for (int i = startOffset; i < endOffset; ++i) {
            char c = this._buffer.getChar(i);
            if (c == '/') {
                SimpleLocator slashLocator = this._manager.createSimpleLocator(startOffset, endOffset);
                elementDecl.getElementLocator().setSlashLocator(slashLocator);
                elementDecl.setEndTag(true);
                if (elementDecl.getRawElementName() != null) break;
                elementDecl.setStartTag(false);
                break;
            }
            if (c != '=') continue;
            SimpleLocator equalsLocator = this._manager.createSimpleLocator(startOffset, endOffset);
            AttributeLocator attrLocator = elementDecl.getCurrentAttributeLocator();
            if (attrLocator == null) break;
            attrLocator.setEqualsLocator(equalsLocator);
            break;
        }
    }

    protected final void simulateEndElements(NamespaceDeclarations namespaceDecls, List scopeStack, int indexToStop, int offset) {
        DocumentScannerScope iterScope = null;
        for (int iter = scopeStack.size() - 1; iter > indexToStop; --iter) {
            SimpleLocator locator = this._manager.createSimpleLocator(offset, offset);
            iterScope = (DocumentScannerScope)scopeStack.get(iter);
            this._handler.handleEndElement(iterScope.getElementName(), locator, true);
            namespaceDecls.removeNamespaceDeclarations(iterScope.getNamespaceScope());
            scopeStack.remove(iter);
        }
    }

    protected void commitCurrentAttribute(ElementDeclaration elementDecl, NamespaceDeclarations namespaceDecls, DocumentScannerScope scannerScope) {
        String rawAttributeName = elementDecl.getCurrentAttributeName();
        String attributeValue = elementDecl.getCurrentAttributeValue();
        AttributeLocator locator = elementDecl.getCurrentAttributeLocator();
        AttributeDeclarations attributeDecls = elementDecl.getAttributeDeclarations();
        ResolvedName attrName = this.createResolvedName(rawAttributeName, namespaceDecls, true);
        attributeDecls.addAttributeDeclaration(attrName, attributeValue, locator);
        this.postProcessAttribute(attrName, attributeValue, namespaceDecls, scannerScope);
    }

    protected void parseText(LexerToken documentToken) {
        int startOffset = documentToken.getStartOffset();
        int endOffset = documentToken.getEndOffset();
        this.parseText(startOffset, endOffset);
    }

    protected void parseText(int startOffset, int endOffset) {
        StringAndLocator result = this.parseContentString(startOffset, endOffset, false);
        this._handler.handleText(result.str, result.loc);
    }

    protected void parseComment(LexerToken documentToken) {
        int startOffset = documentToken.getStartOffset();
        int endOffset = documentToken.getEndOffset();
        SimpleLocator locator = this._manager.createSimpleLocator(startOffset, endOffset);
        if (endOffset - startOffset >= 4 && this._buffer.getChar(startOffset) == '<' && this._buffer.getChar(startOffset + 1) == '!' && this._buffer.getChar(startOffset + 2) == '-' && this._buffer.getChar(startOffset + 3) == '-') {
            startOffset += 4;
        }
        if (endOffset - startOffset >= 3 && this._buffer.getChar(endOffset - 1) == '>' && this._buffer.getChar(endOffset - 2) == '-' && this._buffer.getChar(endOffset - 3) == '-') {
            endOffset -= 3;
        }
        String text = this.getStringValue(startOffset, endOffset);
        this._handler.handleComment(text, locator);
    }

    protected void parseDocumentType(LexerToken documentToken, NamespaceDeclarations namespaceDecls, List scopeStack) {
        int startOffset = documentToken.getStartOffset();
        int endOffset = documentToken.getEndOffset();
        SimpleLocator locator = this._manager.createSimpleLocator(startOffset, endOffset);
        DocumentTypeLocator docTypeLocator = this._manager.createDocumentTypeLocator(locator);
        this._elementLexer.setPosition(startOffset);
        LexerToken elementToken = this._elementLexer.createLexerToken();
        this._elementLexer.lex(elementToken);
        String rootElementName = null;
        String publicID = null;
        String systemID = null;
        String inlineDTD = null;
        boolean docTypeIsPublic = false;
        int tokenStartOffset = this.findNextTokenStart(startOffset, endOffset);
        int tokenEndOffset = this.findTokenEnd(tokenStartOffset, endOffset);
        this._elementLexer.setPosition(tokenEndOffset);
        while ((tokenStartOffset = this.findNextTokenStart(tokenEndOffset, endOffset)) != -1) {
            this._elementLexer.setPosition(tokenStartOffset);
            switch (this.getBuffer().getChar(tokenStartOffset)) {
                case '\"': {
                    tokenEndOffset = this.findNameOrValueTokenEnd(this._elementLexer);
                    String tokenValue = "";
                    if (tokenEndOffset - tokenStartOffset > 2) {
                        tokenValue = this.getStringValue(tokenStartOffset + 1, tokenEndOffset - 1);
                    }
                    SimpleLocator valueLocator = null;
                    if (tokenValue != null && !tokenValue.isEmpty()) {
                        valueLocator = this._manager.createSimpleLocator(tokenStartOffset + 1, tokenEndOffset - 1);
                    }
                    if (publicID == null && docTypeIsPublic) {
                        publicID = tokenValue;
                        if (valueLocator == null) break;
                        docTypeLocator.setPublicIdLocator(valueLocator);
                        break;
                    }
                    systemID = tokenValue;
                    if (valueLocator == null) break;
                    docTypeLocator.setSystemIdLocator(valueLocator);
                    break;
                }
                case '[': {
                    inlineDTD = "";
                    if (endOffset - tokenStartOffset <= 3) break;
                    inlineDTD = this.getStringValue(tokenStartOffset + 1, endOffset - 2);
                    tokenEndOffset = endOffset - 1;
                    break;
                }
                default: {
                    tokenEndOffset = this.findNameOrValueTokenEnd(this._elementLexer);
                    String tokenValue = this.getStringValue(tokenStartOffset, tokenEndOffset);
                    if ("PUBLIC".equals(tokenValue)) {
                        docTypeIsPublic = true;
                        break;
                    }
                    if ("SYSTEM".equals(tokenValue)) {
                        docTypeIsPublic = false;
                        break;
                    }
                    if (rootElementName != null) break;
                    rootElementName = tokenValue;
                }
            }
            this._elementLexer.setPosition(tokenEndOffset++);
        }
        ResolvedName rootElement = this.createResolvedName(rootElementName, namespaceDecls, false);
        DocumentScannerScope currentScope = (DocumentScannerScope)scopeStack.get(scopeStack.size() - 1);
        DocumentScannerScope proposedScope = new DocumentScannerScope(currentScope.getNamespaceScope() + 1);
        this.handleDocumentType(namespaceDecls, proposedScope, rootElement, publicID, systemID, inlineDTD, locator, docTypeLocator);
    }

    protected void handleDocumentType(NamespaceDeclarations namespaceDecls, DocumentScannerScope proposedScope, ResolvedName rootElement, String publicID, String systemID, String inlineDTD, SimpleLocator locator, DocumentTypeLocator docTypeLocator) {
        this._handler.handleDocumentType(rootElement, publicID, systemID, locator, docTypeLocator);
    }

    protected StringAndLocator parseContentString(int startOffset, int endOffset, boolean inAttributeValue) {
        TextLocator resultLocator;
        String resultString;
        int length = endOffset - startOffset;
        if (length > 2) {
            ArrayList<SimpleLocator> contentLocators = new ArrayList<SimpleLocator>();
            StringBuffer resultBuffer = new StringBuffer(length);
            char[] chars = this._buffer.getChars(startOffset, length);
            char[] entityStartChars = this.getEntityStartCharacters(inAttributeValue);
            int startIndex = 0;
            boolean currentCharEntityStart = false;
            for (int currentIndex = 0; currentIndex < length; ++currentIndex) {
                char currentChar = chars[currentIndex];
                for (int i = 0; i < entityStartChars.length; ++i) {
                    if (currentChar != entityStartChars[i]) continue;
                    currentCharEntityStart = true;
                    break;
                }
                if (!currentCharEntityStart) continue;
                currentCharEntityStart = false;
                int entityEnd = this.findEntityEnd(chars, currentIndex);
                if (entityEnd < currentIndex) continue;
                if (currentIndex != startIndex) {
                    resultBuffer.append(chars, startIndex, currentIndex - startIndex);
                    contentLocators.add(this._manager.createSimpleLocator(startOffset + startIndex, startOffset + currentIndex));
                }
                int entityLength = entityEnd - currentIndex + 1;
                String entity = new String(chars, currentIndex, entityLength);
                String resolvedEntity = this.parseEntityReference(entity, inAttributeValue);
                resultBuffer.append(resolvedEntity);
                contentLocators.add(this._manager.createEntityRefLocator(startOffset + currentIndex, startOffset + entityEnd + 1, entity, resolvedEntity, true));
                currentIndex = entityEnd;
                startIndex = entityEnd + 1;
            }
            if (startIndex < length) {
                resultBuffer.append(chars, startIndex, length - startIndex);
                contentLocators.add(this._manager.createSimpleLocator(startOffset + startIndex, startOffset + length));
            }
            resultString = resultBuffer.toString();
            resultLocator = this._manager.createTextLocator(contentLocators);
        } else {
            resultString = this.getStringValue(startOffset, endOffset);
            SimpleLocator simple = this._manager.createSimpleLocator(startOffset, endOffset);
            resultLocator = this._manager.createTextLocator(Collections.singletonList(simple));
        }
        return new StringAndLocator(resultString, resultLocator);
    }

    protected char[] getEntityStartCharacters(boolean inAttributeValue) {
        return _defaultEntityStartCharacters;
    }

    protected int findEntityEnd(char[] chars, int entityStartIndex) {
        int entityEndIndex = -1;
        if (chars[entityStartIndex] == '&') {
            for (int currentIndex = entityStartIndex + 1; currentIndex < chars.length; ++currentIndex) {
                if (chars[currentIndex] != ';') continue;
                entityEndIndex = currentIndex;
                break;
            }
        }
        return entityEndIndex;
    }

    protected String parseEntityReference(String entityReference, boolean inAttributeValue) {
        String replacementText = null;
        try {
            if (entityReference.charAt(0) == '&') {
                String copy = entityReference.substring(1, entityReference.length() - 1);
                if (copy.charAt(0) == '#') {
                    int intValue;
                    if (copy.charAt(1) == 'x') {
                        copy = copy.substring(2);
                        intValue = Integer.parseInt(copy, 16);
                    } else {
                        copy = copy.substring(1);
                        intValue = Integer.parseInt(copy, 10);
                    }
                    char[] chars = Character.toChars(intValue);
                    replacementText = String.valueOf(chars);
                } else {
                    replacementText = this.getEntityReplacementText(copy);
                }
            }
        }
        catch (Exception e) {
            replacementText = null;
        }
        if (replacementText == null) {
            replacementText = entityReference;
        }
        return replacementText;
    }

    protected String getEntityReplacementText(String entityReference) {
        String replacementText = null;
        if (entityReference != null) {
            replacementText = (String)_predefinedEntities.get(entityReference);
        }
        return replacementText;
    }

    protected abstract int findNameOrValueTokenEnd(Lexer var1);

    protected final String getStringValue(int startOffset, int endOffset) {
        return new String(this._buffer.getChars(startOffset, endOffset - startOffset));
    }

    protected final int findNextTokenStart(int startOffset, int endOffset) {
        block3: for (int currentOffset = startOffset; currentOffset < endOffset; ++currentOffset) {
            char c = this._buffer.getChar(currentOffset);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            return currentOffset;
        }
        return -1;
    }

    protected final int findTokenEnd(int startOffset, int endOffset) {
        for (int currentOffset = startOffset; currentOffset < endOffset; ++currentOffset) {
            char c = this._buffer.getChar(currentOffset);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return currentOffset;
                }
            }
        }
        return endOffset;
    }

    protected final ReadTextBuffer getBuffer() {
        return this._buffer;
    }

    protected final LocatorManager getManager() {
        return this._manager;
    }

    protected final DocumentHandler getHandler() {
        return this._handler;
    }

    protected final Lexer getDocumentLexer() {
        return this._documentLexer;
    }

    protected final Lexer getElementLexer() {
        return this._elementLexer;
    }

    protected final int getCaretPosition() {
        return this._caretPosition;
    }

    protected final boolean caretInsideLocator(Locator locator, int caretPosition, boolean complete) {
        if (caretPosition > locator.getStartOffset()) {
            int endOffset = locator.getEndOffset();
            if (complete ? caretPosition < endOffset : caretPosition <= endOffset) {
                return true;
            }
        }
        return false;
    }

    static {
        _predefinedEntities.put("amp", "&");
        _predefinedEntities.put("lt", "<");
        _predefinedEntities.put("gt", ">");
        _predefinedEntities.put("apos", "'");
        _predefinedEntities.put("quot", "\"");
        _defaultEntityStartCharacters = new char[]{'&'};
    }

    protected static final class StringAndLocator {
        public final String str;
        public final TextLocator loc;

        public StringAndLocator(String str, TextLocator loc) {
            this.str = str;
            this.loc = loc;
        }
    }
}

