/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.writer;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.olapdv.connection.ConnectionManager;
import oracle.olapdv.util.jdbc.SQLParam;
import oracle.olapdv.util.jdbc.SQLWrapper;

public class CreateSchemaObjects {
    private static final Logger LOG = Logger.getLogger(CreateSchemaObjects.class.getName());

    public boolean create() {
        boolean bl = true;
        try {
            if (this.checkPrivilegesSatisfied()) {
                if (!this.tableExists("OLAP_DIM_DATA_VALIDATION")) {
                    this.createTable();
                }
                if (!this.tableExists("OLAP_DIM_VALIDATE_LAST_RUN")) {
                    this.createLastRunTable();
                } else if (!this.checkLastRunTableIsCurrent()) {
                    this.addModelOwnerToLastRunTable();
                }
                if (!this.sequenceExists()) {
                    this.createSequence();
                }
                bl = true;
            } else {
                LOG.log(Level.SEVERE, "In method create, user does not have either create table or create sequence privileges");
                bl = false;
            }
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method create, SQL Exception occurred.", sQLException);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPrivilegesSatisfied() {
        Connection connection = null;
        SQLParam sQLParam = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method checkPrivilegesSatisfied, SQL Exception occurred.", sQLException);
        }
        String string = "SELECT PRIVILEGE FROM SESSION_PRIVS";
        try {
            sQLParam = SQLWrapper.execute(connection, string);
            OracleResultSet oracleResultSet = sQLParam.getResultSet();
            while (oracleResultSet.next()) {
                String string2 = oracleResultSet.getString("PRIVILEGE");
                if (string2.equalsIgnoreCase("CREATE TABLE")) {
                    bl = true;
                    continue;
                }
                if (!string2.equalsIgnoreCase("CREATE SEQUENCE")) continue;
                bl2 = true;
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
        if (bl && bl2) {
            bl3 = true;
        }
        return bl3;
    }

    public boolean tableExists(String string) throws SQLException {
        Connection connection = null;
        SQLParam sQLParam = null;
        boolean bl = false;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method tableExists, SQL Exception occurred.", sQLException);
        }
        String string2 = "SELECT TABLE_NAME FROM USER_TABLES WHERE TABLE_NAME = '" + string + "'";
        try {
            sQLParam = SQLWrapper.execute(connection, string2);
            OracleResultSet oracleResultSet = sQLParam.getResultSet();
            while (oracleResultSet.next()) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
        return bl;
    }

    public boolean sequenceExists() throws SQLException {
        Connection connection = null;
        SQLParam sQLParam = null;
        boolean bl = false;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method sequenceExists, SQL Exception occurred.", sQLException);
        }
        String string = "SELECT SEQUENCE_NAME FROM USER_SEQUENCES WHERE SEQUENCE_NAME = 'OLAP_DIM_DATA_VALIDATE_SEQ'";
        try {
            sQLParam = SQLWrapper.execute(connection, string);
            OracleResultSet oracleResultSet = sQLParam.getResultSet();
            while (oracleResultSet.next()) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
        return bl;
    }

    private void createTable() throws SQLException {
        Connection connection = null;
        SQLParam sQLParam = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method createTable, SQL Exception occurred.", sQLException);
        }
        String string = "create table olap_dim_data_validation(row_key number not null, model_owner varchar2(30), model_name varchar2(30), dimension_name varchar2(30), hierarchy_name varchar2(30), level_name varchar2(30), parent_level_name varchar2(30), depth number, table_owner varchar2(128), dimension_table varchar2(128), member_column varchar2(128), description_column varchar2(128), parent_join_column varchar2(128), dimension_type varchar2(30), count_dist_mbr number, count_dist_desc number, count_null_mbr_rows number, count_null_desc_rows number, count_mp_mbr number, count_mp_desc number, count_mbr_with_null_desc number, count_mbr_with_mult_desc number, count_desc_with_mult_mbr number, count_nonunique_mbr number,last_time_validated varchar2(60), attributes varchar2(4000), properties varchar2(4000))";
        try {
            sQLParam = SQLWrapper.execute(connection, string);
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
    }

    private void createLastRunTable() throws SQLException {
        Connection connection = null;
        SQLParam sQLParam = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method createLastRunTable, SQL Exception occurred.", sQLException);
        }
        String string = "create table olap_dim_validate_last_run (model_owner varchar2(30), model_name varchar2(30), report_name varchar2(128), last_time_validated varchar2(60))";
        try {
            sQLParam = SQLWrapper.execute(connection, string);
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
    }

    private boolean checkLastRunTableIsCurrent() throws SQLException {
        Connection connection = null;
        SQLParam sQLParam = null;
        boolean bl = false;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method checkLastRunTableIsCurrent, SQL Exception occurred.", sQLException);
        }
        String string = "SELECT COLUMN_NAME FROM USER_TAB_COLUMNS WHERE TABLE_NAME = 'OLAP_DIM_VALIDATE_LAST_RUN' AND  COLUMN_NAME = 'MODEL_OWNER'";
        try {
            sQLParam = SQLWrapper.execute(connection, string);
            OracleResultSet oracleResultSet = sQLParam.getResultSet();
            while (oracleResultSet.next()) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
        return bl;
    }

    private void addModelOwnerToLastRunTable() throws SQLException {
        Connection connection = null;
        SQLParam sQLParam = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method addModelOwnerToLastRunTable, SQL Exception occurred.", sQLException);
        }
        String string = "ALTER TABLE OLAP_DIM_VALIDATE_LAST_RUN ADD MODEL_OWNER VARCHAR2(30)";
        try {
            sQLParam = SQLWrapper.execute(connection, string);
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
    }

    private void createSequence() throws SQLException {
        Connection connection = null;
        SQLParam sQLParam = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method createSequence, SQL Exception occurred.", sQLException);
        }
        String string = "create sequence olap_dim_data_validate_seq increment by 1 start with 1 minvalue 1 order";
        try {
            sQLParam = SQLWrapper.execute(connection, string);
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
    }
}

