/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.reader;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.table.Queries;
import oracle.olapdv.connection.ConnectionManager;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.ValidateModelDO;

public class ValidationReader {
    private static Queries queries;
    private static final String XMLFILE = "olapdvreaderqueries.xml";
    private Logger LOG = Logger.getLogger(ValidationReader.class.getName());
    private final String GET_VALIDATE_REPORT = "get_validate_report";
    private final String GET_LAST_TIME_VALIDATED = "get_last_time_validated";

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), (String)XMLFILE);
                JavaXMLBind.BindToJavaStr((String)string3, (String)string2, (Object)this);
            }
            catch (Exception exception) {
                this.LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        ValidationReader.queries = queries;
    }

    public void readValidateReport(ValidateModelDO validateModelDO) {
        Connection connection = null;
        String string = this.getQuery("get_validate_report");
        String string2 = validateModelDO.getModelOwner();
        String string3 = validateModelDO.getName();
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method readValidateReport, SQL Exception occurred.", sQLException);
        }
        if (validateModelDO.isEmpty()) {
            return;
        }
        for (DimensionDO dimensionDO : validateModelDO.getDimensionDOs()) {
            for (HierarchyDO hierarchyDO : dimensionDO.getHierarchyDOs()) {
                for (LevelDO levelDO : hierarchyDO.getLevelDOs()) {
                    String string4 = levelDO.getOwningDimensionName();
                    String string5 = levelDO.getOwningHierarchyName();
                    String string6 = levelDO.getName();
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("MODEL_OWNER", string2);
                    hashMap.put("MODEL_NAME", string3);
                    hashMap.put("DIMENSION_NAME", string4);
                    hashMap.put("HIERARCHY_NAME", string5);
                    hashMap.put("LEVEL_NAME", string6);
                    List list = dBUtil.executeReturnList(string, hashMap);
                    for (Map map : list) {
                        BigDecimal bigDecimal = (BigDecimal)map.get("COUNT_DIST_MBR");
                        if (bigDecimal == null) {
                            levelDO.setValidateReport("Distinct Members", -1);
                        } else {
                            levelDO.setValidateReport("Distinct Members", bigDecimal.intValue());
                        }
                        BigDecimal bigDecimal2 = (BigDecimal)map.get("COUNT_DIST_DESC");
                        if (bigDecimal2 == null) {
                            levelDO.setValidateReport("Distinct Members And Descriptions", -1);
                        } else {
                            levelDO.setValidateReport("Distinct Members And Descriptions", bigDecimal2.intValue());
                        }
                        BigDecimal bigDecimal3 = (BigDecimal)map.get("COUNT_NULL_MBR_ROWS");
                        if (bigDecimal3 == null) {
                            levelDO.setValidateReport("Rows With Null Members", -1);
                        } else {
                            levelDO.setValidateReport("Rows With Null Members", bigDecimal3.intValue());
                        }
                        BigDecimal bigDecimal4 = (BigDecimal)map.get("COUNT_NULL_DESC_ROWS");
                        if (bigDecimal4 == null) {
                            levelDO.setValidateReport("Members With Null Descriptions", -1);
                        } else {
                            levelDO.setValidateReport("Members With Null Descriptions", bigDecimal4.intValue());
                        }
                        BigDecimal bigDecimal5 = (BigDecimal)map.get("COUNT_MBR_WITH_MULT_DESC");
                        if (bigDecimal5 == null) {
                            levelDO.setValidateReport("Members With Multiple Descriptions", -1);
                        } else {
                            levelDO.setValidateReport("Members With Multiple Descriptions", bigDecimal5.intValue());
                        }
                        BigDecimal bigDecimal6 = (BigDecimal)map.get("COUNT_DESC_WITH_MULT_MBR");
                        if (bigDecimal6 == null) {
                            levelDO.setValidateReport("Descriptions With Multiple Members", -1);
                        } else {
                            levelDO.setValidateReport("Descriptions With Multiple Members", bigDecimal6.intValue());
                        }
                        BigDecimal bigDecimal7 = (BigDecimal)map.get("COUNT_MP_MBR");
                        if (bigDecimal7 == null) {
                            levelDO.setValidateReport("Members With Multiple Parents", -1);
                        } else {
                            levelDO.setValidateReport("Members With Multiple Parents", bigDecimal7.intValue());
                        }
                        BigDecimal bigDecimal8 = (BigDecimal)map.get("COUNT_MP_DESC");
                        if (bigDecimal7 == null) {
                            levelDO.setValidateReport("Descriptions With Multiple Parent Descriptions", -1);
                        } else {
                            levelDO.setValidateReport("Descriptions With Multiple Parent Descriptions", bigDecimal8.intValue());
                        }
                        BigDecimal bigDecimal9 = (BigDecimal)map.get("COUNT_NONUNIQUE_MBR");
                        if (bigDecimal9 == null) {
                            levelDO.setValidateReport("Duplicate Members Across Levels", -1);
                        } else {
                            levelDO.setValidateReport("Duplicate Members Across Levels", bigDecimal9.intValue());
                        }
                        String string7 = (String)map.get("LAST_TIME_VALIDATED");
                        if (string7 == null || string7.length() == 0) {
                            if (validateModelDO.getLastTimeValidated() != null && !validateModelDO.getLastTimeValidated().equalsIgnoreCase("NEVER")) continue;
                            validateModelDO.setLastTimeValidated("Never");
                            continue;
                        }
                        if (string7.equalsIgnoreCase("NEVER")) {
                            if (validateModelDO.getLastTimeValidated() != null && !validateModelDO.getLastTimeValidated().equalsIgnoreCase("NEVER")) continue;
                            validateModelDO.setLastTimeValidated("Never");
                            continue;
                        }
                        validateModelDO.setLastTimeValidated(string7);
                    }
                }
            }
        }
        this.readValidateLastTimeRun(validateModelDO);
    }

    public void readValidateLastTimeRun(ValidateModelDO validateModelDO) {
        if (validateModelDO.isEmpty()) {
            return;
        }
        String[] stringArray = new String[]{"Distinct Members", "Distinct Members And Descriptions", "Duplicate Members Across Levels", "Rows With Null Members", "Members With Null Descriptions", "Members With Multiple Descriptions", "Descriptions With Multiple Members", "Members With Multiple Parents", "Descriptions With Multiple Parent Descriptions"};
        for (int i = 0; i < 9; ++i) {
            String string = stringArray[i];
            this.readValidateReportLastRunRow(validateModelDO, string);
        }
    }

    private void readValidateReportLastRunRow(ValidateModelDO validateModelDO, String string) {
        Connection connection = null;
        String string2 = this.getQuery("get_last_time_validated");
        String string3 = validateModelDO.getModelOwner();
        String string4 = validateModelDO.getName();
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method readValidateReportLastRunRow, SQL Exception occurred.", sQLException);
        }
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        dBUtil.setRaiseError(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("MODEL_OWNER", string3);
        hashMap.put("MODEL_NAME", string4);
        hashMap.put("REPORT_NAME", string);
        List list = dBUtil.executeReturnList(string2, hashMap);
        for (Map map : list) {
            String string5 = (String)map.get("LAST_TIME_VALIDATED");
            validateModelDO.setReportLastTimeValidated(string, string5);
        }
    }
}

