/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.controls.grid.ColumnAutoSizer;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.treetable.QueryModel;
import oracle.dbtools.raptor.controls.treetable.SerializedData;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.editors.AbstractDBEditor;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.plsql.PLSQLController;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.RaptorQueryUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.treetable.JTreeTable;
import oracle.javatools.ui.treetable.TreeTableModelAdapter;
import oracle.javatools.util.ModelUtil;
import oracle.sql.NUMBER;

public abstract class MasterDetailPanel
extends AbstractDBEditor {
    private JSplitPane ret;
    public ResultSetTable parentTbl;
    protected JTable[] childTbls;
    protected final JTabbedPane tabbedPane = new JTabbedPane();
    private IdeAction _refreshAction;
    private IdeAction _toolbarAction;
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_Tbl_Editor");
    private Object lastValue = "-1";
    private int activeTab = 0;

    public void open() {
        this.setEditorAttribute("horizontal_scrollbar_policy", 31);
        this.setEditorAttribute("vertical_scrollbar_policy", 21);
        Context context = this.getContext();
        PlSqlNode plSqlNode = (PlSqlNode)context.getNode();
        plSqlNode.addListener((Observer)this);
        this._refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)Messages.getString("Refresh"), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true);
        this._refreshAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                try {
                    MasterDetailPanel.this.parentTbl.refresh();
                }
                catch (ExecutionException executionException) {
                    Logger.getLogger(MasterDetailPanel.class.getName()).log(Level.SEVERE, executionException.getLocalizedMessage(), executionException);
                }
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return false;
            }
        });
    }

    public Component getGUI() {
        Object object;
        Object object2;
        Object object3;
        if (this.ret == null) {
            JScrollPane jScrollPane;
            QueryModel queryModel;
            this.loadDBData();
            if (this.parentTbl == null) {
                this.parentTbl = new ResultSetTable();
                object3 = (PlSqlNode)this.getContext().getNode();
                object2 = this.getConnectionName();
                if (object2 == null || !ModelUtil.hasLength((String)object2) || !((PlSqlNode)object3).dictionarySupported()) {
                    return this.parentTbl;
                }
                object = this.parentQuery();
                object = RaptorQueryUtils.promoteToDba((String)object, this.getConnection());
                queryModel = this.scanBinds((String)object);
                this.parentTbl.setQuery((String)object2, (String)object, (List<?>)queryModel, null);
                ColumnAutoSizer.autoResizeTable((JTable)((Object)this.parentTbl), (String)ColumnAutoSizer.AUTO_FIT_OPTIMUM);
            }
            this.parentTbl.setSelectionMode(0);
            object3 = this.parentTbl.getSelectionModel();
            object3.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        return;
                    }
                    if ("Warning".equalsIgnoreCase(MasterDetailPanel.this.parentTbl.getColumnName(0))) {
                        return;
                    }
                    int n = listSelectionModel.getMinSelectionIndex();
                    Integer n2 = null;
                    try {
                        n2 = ((NUMBER)MasterDetailPanel.this.parentTbl.getModel().getValueAt(n, 0)).intValue();
                    }
                    catch (SQLException sQLException) {
                        return;
                    }
                    catch (ClassCastException classCastException) {
                        return;
                    }
                    if (MasterDetailPanel.this.lastValue.equals(n2)) {
                        return;
                    }
                    MasterDetailPanel.this.lastValue = n2;
                    MasterDetailPanel.this.updateActiveTab(n2);
                }
            });
            if (this.childTbls == null) {
                this.childTbls = new JTable[this.childQueries().length];
                for (int i = 0; i < this.childTbls.length; ++i) {
                    this.childTbls[i] = new ResultSetTable();
                    object = this.childQueries()[i].toLowerCase();
                    if (!((String)object).contains("connect by") || !((String)object).contains("parent_id,")) continue;
                    try {
                        queryModel = new QueryModel(this.childQueries()[i], this.getConnection());
                        jScrollPane = queryModel.createGUI();
                        SerializedData.initColumnWidths((JTreeTable)jScrollPane);
                        this.childTbls[i] = jScrollPane;
                        continue;
                    }
                    catch (Exception exception) {
                        Logger.getLogger(MasterDetailPanel.class.getName()).log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                    }
                }
            }
            object2 = new JScrollPane((Component)((Object)this.parentTbl));
            this.tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (MasterDetailPanel.this.activeTab == MasterDetailPanel.this.tabbedPane.getSelectedIndex()) {
                        return;
                    }
                    MasterDetailPanel.this.activeTab = MasterDetailPanel.this.tabbedPane.getSelectedIndex();
                    MasterDetailPanel.this.updateActiveTab(MasterDetailPanel.this.lastValue);
                }
            });
            object = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        int n = MasterDetailPanel.this.tabbedPane.getSelectedIndex();
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        for (JMenuItem jMenuItem : MasterDetailPanel.this.popupMenu(n)) {
                            jPopupMenu.add(jMenuItem);
                        }
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            };
            this.tabbedPane.addMouseListener((MouseListener)object);
            for (int i = 0; i < this.childTbls.length; ++i) {
                jScrollPane = new JScrollPane(this.childTbls[i]);
                this.tabbedPane.add(this.tabNames()[i], jScrollPane);
            }
            this.ret = new JSplitPane(0, (Component)object2, this.tabbedPane);
            Toolbar toolbar = this.getFixedTopMargin();
            if (toolbar.getComponentCount() == 0) {
                toolbar.add((ToggleAction)this._refreshAction);
            }
            try {
                this.parentTbl.refresh();
            }
            catch (Exception exception) {
                PLSQLController.LOGGER.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
        }
        if (this._toolbarAction == null) {
            this._toolbarAction = XMLBasedObjectAction.getInstance().getIdeAction().newLocalAction((View)this);
            object3 = (PlSqlNode)this.getContext().getNode();
            object2 = XMLBasedObjectAction.getInstance().getMenu(new DBObject(object3.getURL()));
            if (((Container)object2).getComponentCount() > 0) {
                object = this.getFixedTopMargin().add((ToggleAction)this._toolbarAction);
                object.setName(this._toolbarAction.getValue("Name").toString());
                object.setText(Messages.getString("InfoPanel.Actions"));
                object.setIcon(OracleIcons.getIcon((String)"extras/dropdown.png"));
                object.setToolTipText(Messages.getString("InfoPanel.AvailableActions"));
                this._toolbarAction.putValue("BUTTON", object);
            }
        }
        return this.ret;
    }

    public JMenuItem[] popupMenu(int n) {
        return new JMenuItem[0];
    }

    private void setSelection() {
        int n = this.parentTbl.getModel().getRowCount() - 1;
        if (n != -1) {
            try {
                this.parentTbl.setRowSelectionInterval(n, n);
                this.parentTbl.setColumnSelectionInterval(1, 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void updateActiveTab(Object object) {
        String[] stringArray = this.childQueries();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = RaptorQueryUtils.promoteToDba(stringArray[i], this.getConnection());
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string : this.scanBinds(stringArray[this.activeTab])) {
            arrayList.add(object);
        }
        if (this.childTbls[this.activeTab] instanceof ResultSetTable) {
            var4_5 = (ResultSetTable)((Object)this.childTbls[this.activeTab]);
            if (((ResultSetTable)((Object)var4_5)).getGridModel() == null) {
                ((ResultSetTable)((Object)var4_5)).setQuery(this.getConnectionName(), stringArray[this.activeTab], arrayList, null);
                try {
                    ((ResultSetTable)((Object)var4_5)).open(true);
                }
                catch (ExecutionException executionException) {
                    Logger.getLogger(MasterDetailPanel.class.getName()).log(Level.SEVERE, executionException.getLocalizedMessage(), executionException);
                }
            } else {
                ((ResultSetTable)((Object)var4_5)).getGridModel().setBindList(arrayList);
            }
            ColumnAutoSizer.autoResizeTable((JTable)this.childTbls[this.activeTab], (String)ColumnAutoSizer.AUTO_FIT_OPTIMUM);
            try {
                var4_5.refresh();
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(MasterDetailPanel.class.getName()).log(Level.SEVERE, executionException.getLocalizedMessage(), executionException);
            }
        } else if (this.childTbls[this.activeTab] instanceof JTreeTable) {
            String string;
            var4_5 = (JTreeTable)this.childTbls[this.activeTab];
            string = (QueryModel)((TreeTableModelAdapter)var4_5.getModel()).getTreeTableModel();
            string.query(arrayList);
            string.reload(var4_5.getTree());
        }
    }

    protected List<String> scanBinds(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = LexerToken.parse((String)string);
        boolean bl = false;
        for (LexerToken lexerToken : list) {
            if (bl) {
                if ("OBJECT_OWNER".equalsIgnoreCase(lexerToken.content) || "SCHEMA".equalsIgnoreCase(lexerToken.content)) {
                    arrayList.add(this.getSchemaName());
                } else if ("OBJECT_NAME".equalsIgnoreCase(lexerToken.content)) {
                    arrayList.add(this.getObjectName());
                } else if ("OBJECT_ID".equalsIgnoreCase(lexerToken.content)) {
                    arrayList.add(this.getObjectId());
                } else if ("OBJECT_TYPE".equalsIgnoreCase(lexerToken.content)) {
                    arrayList.add(this.getObjectType());
                } else {
                    arrayList.add("Invalid");
                }
            }
            bl = ":".equals(lexerToken.content);
        }
        return arrayList;
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage == null) {
            this.ret = null;
        }
    }

    public String getConnectionName() {
        PlSqlNode plSqlNode = (PlSqlNode)this.getContext().getNode();
        return plSqlNode.getConnectionName();
    }

    public abstract String parentQuery();

    public abstract String[] childQueries();

    public abstract String[] tabNames();
}

