/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.sql.Connection;
import javax.swing.Icon;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.db.xml.XmlNavigatorUtils;
import oracle.dbtools.raptor.navigator.filter.FilterDetails;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.xml.navigator.ConnectionTypeElement;
import oracle.dbtools.xml.navigator.IconElement;
import oracle.javatools.util.ModelUtil;

public class ConnectionTypeDetails {
    public static final float UNORDERED = 100.0f;
    private String m_type;
    private boolean m_otherSchemasSupported;
    private boolean m_showAllSchemasAtTopLevel;
    private boolean m_supportsCatalogs;
    private String m_providerClass;
    private String m_panelClass;
    private boolean m_rowid;
    private String m_iconKey;
    private Icon m_icon;
    private NavigatorDescriptor m_desc;
    private String m_panelLabel;
    private Version m_minVer;
    private Version m_maxVer;

    protected ConnectionTypeDetails() {
    }

    void init(ConnectionTypeElement connectionTypeElement, NavigatorDescriptor navigatorDescriptor) {
        this.m_desc = navigatorDescriptor;
        this.m_type = connectionTypeElement.getType();
        this.m_otherSchemasSupported = connectionTypeElement.isOtherSchemasSupport();
        this.m_showAllSchemasAtTopLevel = connectionTypeElement.isShowAllSchemas();
        this.m_supportsCatalogs = connectionTypeElement.isSupportsCatalogs();
        this.m_providerClass = connectionTypeElement.getProviderClass();
        this.m_rowid = connectionTypeElement.isSupportsRowID();
        IconElement iconElement = connectionTypeElement.getIcon();
        this.m_iconKey = iconElement != null ? iconElement.getKey() : null;
        this.m_panelClass = connectionTypeElement.getPanelClass();
        this.m_panelLabel = connectionTypeElement.getPanelLabel();
        this.m_minVer = connectionTypeElement.getMinimumVersion();
        this.m_maxVer = connectionTypeElement.getMaximumVersion();
    }

    private static Version createVersion(String string) {
        return ModelUtil.hasLength((String)string) ? new Version(string) : null;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean isOtherSchemasSupported() {
        return this.m_otherSchemasSupported;
    }

    public boolean isSchedulerSupported() {
        return this.m_otherSchemasSupported;
    }

    public String getProviderClass() {
        return this.m_providerClass;
    }

    public boolean isShowAllSchemasAtTopLevel() {
        return this.m_showAllSchemasAtTopLevel;
    }

    public boolean isSupportsCatalog() {
        return this.m_supportsCatalogs;
    }

    public boolean isRowIdSupported() {
        return this.m_rowid;
    }

    public Icon getIcon() {
        if (this.m_icon == null && this.m_iconKey != null) {
            this.m_icon = XmlNavigatorUtils.getIcon(this.m_iconKey, this.m_desc);
        }
        return this.m_icon;
    }

    public String getConnectionPanel() {
        return this.m_panelClass;
    }

    public String getConnectionPanelLabel() {
        return this.m_panelLabel;
    }

    public Integer getPreferredFetchSize() {
        return null;
    }

    public boolean isSupportsAutocommit() {
        return false;
    }

    public boolean isOracle() {
        return false;
    }

    public float getWeight() {
        return 100.0f;
    }

    public FilterDetails getFilterDetails() {
        return new FilterDetails();
    }

    public Version getMinimumVersion() {
        return this.m_minVer;
    }

    public Version getMaximumVersion() {
        return this.m_maxVer;
    }

    public DefaultNLSProvider getNLSProvider(Connection connection) {
        return new DefaultNLSProvider(connection){};
    }

    public static ConnectionTypeDetails getTypeDetails(String string, Connection connection) {
        ConnectionTypeDetails connectionTypeDetails = null;
        ObjectFactory objectFactory = ObjectFactory.getFactory(string, connection);
        if (objectFactory != null) {
            connectionTypeDetails = objectFactory.getConnectionTypeDescriptor().getImpl();
        }
        return connectionTypeDetails;
    }

    public boolean isColumnTypeSortable(int n) {
        return false;
    }

    public Icon getIcon(DBItemInstance dBItemInstance) {
        return null;
    }
}

