/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.CustomDateOrder;
import oracle.dbtools.raptor.data.core.DateOrder;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class DataFormatPanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = -881116672384492403L;
    private JTextField timeDelimiterTextfield;
    private JTextField dateDelimiterTextfield;
    private JTextField logicalFalseTextField;
    private JTextField logicalTrueTextField;
    private JTextField currencySymbolTextfield;
    private JTextField thousandSeparatorTextfield;
    private JTextField decimalSymbolTextField;
    private JComboBox dateOrderComboBox;
    private JTextField dataLastRowTextField;
    private JTextField dataFirstRowTextfield;
    private JCheckBox leadingZerosInCheckBox;
    private JCheckBox fourDigitYearsCheckBox;
    private GridBagConstraints leadConstraints = new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0);
    private boolean customDateType = false;
    private GridBagConstraints fourConstraints = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 5), 0, 0);
    private GridBagConstraints otherFormatConstraints = new GridBagConstraints(1, 5, 2, 2, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 5), 0, 0);
    private JComboBox customDateTypes = new JComboBox<String>(CustomDateOrder.getInstance().getOrders());
    private ImportProperties _iProps;

    public DataFormatPanel() {
        this.jbInit();
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        jDialog.add((Component)((Object)new DataFormatPanel()));
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }

    public JTextField getTimeDelimiterTextfield() {
        return this.timeDelimiterTextfield;
    }

    public void setTimeDelimiterTextfield(String string) {
        this.timeDelimiterTextfield.setText(string);
    }

    public String getDateDelimiterTextfield() {
        return this.dateDelimiterTextfield.getText();
    }

    public void setDateDelimiter(String string) {
        this.dateDelimiterTextfield.setText(string);
    }

    public String getLogicalFalseField() {
        return this.logicalFalseTextField.getText();
    }

    public void setLogicalFalseTextField(String string) {
        this.logicalFalseTextField.setText(string);
    }

    public String getLogicalTrueTextField() {
        return this.logicalTrueTextField.getText();
    }

    public void setLogicalTrueTextField(String string) {
        this.logicalTrueTextField.setText(string);
    }

    public JTextField getCurrencySymbolTextfield() {
        return this.currencySymbolTextfield;
    }

    public void setCurrencySymbol(String string) {
        this.currencySymbolTextfield.setText(string);
    }

    public JTextField getThousandSeparatorTextfield() {
        return this.thousandSeparatorTextfield;
    }

    public void setThousandSeparator(String string) {
        this.thousandSeparatorTextfield.setText(string);
    }

    public String getDecimalSymbol() {
        return this.decimalSymbolTextField.getText();
    }

    public void setDecimalSymbol(String string) {
        this.decimalSymbolTextField.setText(string);
    }

    public JComboBox getDateOrderComboBox() {
        return this.dateOrderComboBox;
    }

    public void setDateOrderComboBox(String[] stringArray) {
        this.dateOrderComboBox = new JComboBox<String>(stringArray);
    }

    public String getDataLastRowTextField() {
        return this.dataLastRowTextField.getText();
    }

    public void setDataLastRowTextField(JTextField jTextField) {
        this.dataLastRowTextField = jTextField;
    }

    public String getDataFirstRowTextfield() {
        return this.dataFirstRowTextfield.getText();
    }

    public void setDataFirstRowTextfield(String string) {
        this.dataFirstRowTextfield.setText(string);
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("FORMAT_DATA_FILE_LOC")));
        JLabel jLabel = new JLabel();
        jLabel.setText(DataImportArb.getString("FORMAT_DATA_FIRST_ROW"));
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 20, 5, 5), 0, 0));
        this.dataFirstRowTextfield = new JTextField();
        jPanel.add((Component)this.dataFirstRowTextfield, new GridBagConstraints(2, 1, 1, 1, 2.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 70, 0));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DataImportArb.getString("FORMAT_DATA_LAST_ROW"));
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 5, 5), 0, 0));
        this.dataLastRowTextField = new JTextField();
        jPanel.add((Component)this.dataLastRowTextField, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 70, 0));
        this.add(jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("FORMAT_DATA_TIME_TITLE")));
        this.add(jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(DataImportArb.getString("FORMAT_DATA_DATE_ORDER"));
        jPanel2.add((Component)jLabel3, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.dateOrderComboBox = new JComboBox<DateOrder>(DateOrder.values());
        this.dateOrderComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                DataFormatPanel.this.customDateType = (DateOrder)((Object)jComboBox.getSelectedItem()) == DateOrder.CUSTOM;
                DataFormatPanel.this.switchUIDateType();
            }
        });
        jPanel2.add((Component)this.dateOrderComboBox, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(DataImportArb.getString("FORMAT_DATA_DECIMAL_SYMBOL"));
        jPanel2.add((Component)jLabel4, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.decimalSymbolTextField = new JTextField();
        jPanel2.add((Component)this.decimalSymbolTextField, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 50, 0));
        this.fourDigitYearsCheckBox = new JCheckBox();
        this.fourDigitYearsCheckBox.setText(DataImportArb.getString("FORMAT_DATA_FOUR_DIGIT_YEARS"));
        jPanel2.add((Component)this.fourDigitYearsCheckBox, this.fourConstraints);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(DataImportArb.getString("FORMAT_DATA_THOUSAND_SEPARATOR"));
        jPanel2.add((Component)jLabel5, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.thousandSeparatorTextfield = new JTextField();
        jPanel2.add((Component)this.thousandSeparatorTextfield, new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 50, 0));
        this.leadingZerosInCheckBox = new JCheckBox();
        this.leadingZerosInCheckBox.setText(DataImportArb.getString("FORMAT_DATA_LEADING_ZEROS"));
        jPanel2.add((Component)this.leadingZerosInCheckBox, this.leadConstraints);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(DataImportArb.getString("FORMAT_DATA_CURRENCY_SYMBOL"));
        jPanel2.add((Component)jLabel6, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.currencySymbolTextfield = new JTextField();
        jPanel2.add((Component)this.currencySymbolTextfield, new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 50, 0));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(DataImportArb.getString("FORMAT_DATA_DATE_DELIMITER"));
        jPanel2.add((Component)jLabel7, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.dateDelimiterTextfield = new JTextField();
        jPanel2.add((Component)this.dateDelimiterTextfield, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 70, 0));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText(DataImportArb.getString("FORMAT_DATA_LOGICAL_VALUES"));
        jPanel2.add((Component)jLabel8, new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.logicalTrueTextField = new JTextField();
        jPanel2.add((Component)this.logicalTrueTextField, new GridBagConstraints(4, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 50, 0));
        this.logicalFalseTextField = new JTextField();
        jPanel2.add((Component)this.logicalFalseTextField, new GridBagConstraints(5, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 50, 0));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText(DataImportArb.getString("FORMAT_DATA_TIME_DELIMITER"));
        jPanel2.add((Component)jLabel9, new GridBagConstraints(1, 9, 1, 1, 0.0, 1.0, 12, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.timeDelimiterTextfield = new JTextField();
        jPanel2.add((Component)this.timeDelimiterTextfield, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 70, 0));
    }

    private void switchUIDateType() {
        if (this.customDateType) {
            this.remove(this.leadingZerosInCheckBox);
            this.remove(this.fourDigitYearsCheckBox);
            this.add(this.customDateTypes, this.otherFormatConstraints);
        } else {
            this.remove(this.customDateTypes);
            this.add(this.leadingZerosInCheckBox, this.leadConstraints);
            this.add(this.fourDigitYearsCheckBox, this.fourConstraints);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance();
        this.setDecimalSymbol(dBConfig.getString("NLS_DEC_SEP"));
        this.setThousandSeparator(dBConfig.getString("NLS_GRP_SEP"));
        this.setCurrencySymbol(dBConfig.getString("NLS_CURR"));
        this.setDateDelimiter(dBConfig.getString("NLS_DATE_FORM"));
        this.setLogicalFalseTextField(dBConfig.getString("DATA_IMPORT_FALSE"));
        this.setLogicalFalseTextField(dBConfig.getString("DATA_IMPORT_TRUE"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
    }
}

