/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.controls.BindInfo;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.display.IModifyToolbar;
import oracle.dbtools.raptor.controls.display.ISelectionChangeListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.tabbedpane.CustomTabbedPaneUI;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.icons.OracleIcons;

public class DisplayPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String NO_REFRESH = "no.refresh.in.toolbar";
    public static final String NO_RUN = "no.run.in.toolbar";
    private Toolbar _toolbar;
    private DisplayPanel _parent = null;
    private DisplayModel _model;
    private JSplitPane _splitPane;
    private JTabbedPane _tabbed;
    private IDisplay _main = null;
    private List<IDisplay> _children = new ArrayList<IDisplay>();
    private List<DisplayPanel> _childPanels = new ArrayList<DisplayPanel>();
    JEWTDialog dlg;
    boolean renderDisplay = true;
    boolean _building = false;
    private JComboBox _timerInterval;
    private Timer _timer;
    private TimerTask _tt;
    private boolean prompt;
    protected RaptorTaskAdapter _taskListener;
    boolean _isEnableRefresh = true;
    protected ISelectionChangeListener selectionChangeListener = new SelectChanged();
    private Map<String, Object> _binds;
    private boolean _forceBindPrompt = false;
    boolean _force;
    boolean _detail;

    public DisplayPanel(DisplayModel displayModel) {
        this(displayModel, null, true, null);
    }

    public DisplayPanel(DisplayModel displayModel, boolean bl) {
        this(displayModel, null, bl, null);
    }

    public DisplayPanel(DisplayModel displayModel, Map<String, Object> map, boolean bl, Toolbar toolbar) {
        this.init(displayModel, map, bl, toolbar);
    }

    private void init(DisplayModel displayModel, Map<String, Object> map, boolean bl, Toolbar toolbar) {
        this.setLayout(new BorderLayout());
        this._toolbar = toolbar == null ? new Toolbar() : toolbar;
        if (null == this._toolbar.getParent()) {
            this.add((Component)this._toolbar, "First");
        }
        this._taskListener = new TaskListener();
        this._binds = map;
        if (displayModel == null) {
            this._model = new DisplayModel();
        } else {
            this._model = displayModel;
            this.close();
            this.buildUI(bl);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DisplayPanel.this.buildToolbar();
                }
            });
            if (map != null) {
                this.setChildBinds(map);
            }
        }
        if (this._main != null && this._binds != null) {
            this._main.appendBindMap(this._binds);
        }
    }

    public ArrayList<IDisplay> getChildren() {
        return (ArrayList)this._children;
    }

    public DisplayPanel(DisplayModel displayModel, DisplayPanel displayPanel, Toolbar toolbar) {
        this._parent = displayPanel;
        this.init(displayModel, null, true, toolbar);
    }

    public void setChildBinds(Map<String, Object> map) {
        for (IDisplay iDisplay : this._children) {
            iDisplay.setConnName(this.getConnectionName());
            iDisplay.appendBindMap(map);
        }
    }

    private void buildToolbar() {
        Object object;
        Object object2;
        this.addToolbarActions();
        if (!Boolean.parseBoolean((String)this._model.getExtValues().get(NO_RUN))) {
            object2 = new AbstractAction(Messages.getString("DisplayPanel.6"), OracleIcons.getIcon((String)"refresh.png")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (null == DisplayPanel.this._parent) {
                        DisplayPanel.this.refresh(false, true);
                    } else {
                        DisplayPanel.this._parent.selectionChangeListener.parentSelectionChanged();
                    }
                }
            };
            ((AbstractAction)object2).putValue("ShortDescription", Messages.getString("DisplayPanel.33"));
            this._toolbar.add((Action)object2);
            this._toolbar.addSeparator();
        }
        if (!Boolean.parseBoolean((String)this._model.getExtValues().get(NO_REFRESH))) {
            object2 = new JLabel(Messages.getString("DisplayPanel.10"));
            this._timerInterval = new JComboBox();
            object = (DefaultComboBoxModel)this._timerInterval.getModel();
            ((DefaultComboBoxModel)object).addElement(0);
            ((DefaultComboBoxModel)object).addElement(5);
            ((DefaultComboBoxModel)object).addElement(10);
            ((DefaultComboBoxModel)object).addElement(15);
            ((DefaultComboBoxModel)object).addElement(20);
            ((DefaultComboBoxModel)object).addElement(25);
            ((DefaultComboBoxModel)object).addElement(30);
            ((DefaultComboBoxModel)object).addElement(60);
            ((DefaultComboBoxModel)object).addElement(120);
            this._timerInterval.setMaximumSize(this._timerInterval.getMinimumSize());
            this._timerInterval.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        if (DisplayPanel.this._timer != null) {
                            DisplayPanel.this.cancelTimer();
                            DisplayPanel.this.prompt = true;
                        }
                        if (!DisplayPanel.this._timerInterval.getSelectedItem().equals("0")) {
                            DisplayPanel.this._timer = new Timer();
                            DisplayPanel.this._tt = new TimerTask(){

                                @Override
                                public void run() {
                                    if (DisplayPanel.this.getConnection() != null) {
                                        DisplayPanel.this.prompt = false;
                                        DisplayPanel.this.refresh(false, true);
                                    }
                                }
                            };
                            int n = (Integer)DisplayPanel.this._timerInterval.getSelectedItem();
                            if (n > 0) {
                                DisplayPanel.this._timer.scheduleAtFixedRate(DisplayPanel.this._tt, 0L, (long)n * 1000L);
                            }
                        }
                    }
                }
            });
            this._toolbar.add((Component)object2);
            this._toolbar.add((Component)this._timerInterval);
            this._toolbar.addSeparator();
        }
        if ((object2 = (String)this._model.getExtValues().get("ToolbarExtra")) != null) {
            try {
                object = this._model.getCl();
                if (object == null) {
                    object = this.getClass().getClassLoader();
                }
                IModifyToolbar iModifyToolbar = ((ClassLoader)object).loadClass((String)object2).asSubclass(IModifyToolbar.class).newInstance();
                iModifyToolbar.modifyToolbar(this._toolbar, this._binds);
            }
            catch (Exception exception) {
                Logger.severe(this.getClass(), (Throwable)exception);
            }
        }
    }

    public IDisplay getMainUI() {
        return this._main;
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public Connection getConnection() {
        Connection connection = null == this._model ? null : this._model.getConnection();
        return connection;
    }

    public DisplayModel getModel() {
        return this._model;
    }

    public void setModel(DisplayModel displayModel) {
        if (this._main == null || this._model != displayModel) {
            this._model = displayModel;
            this.close();
            this.buildUI();
        } else {
            this.refresh();
        }
    }

    public void setMainPanelBinds(Map<String, Object> map) {
        this._binds = map;
    }

    private void initTabbedPane() {
        this._tabbed = new JTabbedPane();
        this._tabbed.setUI((TabbedPaneUI)new CustomTabbedPaneUI());
        this._splitPane = new JSplitPane();
        this._splitPane.setOneTouchExpandable(true);
        this._splitPane.setContinuousLayout(true);
        this._splitPane.setOrientation(0);
        this._splitPane.setTopComponent(this.getEditorContent());
        this._splitPane.setBottomComponent(this._tabbed);
        double d = 0.5;
        this._splitPane.setResizeWeight(d);
        String string = this.getMainUI().getExtValues().get("SplitPaneResizeWeight");
        if (string != null) {
            try {
                d = Double.valueOf(string);
                this._splitPane.setResizeWeight(d);
            }
            catch (Throwable throwable) {
                Logger.warn(this.getClass(), (String)"XML display/CustomValue/SplitPaneResizeWeight does not represent a double value between 0 and 1", (Throwable)throwable);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DisplayPanel.this._splitPane.setDividerLocation(0.5);
                }
            });
        }
        this.add((Component)this._splitPane, "Center");
        this._tabbed.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Logger.finer(this.getClass(), (String)"DisplayPanel.stateChanged() has fired...");
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                Component component = jTabbedPane.getSelectedComponent();
                if (component.isShowing() && !DisplayPanel.this._building) {
                    DisplayPanel displayPanel = (DisplayPanel)component;
                    displayPanel.refresh();
                }
            }
        });
    }

    private void buildUI() {
        this.buildUI(false);
    }

    private void buildUI(boolean bl) {
        Logger.finer(this.getClass(), (String)"DisplayPanel.buildUI()");
        this._building = true;
        try {
            if (this._model == null) {
                return;
            }
            this._main = this._model.getDisplayInstance();
            this._main.addSelectionChangeListener(this.selectionChangeListener);
            this._main.addTaskListener((IRaptorTaskListener)this._taskListener);
            this._main.setToolbar(this._toolbar);
            if (this._model.hasChildren()) {
                this.initTabbedPane();
                DisplayPanel displayPanel = null;
                for (DisplayModel displayModel : this._model.getChildren()) {
                    displayPanel = new DisplayPanel(displayModel, this, null);
                    IDisplay iDisplay = displayPanel.getMainUI();
                    this._children.add(iDisplay);
                    this._childPanels.add(displayPanel);
                    if (iDisplay instanceof ISelectionChangeListener) {
                        this._main.addSelectionChangeListener((ISelectionChangeListener)((Object)iDisplay));
                    }
                    this._tabbed.addTab(displayModel.getName(), displayModel.getIcon(), displayPanel);
                }
            } else {
                this.add((Component)this.getEditorContent(), "Center");
            }
        }
        catch (Exception exception) {
            Logger.severe(this.getClass(), (Throwable)exception);
        }
        if (this._model.getQuery(this.getConnection()) == null) {
            this.displayNoQuery();
            return;
        }
        if (this._model.getQueriesBindMap() != null) {
            this._main.appendBindMap(this._model.getQueriesBindMap());
        } else if (this._parent == null && this._binds == null && !bl) {
            this.promptForBind(this._model.getQuery(this.getConnection()));
        } else if (this._binds != null) {
            this._main.appendBindMap(this._binds);
        }
        if (!bl && this.renderDisplay) {
            this.refresh();
        }
        this._building = false;
    }

    public JComponent getPanelContent() {
        if (this._model.hasChildren()) {
            return this._splitPane;
        }
        return this.getEditorContent();
    }

    private JComponent getEditorContent() {
        if (null == this.getParentPanel() && this._model.isUseEditorScrollPane()) {
            return this._main.getUI();
        }
        if (this._main.isUseEditorScrollPane() || this._main.isUseScrollableUI()) {
            return this._main.getScrollableUI();
        }
        return this._main.getUI();
    }

    private List<ObjectAction> getModelActions() {
        List<ObjectAction> list = null;
        DisplayModel displayModel = this.getModel();
        if (displayModel != null) {
            list = displayModel.getActions();
        }
        return list != null ? list : Collections.emptyList();
    }

    private void addToolbarActions() {
        for (ObjectAction objectAction : this.getModelActions()) {
            if (!objectAction.isToolbar()) continue;
            IdeAction ideAction = objectAction.getAction();
            boolean bl = true;
            for (Component component : this._toolbar.getComponents()) {
                if (!(component instanceof ToolButton) || ((ToolButton)component).getAction() != ideAction) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this._toolbar.add((ToggleAction)ideAction);
        }
    }

    public String getConnectionName() {
        return this._model != null ? this._model.getConnName() : null;
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean bl) {
        Logger.finer(this.getClass(), (String)"DisplayPanel.Refresh()");
        this.refresh(true, bl);
    }

    public void clear() {
        if (this._main != null) {
            this._main.clear();
        }
        for (IDisplay iDisplay : this._children) {
            iDisplay.clear();
        }
    }

    public void close() {
        this.cancelTimer();
        for (IDisplay iDisplay : this._children) {
            if (iDisplay == null) continue;
            iDisplay.close();
        }
        this._children.clear();
        if (this._main != null) {
            this._main.close();
        }
        if (this._splitPane != null && this._splitPane.getParent() != null) {
            this._splitPane.getParent().remove(this._splitPane);
        }
    }

    public void displayNoQuery() {
        JLabel jLabel = new JLabel(Messages.getString("DisplayPanel.MISSING_KEY"));
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)jLabel, null, (String)Messages.getString("DisplayPanel.27"), (int)1);
        this.dlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplayPanel.this.dlg.dispose();
            }
        });
        this.dlg.setSize(500, 150);
        this.dlg.setPreferredSize(500, 150);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    public void promptForBind(Query query) {
        if (query.getBinds().size() > 0) {
            this.renderDisplay = false;
            BindInfo bindInfo = new BindInfo(query);
            HelpSystem.getHelpSystem().registerTopic((JComponent)bindInfo, "f1_bindnulldefault_html");
            this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)bindInfo, null, (String)Messages.getString("DisplayPanel.BIND_TITLE"), (int)14);
            this.dlg.setDefaultButton(8);
            this.dlg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayPanel.this.renderDisplay = true;
                    DisplayPanel.this.dlg.dispose();
                }
            });
            this.dlg.pack();
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
            this.dlg.setVisible(true);
        } else {
            this.renderDisplay = true;
        }
    }

    public void promptForBindsOnNextRun(boolean bl) {
        this._forceBindPrompt = bl;
    }

    public boolean preRefresh() {
        return this._main.preRefresh();
    }

    public void refresh(boolean bl, boolean bl2) {
        this._force = bl2;
        this._detail = bl;
        DisplayModel displayModel = this.getModel();
        Logger.finer(this.getClass(), (String)("DisplayPanel.Refresh(" + bl + "} for " + displayModel.getName()));
        Connection connection = displayModel.getConnection(false);
        Query query = displayModel.getQuery(connection);
        if (query == null && this._binds != null || !RaptorVersionTracker.checkVersion(connection, query.getMaxversion(), query.getMinversion())) {
            this.displayNoQuery();
            return;
        }
        if (displayModel.getParent() == null) {
            if (this._parent == null && this._binds == null && this.prompt) {
                this.promptForBind(query);
                this._forceBindPrompt = false;
            }
            if (this._forceBindPrompt) {
                this.promptForBind(query);
                this._forceBindPrompt = false;
            }
        } else {
            this._main.appendBindMap(this._model.getQueriesBindMap());
            this._binds = this._model.getQueriesBindMap();
        }
        if (!this.renderDisplay) {
            return;
        }
        this.refreshCurrentChild(this._detail);
        this._main.setConnName(this.getConnectionName());
        this._main.setQuery(query);
        if (this._binds != null) {
            this._main.appendBindMap(this._binds);
        } else if (this._parent == null) {
            this._main.appendBindMap(this._model.getQuery(this.getConnection()).getBindValues());
        } else {
            this._main.appendBindMap(this._parent.getMainUI().getBindMap());
        }
        this._main.refresh(this._force);
    }

    public boolean isRenderDisplay() {
        return this.renderDisplay;
    }

    private void refreshCurrentChild(boolean bl) {
        if (this._children == null || this._children.size() == 0 || this._tabbed == null) {
            return;
        }
        IDisplay iDisplay = ((DisplayPanel)this._tabbed.getSelectedComponent()).getMainUI();
        iDisplay.clear();
        assert (iDisplay != null);
        if (this._binds != null) {
            iDisplay.appendBindMap(this._binds);
        } else if (this._parent != null) {
            iDisplay.appendBindMap(this._parent.getMainUI().getBindMap());
        } else {
            iDisplay.replaceBindMap(null);
        }
        boolean bl2 = false;
        Map<String, Object> map = iDisplay.getBindMap();
        for (Bind bind : iDisplay.getQuery().getBinds()) {
            if (null != bind.getValue() || null != map && map.containsKey(bind.getName())) continue;
            bl2 = true;
            String string = iDisplay.getDisplayModel().getName() + " missing binding for " + bind.getName();
            Logger.warn(this.getClass(), (String)string);
            break;
        }
        if (!bl2) {
            iDisplay.refresh(bl);
        }
    }

    public DisplayPanel getParentPanel() {
        return this._parent;
    }

    public void setParentPanel(DisplayPanel displayPanel) {
        this._parent = displayPanel;
    }

    public Component getFocusedComponent() {
        return this.getFocusedComponent(this);
    }

    public Component getFocusedComponent(Component component) {
        Component component2 = null;
        if (component.hasFocus()) {
            component2 = component;
        } else if (component instanceof Container) {
            for (int i = 0; component2 == null && i < ((Container)component).getComponentCount(); ++i) {
                component2 = this.getFocusedComponent(((Container)component).getComponent(i));
            }
        }
        return component2;
    }

    private void updateToolbarActions(boolean bl) {
        if (this.isVisible()) {
            Action[] actionArray;
            for (Action action : actionArray = this._toolbar.getActions()) {
                action.setEnabled(bl);
            }
        }
    }

    protected void showErrorMessage(RaptorTaskEvent raptorTaskEvent) {
        RaptorTaskUtils.showErrorMessage((String)this.getConnectionName(), (Component)this, (RaptorTaskDescriptor)raptorTaskEvent.getTaskDescriptor());
    }

    public String getModelName() {
        return this._model.getName();
    }

    private void setEnableRefresh(boolean bl) {
        this._isEnableRefresh = bl;
        if (bl) {
            if (this._timerInterval != null && !this._timerInterval.isEnabled()) {
                this._timerInterval.setEnabled(true);
            }
        } else if (this._timerInterval != null && this._timerInterval.isEnabled()) {
            if (!this._timerInterval.getSelectedItem().equals(0)) {
                this._timerInterval.setSelectedItem(0);
            }
            this._timerInterval.setEnabled(false);
            this.cancelTimer();
        }
    }

    public boolean isEnableRefresh() {
        return this._isEnableRefresh;
    }

    public void cancelTimer() {
        if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
    }

    public void setTimerInterval(JComboBox jComboBox) {
        this._timerInterval = jComboBox;
    }

    private class SelectChanged
    implements ISelectionChangeListener {
        private SelectChanged() {
        }

        @Override
        public void parentSelectionChanged() {
            for (IDisplay iDisplay : DisplayPanel.this._children) {
                iDisplay.clear();
                iDisplay.setConnName(DisplayPanel.this.getConnectionName());
                iDisplay.appendBindMap(DisplayPanel.this._binds);
                Map<String, Object> map = DisplayPanel.this._main.getBinds(null);
                iDisplay.appendBindMap(map);
                iDisplay.setDirty(true);
                Component component = DisplayPanel.this._tabbed.getSelectedComponent();
                DisplayPanel displayPanel = null;
                if (component instanceof DisplayPanel) {
                    displayPanel = (DisplayPanel)component;
                }
                if (displayPanel != null && displayPanel.getMainUI() != iDisplay) continue;
                iDisplay.refresh(true);
            }
        }
    }

    private class TaskListener
    extends RaptorTaskAdapter {
        private TaskListener() {
        }

        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DisplayPanel.this.updateToolbarActions(false);
                    DisplayPanel.this.setEnableRefresh(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DisplayPanel.this.updateToolbarActions(true);
                    DisplayPanel.this.setEnableRefresh(false);
                    DisplayPanel.this.showErrorMessage(raptorTaskEvent);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DisplayPanel.this.updateToolbarActions(true);
                    DisplayPanel.this.setEnableRefresh(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DisplayPanel.this.updateToolbarActions(true);
                    DisplayPanel.this.setEnableRefresh(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

