/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.display.SQLDevXMLFactory;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.metadata.AbstractDisplayModel;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.support.MetaXMLReference;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Logger;
import oracle.ide.util.GuidGen;
import oracle.javatools.db.DBException;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;

public class DisplayModel
extends AbstractDisplayModel<DisplayModel, ObjectAction>
implements Cloneable {
    protected String m_connName = null;
    protected MetaClass<?> m_deleteClass = null;
    protected MetaClass<?> m_insertClass = null;
    protected MetaClass<?> m_updateClass = null;
    private boolean _useEditorScrollPane;
    private IDisplay _referenceDisplay;

    public DisplayModel() {
        this.setName("");
        this.setDescription("");
        this.setToolTip("");
        this.setEnable(true);
        this.setType("");
        this.setStyle("");
    }

    public static DisplayModel getDisplayModel(MetaXMLReference metaXMLReference, XLIFFHelper xLIFFHelper) {
        DisplayModel displayModel = null;
        String string = XMLHelper.getAttributeNode((Node)metaXMLReference.getNode(), (String)"sharedId");
        if (string != null && !string.equals("")) {
            displayModel = DisplayModelCache.getDisplayModel(string);
        }
        if (displayModel == null) {
            displayModel = (DisplayModel)SQLDevXMLFactory.getInstance().createDisplayModel(metaXMLReference.getNode(), metaXMLReference.getReferenceClassLoader(), xLIFFHelper);
        }
        if (displayModel.getID() != null) {
            DisplayModelCache.putDisplayModel(displayModel);
        }
        return displayModel;
    }

    public DisplayModel(String string, String string2, String string3, String string4) {
        this.setName(this.notNull(string));
        this.setDescription(this.notNull(string2));
        this.setToolTip(this.notNull(string4));
        this.setEnable(Boolean.parseBoolean(this.notNullBoolean(string3)));
        this.setType("");
        this.setStyle("");
    }

    public String notNull(String string) {
        if (string == null || string.equals("null")) {
            return "";
        }
        return string;
    }

    public String notNullBoolean(String string) {
        if (string == null || string.equals("null")) {
            return "false";
        }
        return "true";
    }

    public Icon getIcon() {
        if (this.getIconName() != null && super.getIcon() == null) {
            this.setIcon(RaptorImage.getIcon((String)this.getIconName()));
        }
        return super.getIcon();
    }

    public boolean isChangeable() {
        return super.isChangeable() || this.m_insertClass != null || this.m_updateClass != null || this.m_deleteClass != null;
    }

    public String getConnName() {
        if (null == this.m_connName && this.m_conn != null) {
            this.setConnName(Connections.getInstance().getConnectionName(this.m_conn));
        }
        return this.m_connName;
    }

    public void setConnName(String string) {
        if (ModelUtil.areDifferent((Object)this.m_connName, (Object)string)) {
            this.m_connName = string;
            this.m_conn = null;
            if (this.hasChildren()) {
                for (DisplayModel displayModel : this.getChildren()) {
                    displayModel.setConnName(string);
                }
            }
        }
    }

    public Connection getConnection() {
        return this.getConnection(true);
    }

    public Connection getConnection(boolean bl) {
        if (this.m_connName != null) {
            try {
                this.m_conn = Connections.getInstance().getConnection(this.m_connName, bl);
                this.setDbVersion(this.m_conn);
            }
            catch (DBException dBException) {
                Logger.warn(this.getClass(), (Throwable)dBException);
            }
        }
        return this.m_conn;
    }

    void setConnection(Connection connection) {
        if (this.m_conn != connection) {
            this.m_conn = connection;
            this.setDbVersion(connection);
            if (this.hasChildren()) {
                for (DisplayModel displayModel : this.getChildren()) {
                    displayModel.setConnection(connection);
                }
            }
        }
    }

    public MetaClass<?> getDeleteClass() {
        return this.m_deleteClass;
    }

    public void setDeleteClass(MetaClass<?> metaClass) {
        this.m_deleteClass = metaClass;
    }

    public MetaClass<?> getInsertClass() {
        return this.m_insertClass;
    }

    public void setInsertClass(MetaClass<?> metaClass) {
        this.m_insertClass = metaClass;
    }

    public MetaClass<?> getUpdateClass() {
        return this.m_updateClass;
    }

    public void setUpdateClass(MetaClass<?> metaClass) {
        this.m_updateClass = metaClass;
    }

    private boolean checkVersion(Query query) {
        Version version = query.getMinversion();
        Version version2 = query.getMaxversion();
        return this.getDbVersion() == null || (version == null || version.compareTo(this.getDbVersion()) <= 0) && (version2 == null || version2.compareTo(this.getDbVersion()) >= 0);
    }

    public Query getQuery(Connection connection) {
        return this.getQuery(connection, false, false);
    }

    public Query getQuery(Connection connection, boolean bl, boolean bl2) {
        Connection connection2 = this.m_conn;
        this.m_conn = connection;
        Query query = this.getQuery(bl, bl2, false);
        this.m_conn = connection2;
        return query;
    }

    public Query strictGetQuery(Connection connection, boolean bl, boolean bl2) {
        Connection connection2 = this.m_conn;
        this.m_conn = connection;
        Query query = this.getQuery(bl, bl2, true);
        this.m_conn = connection2;
        return query;
    }

    public String getIndent(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 9;
        }
        return new String(cArray);
    }

    public String toXML(int n) {
        return this.toXML(new StringBuffer(), n).toString();
    }

    public StringBuffer toXML(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.getIndent(n) + "<display");
        stringBuffer.append(" id=\"" + this.getID() + "\"");
        stringBuffer.append(" type=\"" + this.getType() + "\"");
        stringBuffer.append(" style=\"" + this.getStyle() + "\"");
        stringBuffer.append(" enable=\"" + this.getEnable() + "\"");
        if (this.getExtAttributes() != null) {
            for (Object object : this.getExtAttributes().keySet()) {
                stringBuffer.append(" " + (String)object + "=\"" + (String)this.getExtAttributes().get(object) + "\"");
            }
        }
        stringBuffer.append(">\n");
        this.appendCDataElement(stringBuffer, this.getIndent(n + 1), "name", this.getName());
        this.appendCDataElement(stringBuffer, this.getIndent(n + 1), "description", this.getDescription());
        this.appendCDataElement(stringBuffer, this.getIndent(n + 1), "tooltip", this.getToolTip());
        this.appendCDataElement(stringBuffer, this.getIndent(n + 1), "drillclass", this.getDrillClass());
        if (this.getExtValues() != null) {
            stringBuffer.append(this.getIndent(n + 1) + "<CustomValues>\n");
            for (Object object : this.getExtValues().keySet()) {
                this.appendCDataElement(stringBuffer, this.getIndent(n + 2), (String)object, (String)this.getExtValues().get(object));
            }
            stringBuffer.append(this.getIndent(n + 1) + "</CustomValues>\n");
        }
        if (this.getQueries() != null) {
            for (Object object : this.getQueries()) {
                stringBuffer.append(object.toXML(n + 1));
            }
        }
        if (this.getChildren() != null) {
            for (Object object : this.getChildren()) {
                stringBuffer.append(((DisplayModel)object).toXML(n + 1));
            }
        }
        if (this.getActions() != null) {
            for (Object object : this.getActions()) {
                ((ObjectAction)((Object)object)).toXML(stringBuffer);
            }
        }
        stringBuffer.append(this.getIndent(n) + "</display>\n");
        return stringBuffer;
    }

    private void appendCDataElement(StringBuffer stringBuffer, String string, String string2, String string3) {
        stringBuffer.append(string + "<" + string2 + "><![CDATA[" + (string3 != null ? string3.replace("]]>", "]]]]><![CDATA[>") : "") + "]]></" + string2 + ">\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayModel clone() {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        StringReader stringReader = null;
        try {
            stringReader = new StringReader(this.toXML(0));
            dOMParser.parse((Reader)stringReader);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        finally {
            if (stringReader != null) {
                try {
                    stringReader.close();
                }
                catch (Exception exception) {
                    Logger.ignore(this.getClass(), (Throwable)exception);
                }
            }
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        Node node = xMLDocument.getChildNodes().item(0);
        DisplayModel displayModel = (DisplayModel)SQLDevXMLFactory.getInstance().createDisplayModel(node, this.getCl(), null);
        displayModel.setID(GuidGen.toString((byte[])GuidGen.uuidCreate()));
        return displayModel;
    }

    private MetaClass<?> createClassReference(String string, ClassLoader classLoader) {
        return string != null && string.length() > 0 ? new MetaClass(classLoader, string) : null;
    }

    public IDisplay getDisplayInstance() {
        IDisplay iDisplay = this.safeGetDisplayInstance();
        if (iDisplay != null) {
            iDisplay.setDisplayModel(this);
            iDisplay.setId(this.getID());
            iDisplay.setConnName(this.getConnName());
            iDisplay.setQuery(this.getQuery(this.getConnection()));
            iDisplay.setExtValues(this.getExtValues());
            iDisplay.setType(this.getType());
            iDisplay.addActions(this.getActions());
        }
        return iDisplay;
    }

    private IDisplay safeGetDisplayInstance() {
        IDisplay iDisplay = null;
        try {
            iDisplay = DisplayRegistry.getInstanceFor(this.getStyle());
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        return iDisplay;
    }

    public boolean isUseEditorScrollPane() {
        boolean bl = this._useEditorScrollPane && !this.hasChildren();
        IDisplay iDisplay = null;
        if (bl && (iDisplay = this.getReferenceDisplay()) != null) {
            bl = iDisplay.isUseEditorScrollPane();
        }
        return bl;
    }

    public void enableUseEditorScrollPane(boolean bl) {
        this._useEditorScrollPane = bl;
    }

    private IDisplay getReferenceDisplay() {
        if (null == this._referenceDisplay) {
            this._referenceDisplay = this.getDisplayInstance();
        }
        return this._referenceDisplay;
    }
}

