/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.cellrenderers;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.controls.cellrenderers.GaugeTableCellRenderer;
import oracle.dbtools.raptor.controls.cellrenderers.ICellDisplayValue;
import oracle.dbtools.raptor.controls.cellrenderers.ICellRenderer;
import oracle.dbtools.raptor.controls.cellrenderers.LinkCellRenderer;
import oracle.sql.CHAR;

public class CellRenderingFactory {
    private static Map<Class<?>, Stack<ICellDisplayValue>> displayValuers = new HashMap();
    private static Map<Class<?>, Stack<TableCellRenderer>> renderers = new HashMap();

    public static void registerCellRenderer(Class<?> clazz, ICellRenderer iCellRenderer) {
        if (iCellRenderer instanceof TableCellRenderer) {
            CellRenderingFactory.registerCellRenderer(clazz, (TableCellRenderer)iCellRenderer);
        }
        if (iCellRenderer instanceof ICellDisplayValue) {
            CellRenderingFactory.registerCellRenderer(clazz, (ICellDisplayValue)iCellRenderer);
        }
    }

    public static void registerCellRenderer(Class<?> clazz, TableCellRenderer tableCellRenderer) {
        if (tableCellRenderer != null) {
            if (renderers.get(clazz) == null) {
                renderers.put(clazz, new Stack());
            }
            renderers.get(clazz).push(tableCellRenderer);
        }
    }

    public static void registerCellRenderer(Class<?> clazz, ICellDisplayValue iCellDisplayValue) {
        if (iCellDisplayValue != null) {
            if (displayValuers.get(clazz) == null) {
                displayValuers.put(clazz, new Stack());
            }
            displayValuers.get(clazz).push(iCellDisplayValue);
        }
    }

    public static String getText(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = null;
        if (object != null && displayValuers.get(object.getClass()) != null) {
            for (ICellDisplayValue iCellDisplayValue : displayValuers.get(object.getClass())) {
                try {
                    string = iCellDisplayValue.getText(jTable, object, bl, bl2, n, n2);
                    if (string == null) continue;
                    return string;
                }
                catch (Exception exception) {
                    Logger.getLogger(CellRenderingFactory.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
        return string;
    }

    public static Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = null;
        if (object != null && renderers.get(object.getClass()) != null) {
            for (TableCellRenderer tableCellRenderer : renderers.get(object.getClass())) {
                try {
                    component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (component == null) continue;
                    return component;
                }
                catch (Exception exception) {
                    Logger.getLogger(CellRenderingFactory.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
        return component;
    }

    static {
        CellRenderingFactory.registerCellRenderer(CHAR.class, new GaugeTableCellRenderer());
        CellRenderingFactory.registerCellRenderer(CHAR.class, new LinkCellRenderer());
    }
}

